/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.requestnote;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.ReqNoteEnum;

public class RequestNoteEdit
extends AbstractFormPlugin {
    private static String[] propArr = new String[]{"excurrency", "org", "defcurrency"};

    private void updateExQuote(int focusRow, String currenin, String currenout, String quote, String priceruleName) {
        DynamicObject pricerule = (DynamicObject)this.getModel().getValue(priceruleName);
        DynamicObject currentypein = (DynamicObject)this.getModel().getValue(currenin, focusRow);
        DynamicObject currentypeout = (DynamicObject)this.getModel().getValue(currenout, focusRow);
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pricerule, currentypein, currentypeout})) {
            String currOutno;
            String currInno = (String)currentypein.get("number");
            if (StringUtils.equals((CharSequence)currInno, (CharSequence)(currOutno = (String)currentypeout.get("number")))) {
                this.getModel().setValue(quote, null, focusRow);
                return;
            }
            String currenpair = currInno + "/" + currOutno;
            long id = pricerule.getLong("forexquote.id");
            ForexQuoteInfo quoteinfo = null;
            try {
                quoteinfo = MarketDataServiceHelper.getForexQuoteInfo((Long)id, (String)currenpair, null, (Date)new Date());
            }
            catch (Exception e) {
                this.getView().showTipNotification(e.getMessage());
                this.getModel().setValue(quote, null, focusRow);
                return;
            }
            this.getModel().setValue(quote, (Object)quoteinfo.getFxquote(), focusRow);
        }
    }

    protected void doAfterCurrChange(int focusRow, String foAmountIn, String currencytypeIn, String currencytypeOut, String exQuotation) {
        this.getModel().setValue(foAmountIn, null, focusRow);
        this.priceRuleNotify();
        this.updateExQuote(focusRow, currencytypeIn, currencytypeOut, exQuotation, "pricerule");
    }

    protected void setRateEnable(int focusRow, String quotName, String rateBot, String rateTop) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(quotName, focusRow))) {
            this.getView().setEnable(Boolean.valueOf(false), focusRow, new String[]{rateBot});
            this.getView().setEnable(Boolean.valueOf(false), focusRow, new String[]{rateTop});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), focusRow, new String[]{rateBot});
            this.getView().setEnable(Boolean.valueOf(true), focusRow, new String[]{rateTop});
        }
    }

    private void priceRuleNotify() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("pricerule"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9a\u4ef7\u89c4\u5219\u83b7\u53d6\u8d27\u5e01\u5bf9\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u3002", (String)"RequestNoteEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    protected void updateQuotePR() {
        if (this.getModel().getValue("producttype") == null || !"tm_reqnote".equals(this.getModel().getDataEntity().getDataEntityType().getName())) {
            return;
        }
        DynamicObject productType = (DynamicObject)this.getModel().getValue("producttype");
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(productType.getString("id"))) {
            this.updateExQuoteByFormId("forwardinfo", "currencytypein", "currencytypeout", "exchangequotation");
        } else if (ProductTypeEnum.FOREXSPOT.getId().equals(productType.getString("id"))) {
            this.updateExQuoteByFormId("spotinfo", "spotcurrencytypein", "spotcurrencytypeout", "spotexchangequotation");
        } else if (ProductTypeEnum.FOREXOPTION.getId().equals(productType.getString("id"))) {
            this.updateExQuoteByFormId("optionsinfo", "opcurrin", "opcurrout", "opquote");
        } else if (ProductTypeEnum.FOREXSWAPS.getId().equals(productType.getString("id"))) {
            this.updateSwExQuote();
        }
    }

    private void updateSwExQuote() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("swapsinfo");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String end = (String)this.getModel().getValue("end", i);
            if (!"nearend".equals(end)) continue;
            this.updateExQuote(i, "currin", "currout", "quote", "pricerule");
            this.updateExQuote(i + 1, "currin", "currout", "quote", "pricerule");
        }
    }

    protected void updateExQuoteByFormId(String forwardinfo, String currencytypeIn, String currencytypeOut, String exQuotation) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(forwardinfo);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryEntity)) {
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            this.updateExQuote(i, currencytypeIn, currencytypeOut, exQuotation, "pricerule");
        }
    }

    protected void checkRate(int focusRow, String botName, String topName, String focusCol) {
        BigDecimal ratebottom = (BigDecimal)this.getModel().getValue(botName, focusRow);
        BigDecimal ratetop = (BigDecimal)this.getModel().getValue(topName, focusRow);
        if (EmptyUtil.isEmpty((BigDecimal)ratebottom) || EmptyUtil.isEmpty((BigDecimal)ratetop)) {
            return;
        }
        if (ratetop.compareTo(ratebottom) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u9650\u5fc5\u987b\u5c0f\u4e8e\u4e0a\u9650\u3002", (String)"RequestNoteEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(focusCol, null, focusRow);
        }
    }

    protected void checkDelDate(int focusRow, String foBizdate, String foDeliverydate) {
        Date fobizdate = (Date)this.getModel().getValue(foBizdate, focusRow);
        Date fodeldate = (Date)this.getModel().getValue(foDeliverydate, focusRow);
        if (EmptyUtil.isEmpty((Object)fobizdate) || EmptyUtil.isEmpty((Object)fodeldate)) {
            return;
        }
        if (fobizdate.after(fodeldate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u4e0d\u5f97\u65e9\u4e8e\u4ea4\u6613\u65e5\u3002", (String)"RequestNoteEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            this.getModel().setValue(foDeliverydate, null, focusRow);
        }
    }

    protected void setDeftBizdate() {
        int i;
        Date appdate = (Date)this.getModel().getValue("applydate");
        DynamicObjectCollection cols = this.getModel().getEntryEntity("forwardinfo");
        for (i = 0; i < cols.size(); ++i) {
            this.getModel().setValue("fobizdate", (Object)appdate, i);
        }
        cols = this.getModel().getEntryEntity("spotinfo");
        for (i = 0; i < cols.size(); ++i) {
            this.getModel().setValue("spbizdate", (Object)appdate, i);
        }
        cols = this.getModel().getEntryEntity("swapsinfo");
        for (i = 0; i < cols.size(); ++i) {
            this.getModel().setValue("swbizdate", (Object)appdate, i);
        }
        cols = this.getModel().getEntryEntity("optionsinfo");
        for (i = 0; i < cols.size(); ++i) {
            this.getModel().setValue("opbizdate", (Object)appdate, i);
        }
    }

    protected void setListVisible() {
        if (Objects.isNull(this.getModel().getValue("producttype"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forwardinfolist", "spotinfolist", "swapsinfolist", "optionsinfolist"});
            return;
        }
        if (this.getModel().getValue("producttype") == null || !"tm_reqnote".equals(this.getModel().getDataEntity().getDataEntityType().getName())) {
            return;
        }
        DynamicObject producttype = (DynamicObject)this.getModel().getValue("producttype");
        String productno = (String)producttype.get("number");
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(productno)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"forwardinfolist"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"spotinfolist", "swapsinfolist", "optionsinfolist"});
        } else if (ProductTypeEnum.FOREXSPOT.getValue().equals(productno)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"spotinfolist"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"forwardinfolist", "swapsinfolist", "optionsinfolist"});
        } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(productno)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forwardinfolist", "spotinfolist", "optionsinfolist"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"swapsinfolist"});
        } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(productno)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"optionsinfolist"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"forwardinfolist", "spotinfolist", "swapsinfolist"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"forwardinfolist", "spotinfolist", "swapsinfolist", "optionsinfolist"});
        }
    }

    protected void clearAmount(int focusRow, String changeColumn, String clearColumn) {
        BigDecimal amount = (BigDecimal)this.getModel().getValue(changeColumn, focusRow);
        if (EmptyUtil.isNoEmpty((BigDecimal)amount) && amount.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue(clearColumn, null, focusRow);
        }
    }

    protected void setDateStart() {
        Date applydate = (Date)this.getModel().getValue("applydate");
        DateEdit dateforward = (DateEdit)this.getView().getControl("deliverydate");
        dateforward.setMinDate(applydate);
        DateEdit fobizdate = (DateEdit)this.getView().getControl("fobizdate");
        fobizdate.setMinDate(applydate);
        DateEdit spbizdate = (DateEdit)this.getView().getControl("spbizdate");
        spbizdate.setMinDate(applydate);
        DateEdit swbizdate = (DateEdit)this.getView().getControl("swbizdate");
        swbizdate.setMinDate(applydate);
        DateEdit opbizdate = (DateEdit)this.getView().getControl("opbizdate");
        opbizdate.setMinDate(applydate);
    }

    protected void initDealInfoPane() {
        String currEntity = this.getcurrEntity();
        List<String> targetEntities = this.getTargetEntities();
        for (String targetEntity : targetEntities) {
            Object[] targetBills = TmcBotpHelper.getTargetBills((String)currEntity, (Object)this.getModel().getValue("id"), (String)targetEntity, null);
            if (EmptyUtil.isEmpty((Object[])targetBills)) continue;
            block1: for (Object bill : targetBills) {
                String bizbill = bill.getDataEntityType().getName();
                String entryName = ReqNoteEnum.getEntryByBizBill((String)bizbill);
                String entity = ReqNoteEnum.getEntityByBizBill((String)bizbill);
                String billno = bill.getString("billno");
                String billstatus = bill.getString("billstatus");
                Date bizdate = bill.getDate("bizdate");
                BigDecimal spotrate = bill.getBigDecimal("spotrate");
                Long counptyId = bill.getLong(StringUtils.join((Object[])new String[]{"counterparty", ".", "id"}));
                Long sourcebillid = bill.getLong("sourcebillid");
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entryName);
                String pair = bill.getString("pair");
                String[] pairs = pair.split("/");
                for (DynamicObject row : entryEntity) {
                    long id = row.getLong("id");
                    if ("tm_reqnote_forward".equals(entity)) {
                        if (sourcebillid != id) continue;
                        this.setExtraEntryProperty(targetEntity, (DynamicObject)bill, row.getInt("seq") - 1);
                        this.initFoInfo((DynamicObject)bill, billno, billstatus, bizdate, spotrate, counptyId, pairs[0], row);
                        continue block1;
                    }
                    if ("tm_reqnote_spot".equals(entity)) {
                        if (sourcebillid != id) continue;
                        this.setExtraEntryProperty(targetEntity, (DynamicObject)bill, row.getInt("seq") - 1);
                        this.initSpInfo((DynamicObject)bill, billno, billstatus, bizdate, spotrate, counptyId, pairs[0], row);
                        continue block1;
                    }
                    if ("tm_reqnote_swaps".equals(entity)) {
                        if (sourcebillid != id) continue;
                        this.setExtraEntryProperty(targetEntity, (DynamicObject)bill, row.getInt("seq") - 1);
                        this.initSwInfo((DynamicObject)bill, billno, billstatus, bizdate, spotrate, counptyId, entryEntity, pairs, row);
                        continue block1;
                    }
                    if (!"tm_reqnote_options".equals(entity) || sourcebillid != id) continue;
                    this.setExtraEntryProperty(targetEntity, (DynamicObject)bill, row.getInt("seq") - 1);
                    this.initOpInfo((DynamicObject)bill, billno, billstatus, bizdate, spotrate, counptyId, pairs[0], row);
                    continue block1;
                }
            }
        }
    }

    protected void setExtraEntryProperty(String entry, DynamicObject bill, int rowIndex) {
    }

    protected List<String> getTargetEntities() {
        if (this.getModel().getValue("producttype") == null || !"tm_reqnote".equals(this.getModel().getDataEntity().getDataEntityType().getName())) {
            return Collections.emptyList();
        }
        DynamicObject productType = (DynamicObject)this.getModel().getValue("producttype");
        ArrayList<String> products = new ArrayList<String>(1);
        products.add(ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity());
        return products;
    }

    protected String getcurrEntity() {
        return "tm_reqnote";
    }

    private void initSwInfo(DynamicObject bill, String billno, String billstatus, Date bizdate, BigDecimal spotrate, Long counptyId, DynamicObjectCollection entry, String[] split, DynamicObject row) {
        Date adjustsettledate = bill.getDate("settledate");
        Date addatefar = bill.getDate("adjustsettledate_far");
        BigDecimal forrate = bill.getBigDecimal("forwrate");
        IDataModel model = this.getModel();
        int rowno = row.getInt("seq") - 1;
        model.setValue("bizbillno", (Object)billno, rowno);
        model.setValue("swapsbill", (Object)bill.getString("id"), rowno);
        model.setValue("bizdate", (Object)bizdate, rowno);
        model.setValue("swstatus", (Object)billstatus, rowno);
        model.setValue("swrate", (Object)spotrate, rowno);
        model.setValue("swcounpty", (Object)counptyId, rowno);
        model.setValue("swdelidate", (Object)adjustsettledate, rowno);
        model.setValue("swamtin", (Object)bill.getBigDecimal("buy_amount"), rowno);
        model.setValue("swfincurrin", (Object)bill.getDynamicObject("buy_currency"), rowno);
        model.setValue("swamtout", (Object)bill.getBigDecimal("sell_amount"), rowno);
        model.setValue("swfincurrout", (Object)bill.getDynamicObject("sell_currency"), rowno);
        this.setfarRow(bill, forrate, addatefar, split, entry, row);
    }

    private void setfarRow(DynamicObject entity, BigDecimal forrate, Date addatefar, String[] split, DynamicObjectCollection entry, DynamicObject row) {
        long seq = row.getLong("seq");
        IDataModel model = this.getModel();
        for (DynamicObject farrow : entry) {
            int farseq = farrow.getInt("seq");
            int farrowno = farseq - 1;
            if ((long)farseq != seq + 1L) continue;
            model.setValue("swdelidate", (Object)addatefar, farrowno);
            model.setValue("swrate", (Object)forrate, farrowno);
            model.setValue("swapsbill", (Object)entity.getString("id"), farrowno);
            model.setValue("bizbillno", (Object)entity.getString("billno"), farrowno);
            model.setValue("bizdate", (Object)entity.getDate("bizdate"), farrowno);
            model.setValue("swstatus", (Object)entity.getString("billstatus"), farrowno);
            model.setValue("swcounpty", (Object)entity.getLong("counterparty.id"), farrowno);
            model.setValue("swamtin", (Object)entity.getBigDecimal("far_buy_amount"), farrowno);
            model.setValue("swfincurrin", (Object)entity.getDynamicObject("far_buy_currency"), farrowno);
            model.setValue("swamtout", (Object)entity.getBigDecimal("far_sell_amount"), farrowno);
            model.setValue("swfincurrout", (Object)entity.getDynamicObject("far_sell_currency"), farrowno);
        }
    }

    private void initSpInfo(DynamicObject bill, String billno, String billstatus, Date bizdate, BigDecimal spotrate, Long counptyId, String s, DynamicObject row) {
        Date adjustsettledate = bill.getDate("settledate");
        IDataModel model = this.getModel();
        int rowno = row.getInt("seq") - 1;
        model.setValue("spottransactionno", (Object)billno, rowno);
        model.setValue("spotbill", (Object)bill.getLong("id"), rowno);
        model.setValue("spfinalbizdate", (Object)bizdate, rowno);
        model.setValue("spotstatus", (Object)billstatus, rowno);
        model.setValue("spotexchangerate", (Object)spotrate, rowno);
        model.setValue("spfinalcounpty", (Object)counptyId, rowno);
        model.setValue("spotdeliverydate", (Object)adjustsettledate, rowno);
        model.setValue("spotamtin", (Object)bill.getBigDecimal("buy_amount"), rowno);
        model.setValue("spfincurrin", (Object)bill.getDynamicObject("buy_currency"), rowno);
        model.setValue("spotamtout", (Object)bill.getBigDecimal("sell_amount"), rowno);
        model.setValue("spfincurrout", (Object)bill.getDynamicObject("sell_currency"), rowno);
    }

    private void initFoInfo(DynamicObject bill, String billno, String billstatus, Date bizdate, BigDecimal spotrate, Long counptyId, String pl, DynamicObject row) {
        Date adjustsettledate = bill.getDate("adjustsettledate");
        Date stdateStart = bill.getDate("adjsettledate_start");
        Date stdateEnd = bill.getDate("adjsettledate_end");
        IDataModel model = this.getModel();
        int rowno = row.getInt("seq") - 1;
        model.setValue("transactionno", (Object)billno, rowno);
        model.setValue("fwdbill", (Object)bill.getLong("id"), rowno);
        model.setValue("fofinalbizdate", (Object)bizdate, rowno);
        model.setValue("forwardstatus", (Object)billstatus, rowno);
        model.setValue("forwardexchangerate", (Object)spotrate, rowno);
        model.setValue("focounptyid", (Object)counptyId, rowno);
        if (bill.getBoolean("isdaterange")) {
            model.setValue("adstartdate", (Object)stdateStart, rowno);
            model.setValue("adenddate", (Object)stdateEnd, rowno);
        } else {
            model.setValue("adjustdeliverydate", (Object)adjustsettledate, rowno);
        }
        model.setValue("fofinalamtin", (Object)bill.getBigDecimal("buy_amount"), rowno);
        model.setValue("fofincurrin", (Object)bill.getDynamicObject("buy_currency"), rowno);
        model.setValue("fofinalamtout", (Object)bill.getBigDecimal("sell_amount"), rowno);
        model.setValue("fofincurrout", (Object)bill.getDynamicObject("sell_currency"), rowno);
    }

    private void initOpInfo(DynamicObject bill, String billno, String billstatus, Date bizdate, BigDecimal spotrate, Long counptyId, String s, DynamicObject row) {
        Date settledate = bill.getDate("adjexpiredate");
        BigDecimal exrate = bill.getBigDecimal("exchangerate");
        Date adjsetdate = bill.getDate("adjustsettledate");
        DynamicObject opcurr = bill.getDynamicObject("premiumcurrency");
        BigDecimal opfee = bill.getBigDecimal("premium");
        IDataModel model = this.getModel();
        int rowno = row.getInt("seq") - 1;
        model.setValue("opbizbillno", (Object)billno, rowno);
        model.setValue("optionsbill", (Object)bill.getLong("id"), rowno);
        model.setValue("opfinbizdate", (Object)bizdate, rowno);
        model.setValue("opstatus", (Object)billstatus, rowno);
        model.setValue("exefinrate", (Object)spotrate, rowno);
        model.setValue("opfincounpty", (Object)counptyId, rowno);
        model.setValue("opfinsettledate", (Object)settledate, rowno);
        model.setValue("exefinrate", (Object)exrate, rowno);
        model.setValue("adjdelidate", (Object)adjsetdate, rowno);
        model.setValue("opfincurrency", (Object)opcurr, rowno);
        model.setValue("finoptionfee", (Object)opfee, rowno);
        model.setValue("opfinamtin", (Object)bill.getBigDecimal("buy_amount"), rowno);
        model.setValue("opfincurrin", (Object)bill.getDynamicObject("buy_currency"), rowno);
        model.setValue("opfinamtout", (Object)bill.getBigDecimal("sell_amount"), rowno);
        model.setValue("opfincurrout", (Object)bill.getDynamicObject("sell_currency"), rowno);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject defaultPriceRule;
        this.setProductType();
        this.setDeftBizdate();
        if (this.getModel().getEntryRowCount("swapsinfo") >= 2) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"end", (Object)"nearend", (int)0);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"end", (Object)"farend", (int)1);
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(defaultPriceRule = TmcDataServiceHelper.loadSingle((String)"md_pricerule", (String)"id,defaultrule", (QFilter[])new QFilter[]{new QFilter("defaultrule", "=", (Object)true)})))) {
            this.getModel().setValue("pricerule", defaultPriceRule.getPkValue());
        }
    }

    private void setProductType() {
        String formId;
        switch (formId = this.getView().getFormShowParameter().getFormId()) {
            case "tm_reqnote_spot": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"producttype", (Object)ProductTypeEnum.FOREXSPOT.getId());
                break;
            }
            case "tm_reqnote_forward": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"producttype", (Object)ProductTypeEnum.FOREXFORWARD.getId());
                break;
            }
            case "tm_reqnote_swaps": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"producttype", (Object)ProductTypeEnum.FOREXSWAPS.getId());
                break;
            }
            case "tm_reqnote_options": {
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"producttype", (Object)ProductTypeEnum.FOREXOPTION.getId());
            }
        }
    }

    protected void setDeftCurrency(String entity, ChangeData changeData) {
        int focusRow = changeData.getRowIndex();
        DynamicObject org = this.getOrg(focusRow, changeData.getDataEntity().getDataEntityType().getExtendName());
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ea4\u6613\u4e3b\u4f53\u3002", (String)"RequestNoteEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("org", "=", (Object)org.getLong("id"));
        DynamicObject currencytbd = BusinessDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency,org,defcurrency", (QFilter[])filter.toArray());
        Long defcurrency = null;
        if (!Objects.isNull(currencytbd)) {
            DynamicObject obj = (DynamicObject)currencytbd.get("defcurrency");
            defcurrency = obj.getLong("id");
        }
        if ("forwardinfo".equals(entity)) {
            this.setDeftCurrByBizType(focusRow, defcurrency, "businesstype", "currencytypein", "currencytypeout");
        } else if ("spotinfo".equals(entity)) {
            this.setDeftCurrByBizType(focusRow, defcurrency, "spotbusinesstype", "spotcurrencytypein", "spotcurrencytypeout");
        } else if ("optionsinfo".equals(entity)) {
            this.setDeftCurrByBizType(focusRow, defcurrency, "opbustype", "opcurrin", "opcurrout");
        }
    }

    protected DynamicObject getOrg(int rowIndex, String entryName) {
        return (DynamicObject)this.getModel().getValue("org");
    }

    private void setDeftCurrByBizType(int focusRow, Long defcurrency, String busTypeName, String currinName, String curroutName) {
        String businesstype = (String)this.getModel().getValue(busTypeName, focusRow);
        if (businesstype == null) {
            return;
        }
        switch (businesstype) {
            case "buy": {
                this.getModel().setValue(currinName, null, focusRow);
                this.getModel().setValue(curroutName, (Object)defcurrency, focusRow);
                break;
            }
            case "sell": {
                this.getModel().setValue(currinName, (Object)defcurrency, focusRow);
                this.getModel().setValue(curroutName, null, focusRow);
                break;
            }
            case "diff": {
                this.getModel().setValue(currinName, null, focusRow);
                this.getModel().setValue(curroutName, null, focusRow);
            }
        }
    }

    protected void getCurrType(BeforeF7SelectEvent evt, String qcp) {
        IDataEntityProperty property = evt.getProperty();
        DynamicObject org = this.getOrg(evt.getRow(), property.getParent().getExtendName());
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u4ea4\u6613\u4e3b\u4f53\u3002", (String)"RequestNoteEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(16);
        DynamicObject currencytbd = BusinessDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)StringUtils.join((Object[])propArr, (String)","), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong("id")), new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (Objects.isNull(currencytbd)) {
            return;
        }
        DynamicObjectCollection rows = (DynamicObjectCollection)currencytbd.get("excurrency");
        for (DynamicObject row : rows) {
            DynamicObject basedataObj = row.getDynamicObject("fbasedataid");
            Long basedataid = (Long)basedataObj.getPkValue();
            idSet.add(basedataid);
        }
        QFilter currfilter = new QFilter("id", qcp, idSet);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        qFilters.add(currfilter);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "spotapplydeliverydate": {
                this.checkDeliveryDate(value, e);
                break;
            }
            case "swsettledate": {
                this.checkSwSettleDate(e, value);
                break;
            }
        }
    }

    private void checkSwSettleDate(BeforeFieldPostBackEvent e, Object value) {
        int focusRow = e.getRowIndex();
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        String end = (String)this.getModel().getValue("end", focusRow);
        if ("farend".equalsIgnoreCase(end)) {
            Date fardate = TcDateUtils.stringToDate((String)String.valueOf(value), (String)"yyyy-MM-dd");
            Date neardate = (Date)this.getModel().getValue("swsettledate", focusRow - 1);
            if (EmptyUtil.isNoEmpty((Object)neardate) && !fardate.after(neardate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fdc\u7aef\u4ea4\u5272\u65e5\u53ea\u80fd\u9009\u62e9\u8fd1\u7aef\u4ea4\u5272\u65e5\u540e\u7684\u65e5\u671f\u3002", (String)"RequestNoteEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
            this.getView().updateView("swsettledate", focusRow);
        }
    }

    private void checkDeliveryDate(Object value, BeforeFieldPostBackEvent e) {
        int index = e.getRowIndex();
        if (value != null) {
            Date bizDate = (Date)this.getModel().getValue("spbizdate", index);
            if (bizDate == null) {
                TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"spbizdate");
                e.setCancel(true);
            }
            this.getView().updateView("spotapplydeliverydate", index);
        }
    }
}

