/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.requestnote;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class RequestNoteList
extends AbstractTmcListPlugin {
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String type = formOperate.getType();
        if (StringUtils.equals((CharSequence)"pushandsave", (CharSequence)type) || StringUtils.equals((CharSequence)"push", (CharSequence)type)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                args.setCancel(true);
            } else {
                Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
                if (primaryKeyValues.length != 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"RequestNoteList_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getBillFormId();
        String producttype = "";
        switch (entityName) {
            case "tm_reqnote_spot": {
                producttype = ProductTypeEnum.FOREXSPOT.getId();
                break;
            }
            case "tm_reqnote_forward": {
                producttype = ProductTypeEnum.FOREXFORWARD.getId();
                break;
            }
            case "tm_reqnote_swaps": {
                producttype = ProductTypeEnum.FOREXSWAPS.getId();
                break;
            }
            case "tm_reqnote_options": {
                producttype = ProductTypeEnum.FOREXOPTION.getId();
                break;
            }
        }
        if (EmptyUtil.isNoEmpty((String)producttype)) {
            filters.add(new QFilter("producttype", "=", (Object)Long.parseLong(producttype)));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        String entityName = billList.getBillFormId();
        e.getParameter().setFormId(entityName);
        e.getParameter().setCaption(MetadataServiceHelper.getDataEntityType((String)"tm_reqnote").getDisplayName().getLocaleValue());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            List billNos = data.stream().map(o -> o.getString("billno")).distinct().collect(Collectors.toList());
            HashMap<String, Integer> orderMap = new HashMap<String, Integer>(8);
            int seq = 0;
            for (String billNo : billNos) {
                orderMap.put(billNo, seq++);
            }
            data.sort((o1, o2) -> {
                String billNo2;
                String billNo1 = o1.getString("billno");
                if (billNo1.equals(billNo2 = o2.getString("billno"))) {
                    return 0;
                }
                return ((Integer)orderMap.get(billNo1)).compareTo((Integer)orderMap.get(billNo2));
            });
            return data;
        }
    }
}

