/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.setting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.SettleSettingEnum;
import kd.tmc.tm.common.enums.SettleSettingModuleEnum;
import kd.tmc.tm.common.enums.SettleSettingOpEnum;

public class SettlementSettingEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public static final String IS_USER_DELETING_ENTRY = "is_user_deleting_entry";
    public static final String YES = "1";
    public static final String COLOR_GRAY = "#999999";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit scenarioSimulation = (MulBasedataEdit)this.getControl("orgcol");
        scenarioSimulation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setCellStyle();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnable();
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String property = event.getProperty().getName();
        if ("orgcol".equals(property)) {
            Set<Long> orgIdSet = this.queryExistOrgIds();
            ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "not in", orgIdSet));
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac");
            if (!result.hasAllOrgPerm()) {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)result.getHasPermOrgs()));
            }
        }
    }

    private Set<Long> queryExistOrgIds() {
        DynamicObject[] existSettings = BusinessDataServiceHelper.load((String)"tm_settlement_setting", (String)"orgcol", (QFilter[])new QFilter("id", "!=", this.getModel().getValue("id")).toArray());
        HashSet<Long> orgIdSet = new HashSet<Long>();
        for (DynamicObject bill : existSettings) {
            Set orgIds = bill.getDynamicObjectCollection("orgcol").stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            orgIdSet.addAll(orgIds);
        }
        return orgIdSet;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initData();
    }

    private void setEnable() {
        int i;
        for (i = 0; i < this.getModel().getEntryRowCount("forexsetting"); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"forex_module", "forex_op"});
        }
        for (i = 0; i < this.getModel().getEntryRowCount("ratesetting"); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"rate_module", "rate_op"});
        }
        for (i = 0; i < this.getModel().getEntryRowCount("structsetting"); ++i) {
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"struct_module", "struct_op", "struct_setting"});
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        super.beforeDeleteRow(e);
        if (!YES.equals(this.getView().getPageCache().get(IS_USER_DELETING_ENTRY))) {
            e.setCancel(true);
            return;
        }
        this.getView().getPageCache().remove(IS_USER_DELETING_ENTRY);
    }

    private void initData() {
        this.getModel().batchCreateNewEntryRow("forexsetting", 5);
        this.getModel().setValue("forex_module", (Object)SettleSettingModuleEnum.OPTIONS.getValue(), 0);
        this.getModel().setValue("forex_op", (Object)SettleSettingOpEnum.OPTION_FEE_SETTLE.getValue(), 0);
        this.getModel().setValue("forex_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 0);
        this.getModel().setValue("forex_module", (Object)SettleSettingModuleEnum.BIZBILL.getValue(), 1);
        this.getModel().setValue("forex_op", (Object)SettleSettingOpEnum.EXPIRE_DEY.getValue(), 1);
        this.getModel().setValue("forex_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 1);
        this.getModel().setValue("forex_module", (Object)SettleSettingModuleEnum.BIZBILL.getValue(), 2);
        this.getModel().setValue("forex_op", (Object)SettleSettingOpEnum.BE_DEY.getValue(), 2);
        this.getModel().setValue("forex_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 2);
        this.getModel().setValue("forex_module", (Object)SettleSettingModuleEnum.BIZBILL.getValue(), 3);
        this.getModel().setValue("forex_op", (Object)SettleSettingOpEnum.EXERCISE.getValue(), 3);
        this.getModel().setValue("forex_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 3);
        this.getModel().setValue("forex_module", (Object)SettleSettingModuleEnum.BIZBILL.getValue(), 4);
        this.getModel().setValue("forex_op", (Object)SettleSettingOpEnum.PL.getValue(), 4);
        this.getModel().setValue("forex_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 4);
        this.getModel().batchCreateNewEntryRow("ratesetting", 5);
        this.getModel().setValue("rate_module", (Object)SettleSettingModuleEnum.SWAP_CURRENCY.getValue(), 0);
        this.getModel().setValue("rate_op", (Object)SettleSettingOpEnum.BUY_SETTLE.getValue(), 0);
        this.getModel().setValue("rate_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 0);
        this.getModel().setValue("rate_module", (Object)SettleSettingModuleEnum.BIZBILL_FORWRATEAGREE.getValue(), 1);
        this.getModel().setValue("rate_op", (Object)SettleSettingOpEnum.INTEREST_PAY.getValue(), 1);
        this.getModel().setValue("rate_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 1);
        this.getModel().setValue("rate_module", (Object)SettleSettingModuleEnum.BIZBILL_RATESWAP.getValue(), 2);
        this.getModel().setValue("rate_op", (Object)SettleSettingOpEnum.INTEREST_PAY.getValue(), 2);
        this.getModel().setValue("rate_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 2);
        this.getModel().setValue("rate_module", (Object)SettleSettingModuleEnum.BIZBILL_CURRENCYSWAP.getValue(), 3);
        this.getModel().setValue("rate_op", (Object)SettleSettingOpEnum.INTEREST_PAY.getValue(), 3);
        this.getModel().setValue("rate_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 3);
        this.getModel().setValue("rate_module", (Object)SettleSettingModuleEnum.BIZBILL_CURRENCYSWAP.getValue(), 4);
        this.getModel().setValue("rate_op", (Object)SettleSettingOpEnum.CAPITAL_PAY.getValue(), 4);
        this.getModel().setValue("rate_setting", (Object)SettleSettingEnum.REC_PAY_BILL.getValue(), 4);
        this.getModel().batchCreateNewEntryRow("structsetting", 2);
        this.getModel().setValue("struct_module", (Object)SettleSettingModuleEnum.STRUCTDEPOSIT.getValue(), 0);
        this.getModel().setValue("struct_op", (Object)SettleSettingOpEnum.BUY_SETTLE.getValue(), 0);
        this.getModel().setValue("struct_setting", (Object)SettleSettingEnum.PAY_BILL.getValue(), 0);
        this.getModel().setValue("struct_module", (Object)SettleSettingModuleEnum.BIZBILL.getValue(), 1);
        this.getModel().setValue("struct_op", (Object)SettleSettingOpEnum.INTEREST_CAPITAL_REC.getValue(), 1);
        this.getModel().setValue("struct_setting", (Object)SettleSettingEnum.REC_BILL.getValue(), 1);
    }

    private void setCellStyle() {
        EntryGrid forexGrid = (EntryGrid)this.getView().getControl("forexsetting");
        ArrayList<CellStyle> list1 = new ArrayList<CellStyle>();
        CellStyle cell1 = new CellStyle();
        cell1.setForeColor(COLOR_GRAY);
        cell1.setFieldKey("forex_setting");
        cell1.setRow(0);
        list1.add(cell1);
        CellStyle cell5 = new CellStyle();
        cell5.setForeColor(COLOR_GRAY);
        cell5.setFieldKey("forex_setting");
        cell5.setRow(4);
        list1.add(cell5);
        forexGrid.setCellStyle(list1);
        EntryGrid rateGrid = (EntryGrid)this.getView().getControl("ratesetting");
        ArrayList<CellStyle> list2 = new ArrayList<CellStyle>();
        CellStyle cell2 = new CellStyle();
        cell2.setForeColor(COLOR_GRAY);
        cell2.setFieldKey("rate_setting");
        cell2.setRow(1);
        list2.add(cell2);
        CellStyle cell3 = new CellStyle();
        cell3.setForeColor(COLOR_GRAY);
        cell3.setFieldKey("rate_setting");
        cell3.setRow(2);
        list2.add(cell3);
        rateGrid.setCellStyle(list2);
    }
}

