/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.structdeposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.TimeZone;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.MarkPriceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.HookTypeEnum;
import kd.tmc.tm.common.enums.ObsFrequeEnum;
import kd.tmc.tm.common.helper.StructDepositHelper;
import kd.tmc.tm.common.resource.TeBizResource;

public class StructDepositDefineEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit edit = (TextEdit)this.getView().getControl("hookmark");
        edit.addButtonClickListener((ClickListener)this);
        BasedataEdit bwsymbol = (BasedataEdit)this.getView().getControl("bwsymbol");
        bwsymbol.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        boolean isDataChange = this.getModel().getDataChanged();
        super.afterBindData(e);
        StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)false);
        this.isShowLabel();
        this.initLastObsDate();
        this.initZoomFieldTitle();
        this.initDataStatus();
        this.initMarkPrice(true);
        this.effectObsFreq();
        this.markPriceChgEvt(true);
        this.initObsFreq(true);
        this.setMarkPriceItems();
        this.getModel().setDataChanged(isDataChange);
    }

    protected void initDataStatus() {
        boolean isEnable = !"total".equals(this.getModel().getValue("structtype"));
        this.getView().setEnable(Boolean.valueOf(isEnable), 0, new String[]{"pricex"});
        this.getView().setEnable(Boolean.valueOf(isEnable), 2, new String[]{"pricey"});
        this.getView().setEnable(Boolean.valueOf(isEnable), 2, new String[]{"rate"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"obstacle"});
        this.getView().setVisible(Boolean.valueOf(isEnable), new String[]{"btn_add", "btn_delete"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "hooktype": {
                this.initMarkPrice(false);
                this.initObsFreq(false);
                this.setMarkPriceItems();
                break;
            }
            case "pricemethod": {
                this.initZoomFieldTitle();
                break;
            }
            case "pricey": {
                this.priceYChgEvt(args);
                break;
            }
            case "structtype": {
                this.setMarkPriceItems();
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                this.initMarkPrice(false);
                this.structTypeChgEvt(args);
                this.initObsFreq(false);
                break;
            }
            case "rate": {
                this.rateChgEvt(args);
                break;
            }
            case "markprice": {
                this.effectObsFreq();
                this.markPriceChgEvt(false);
                this.initEntrysObsDate();
                this.initObsFreq(false);
                break;
            }
            case "settledate": {
                this.initAndDefaultLastObsDateVal();
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                this.initEntrysObsDate();
                break;
            }
            case "obsfreq": {
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                this.initEntrysObsDate();
                this.initLastObsDate();
                break;
            }
            case "obstacle": {
                this.initObsFreq(false);
                break;
            }
            case "firstobsdate": {
                Date firstObsDate = (Date)this.getModel().getValue("firstobsdate");
                Date lastObsDate = (Date)this.getModel().getValue("lastobsdate");
                if (EmptyUtil.isNoEmpty((Object)firstObsDate) && EmptyUtil.isNoEmpty((Object)lastObsDate) && firstObsDate.compareTo(lastObsDate) > 0) {
                    this.getModel().setValue("lastobsdate", null);
                }
                this.initAndDefaultLastObsDateVal();
                this.initEntrysObsDate();
                break;
            }
            case "lastobsdate": {
                Date firstObs = (Date)this.getModel().getValue("firstobsdate");
                Date lastObs = (Date)this.getModel().getValue("lastobsdate");
                if (EmptyUtil.isNoEmpty((Object)firstObs) && EmptyUtil.isNoEmpty((Object)lastObs) && firstObs.compareTo(lastObs) > 0) {
                    this.getModel().setValue("firstobsdate", null);
                }
            }
            case "dateadjustmethod2": {
                this.initEntrysObsDate();
                break;
            }
            case "markzone": 
            case "marktime": {
                this.callObserveSysTime();
                break;
            }
            case "obsdate": {
                int index = args.getChangeSet()[0].getRowIndex();
                Date obsSysDate = this.callObserveSysTime((Date)args.getChangeSet()[0].getNewValue(), index);
                this.getModel().setValue("obssystime", (Object)obsSysDate, index);
                this.checkObsDate(index);
                List items = StructDepositHelper.initRedeemDateBox((IDataModel)this.getModel(), (IFormView)this.getView());
                if (items.size() <= 0) break;
                this.getModel().setValue("redeemdate2", (Object)((ComboItem)items.get(0)).getValue());
                break;
            }
            case "settledelay": 
            case "markcalender": {
                StructDepositHelper.initFirstObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
                StructDepositHelper.initLastObsDate((IDataModel)this.getModel(), (IFormView)this.getView(), (boolean)true);
            }
        }
    }

    private void effectObsFreq() {
        String markPrice = (String)this.getModel().getValue("markprice");
        ComboEdit obsFreq = (ComboEdit)this.getView().getControl("obsfreq");
        ArrayList<ObsFrequeEnum> list = new ArrayList<ObsFrequeEnum>();
        Collections.addAll(list, ObsFrequeEnum.values());
        if (!MarkPriceEnum.ctu_price.getValue().equals(markPrice)) {
            for (int index = list.size() - 1; index >= 0; --index) {
                if (ObsFrequeEnum.continuous == list.get(index)) {
                    list.remove(index);
                }
                if (!ObsFrequeEnum.continuous.getValue().equals(this.getModel().getValue("obsfreq"))) continue;
                this.getModel().setValue("obsfreq", null);
            }
        }
        List<ComboItem> items = this.initObsFrequeComboItem(list);
        obsFreq.setComboItems(items);
    }

    private void initObsFreq(boolean isInitForm) {
        String structType = (String)this.getModel().getValue("structtype");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"obsfreq"});
        if ("break".equals(structType)) {
            String markprice = (String)this.getModel().getValue("markprice");
            if (MarkPriceEnum.ctu_price.getValue().equals(markprice)) {
                this.setValue(isInitForm, "obsfreq", ObsFrequeEnum.continuous);
            } else {
                DynamicObjectCollection zones = this.getModel().getEntryEntity("zone");
                for (DynamicObject zone : zones) {
                    if (!Boolean.TRUE.equals(zone.getBoolean("obstacle"))) continue;
                    return;
                }
                this.setValue(isInitForm, "obsfreq", ObsFrequeEnum.one);
            }
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"obsfreq"});
        } else {
            this.setValue(isInitForm, "obsfreq", ObsFrequeEnum.day);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"obsfreq"});
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if ("zone".equals(e.getEntryProp().getName())) {
            for (RowDataEntity row : e.getRowDataEntities()) {
                int index = row.getRowIndex();
                if (index <= 0) continue;
                BigDecimal pricey = (BigDecimal)this.getModel().getValue("pricey", index - 1);
                this.getModel().setValue("pricex", (Object)pricey, index);
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"pricex"});
            }
        } else if ("observe".equals(e.getEntryProp().getName())) {
            int insertRow = e.getInsertRow();
            if (0 == insertRow) {
                this.getView().getPageCache().put("obsdelete", "false");
                this.getModel().deleteEntryRow("observe", insertRow);
            } else {
                List items = StructDepositHelper.initRedeemDateBox((IDataModel)this.getModel(), (IFormView)this.getView());
                if (items.size() > 0) {
                    this.getModel().setValue("redeemdate2", (Object)((ComboItem)items.get(0)).getValue());
                }
            }
        }
    }

    public void addClickListeners(String ... keys) {
        super.addClickListeners(keys);
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        boolean obsdelete;
        if (this.getModel().getEntryRowCount("zone") == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4fdd\u7559\u4e00\u884c\u3002", (String)"StructDepositDefineEdit_21", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
        int[] index = e.getRowIndexs();
        boolean bl = obsdelete = EmptyUtil.isEmpty((String)this.getView().getPageCache().get("obsdelete")) || Boolean.parseBoolean(this.getView().getPageCache().get("obsdelete"));
        if ("zone".equals(e.getEntryProp().getName())) {
            int size = this.getModel().getEntryEntity("zone").size();
            BigDecimal x = (BigDecimal)this.getModel().getValue("pricex", index[0]);
            BigDecimal y = (BigDecimal)this.getModel().getValue("pricey", index[0]);
            if (EmptyUtil.isEmpty((BigDecimal)x) && EmptyUtil.isNoEmpty((BigDecimal)y) && size > index[0] + 1) {
                this.getModel().setValue("pricex", null, index[0] + 1);
            } else if (EmptyUtil.isEmpty((BigDecimal)y) && EmptyUtil.isNoEmpty((BigDecimal)x) && index[0] > 1) {
                this.getModel().setValue("pricey", null, index[0] - 1);
            } else if (EmptyUtil.isNoEmpty((BigDecimal)x) && EmptyUtil.isNoEmpty((BigDecimal)y) && index[0] > 0 && index[0] < size - 1) {
                this.getModel().setValue("pricex", (Object)x, index[0] + 1);
            }
        } else if ("observe".equals(e.getEntryProp().getName())) {
            DynamicObjectCollection entitys = this.getModel().getEntryEntity("observe");
            if (obsdelete && (0 == index[0] || entitys.size() - 1 == index[0])) {
                e.setCancel(true);
            }
            this.getView().getPageCache().put("obsdelete", "true");
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        List items;
        if ("observe".equals(e.getEntryProp().getName()) && (items = StructDepositHelper.initRedeemDateBox((IDataModel)this.getModel(), (IFormView)this.getView())).size() > 0) {
            this.getModel().setValue("redeemdate2", (Object)((ComboItem)items.get(0)).getValue());
        }
    }

    public void click(EventObject e) {
        if (e.getSource() instanceof TextEdit && "hookmark".equals(((TextEdit)e.getSource()).getKey())) {
            String hookType = (String)this.getModel().getValue("hooktype");
            if (EmptyUtil.isEmpty((String)hookType)) {
                TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)true, (String)"hooktype");
                return;
            }
            ListShowParameter showParameter = null;
            QFilter qFilter = new QFilter("enable", "=", (Object)true);
            String formId = this.getFormIdByHookType();
            boolean isMultiSelect = false;
            if (hookType.equals(HookTypeEnum.exrate.getValue())) {
                isMultiSelect = true;
            }
            showParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
            showParameter.getListFilterParameter().setFilter(qFilter);
            if (EmptyUtil.isNoEmpty((String)formId) && showParameter != null) {
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "close_hookmark"));
                this.getView().showForm((FormShowParameter)showParameter);
            }
        }
    }

    private String getFormIdByHookType() {
        String hookType = (String)this.getModel().getValue("hooktype");
        if (hookType.equals(HookTypeEnum.exrate.getValue())) {
            return "bd_currency_tc";
        }
        if (hookType.equals(HookTypeEnum.referindex.getValue())) {
            return "tbd_referindex";
        }
        if (hookType.equals(HookTypeEnum.referrate.getValue())) {
            return "tbd_referrate";
        }
        if (hookType.equals(HookTypeEnum.goods.getValue())) {
            return "tbd_goodsdefined";
        }
        return null;
    }

    private void setMarkPriceItems() {
        ComboEdit markPriceItems = (ComboEdit)this.getControl("markprice");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5f00\u76d8\u4ef7", (String)"StructDepositDefineEdit_11", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "begin_price"));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6536\u76d8\u4ef7", (String)"StructDepositDefineEdit_12", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "end_price"));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u9ad8\u4ef7", (String)"StructDepositDefineEdit_13", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "max_price"));
        data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6700\u4f4e\u4ef7", (String)"StructDepositDefineEdit_14", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "min_price"));
        if (HookTypeEnum.goods.getValue().equals(this.getModel().getValue("hooktype"))) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7ed3\u7b97\u4ef7", (String)"StructDepositDefineEdit_15", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "settle_price"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u65e9\u76d8\u4ef7", (String)"StructDepositDefineEdit_16", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "morning_price"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5348\u76d8\u4ef7", (String)"StructDepositDefineEdit_17", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "afternoon_price"));
        } else {
            if ("break".equals(this.getModel().getValue("structtype"))) {
                data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8fde\u7eed\u4ef7", (String)"StructDepositDefineEdit_18", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "ctu_price"));
            }
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5747\u4ef7", (String)"StructDepositDefineEdit_19", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "avg_price"));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5177\u4f53\u65f6\u95f4\u70b9", (String)"StructDepositDefineEdit_20", (String)"tmc-tm-formplugin", (Object[])new Object[0])), "spec_point"));
        }
        markPriceItems.setComboItems(data);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection data;
        super.closedCallBack(event);
        if ("close_hookmark".equals(event.getActionId()) && EmptyUtil.isNoEmpty((Object)(data = (ListSelectedRowCollection)event.getReturnData()))) {
            String formId = this.getFormIdByHookType();
            if (data.size() == 2) {
                String basecurrency = data.get(0).getNumber();
                String termcurrency = data.get(1).getNumber();
                this.getModel().setValue("hookmark", (Object)(basecurrency + "/" + termcurrency));
            } else {
                this.getModel().setValue("hookmark", (Object)data.get(0).getNumber());
            }
            if ("tbd_goodsdefined".equals(formId)) {
                QFilter filter = new QFilter("id", "=", data.get(0).getPrimaryKeyValue());
                DynamicObject hookMark = TmcDataServiceHelper.loadSingle((String)formId, (String)"id,currency", (QFilter[])filter.toArray());
                this.getModel().setValue("initialpricecurrency", (Object)hookMark.getDynamicObject("currency"));
            } else {
                this.getModel().setValue("initialpricecurrency", null);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("newentry".equals(op.getOperateKey()) && this.getModel().getEntryEntity("zone").size() >= 10) {
            this.getView().showTipNotification(new TeBizResource().checkStructDepositZoneTotalSizeErr());
            args.setCancel(true);
        }
        if (("save".equals(op.getOperateKey()) || "submit".equals(op.getOperateKey())) && !this.verifyEntryInput()) {
            args.setCancel(true);
        }
    }

    protected boolean verifyEntryInput() {
        DynamicObjectCollection zones = this.getModel().getEntryEntity("zone");
        if (zones.size() < 2) {
            this.getView().showTipNotification(new TeBizResource().checkStructDepositZoneSizeErr());
            return false;
        }
        for (int index = 0; index < zones.size(); ++index) {
            DynamicObject zone = (DynamicObject)zones.get(index);
            if (zone.getInt("seq") == 1 && EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricey"))) {
                this.getView().showTipNotification(new TeBizResource().checkStructDepositZoneYErr());
                return false;
            }
            if (zone.getInt("seq") == zones.size() && zone.getInt("seq") != 1 && EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricex"))) {
                this.getView().showTipNotification(new TeBizResource().checkStructDepositZoneXErr());
                return false;
            }
            if (zone.getInt("seq") == 1 || zone.getInt("seq") == zones.size() || !EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricey")) && !EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricex"))) continue;
            this.getView().showTipNotification(new TeBizResource().checkStructDepositZoneXYErr());
            return false;
        }
        String markPrice = (String)this.getModel().getValue("markprice");
        if (MarkPriceEnum.ctu_price.getValue().equals(markPrice) && "break".equals(this.getModel().getValue("structtype"))) {
            boolean firstObs = ((DynamicObject)zones.get(0)).getBoolean("obstacle");
            boolean lastObs = ((DynamicObject)zones.get(zones.size() - 1)).getBoolean("obstacle");
            if (!firstObs && !lastObs) {
                this.getView().showTipNotification(new TeBizResource().checkStructDepositZoneObstacle());
                return false;
            }
        }
        DynamicObjectCollection observe = this.getModel().getEntryEntity("observe");
        for (DynamicObject obj : observe) {
            if (!EmptyUtil.isEmpty((Object)obj.getDate("obsdate"))) continue;
            this.getView().showTipNotification(new TeBizResource().checkNotNullObsDate());
            return false;
        }
        return true;
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        super.verifyInput(key, value, e);
        if (EmptyUtil.isEmpty((Object)value)) {
            return;
        }
        String x = this.getModel().getProperty("pricex").getDisplayName().getLocaleValue();
        String y = this.getModel().getProperty("pricey").getDisplayName().getLocaleValue();
        switch (key) {
            case "pricex": {
                BigDecimal pricey = (BigDecimal)this.getModel().getValue("pricey", e.getRowIndex());
                this.checkPriceValue(e, new BigDecimal(value.toString()), pricey, ResManager.loadKDString((String)"{0}\u5fc5\u987b\u5927\u4e8e{1}\u7684\u503c\u3002", (String)"StructDepositDefineEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{y, x}));
                this.getView().updateView("pricex", e.getRowIndex());
                break;
            }
            case "pricey": {
                int index = e.getRowIndex();
                BigDecimal pricex = (BigDecimal)this.getModel().getValue("pricex", index);
                this.checkPriceValue(e, pricex, new BigDecimal(value.toString()), ResManager.loadKDString((String)"{0}\u5fc5\u987b\u5927\u4e8e{1}\u7684\u503c\u3002", (String)"StructDepositDefineEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{y, x}));
                if (this.getModel().getEntryRowCount("zone") > index + 1) {
                    BigDecimal pricey = (BigDecimal)this.getModel().getValue("pricey", index + 1);
                    this.checkPriceValue(e, new BigDecimal(value.toString()), pricey, ResManager.loadKDString((String)"\u4e0d\u80fd\u5927\u4e8e\u7b49\u4e8e\u4e0b\u4e00\u884c\u7684y\u503c%s\u3002", (String)"StructDepositDefineEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[]{pricey}));
                }
                this.getView().updateView("pricey", e.getRowIndex());
                break;
            }
            case "hookmark": {
                String hookType = (String)this.getModel().getValue("hooktype");
                if (!hookType.equals(HookTypeEnum.exrate.getValue())) break;
                e.setCancel(true);
                this.getView().updateView("hookmark");
                break;
            }
            case "initialprice": {
                BigDecimal initialPrice = new BigDecimal(value.toString());
                String hooktype = (String)this.getModel().getValue("hooktype");
                this.validInitialPrice(initialPrice, hooktype, e);
                break;
            }
            case "hooktype": {
                BigDecimal initialPrice = (BigDecimal)this.getModel().getValue("initialprice");
                String hooktype = value.toString();
                this.validInitialPrice(initialPrice, hooktype, e);
            }
        }
    }

    protected void priceYChgEvt(PropertyChangedArgs args) {
        int index = args.getChangeSet()[0].getRowIndex();
        String structType = (String)this.getModel().getValue("structtype");
        if (this.getModel().getEntryRowCount("zone") == index + 1 && "break".equals(structType)) {
            this.getModel().createNewEntryRow("zone");
        } else if ("break".equals(structType) || "total".equals(structType) && (index == 0 || index == 1)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pricex", (Object)args.getChangeSet()[0].getNewValue(), (int)(index + 1));
        }
        if (EmptyUtil.isNoEmpty((Object)args.getChangeSet()[0].getNewValue())) {
            BigDecimal pricex = (BigDecimal)this.getModel().getValue("pricex", index);
            if (EmptyUtil.isNoEmpty((BigDecimal)pricex)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{"obstacle"});
                this.getModel().setValue("obstacle", (Object)false, index);
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(true), index, new String[]{"obstacle"});
        }
    }

    protected void structTypeChgEvt(PropertyChangedArgs args) {
        this.getModel().setValue("predictmark", null);
        this.getModel().setValue("predictrate", null);
        if ("total".equals(this.getModel().getValue("structtype"))) {
            this.getModel().deleteEntryData("zone");
            this.getModel().batchCreateNewEntryRow("zone", 3);
            this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"pricex"});
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{"pricey"});
            this.getView().setEnable(Boolean.valueOf(false), 2, new String[]{"rate"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"obstacle"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btn_add", "btn_delete"});
            this.getModel().setValue("redeemtype", null);
        } else {
            this.getView().setEnable(Boolean.valueOf(true), 0, new String[]{"pricex"});
            this.getView().setEnable(Boolean.valueOf(true), 2, new String[]{"pricey"});
            this.getView().setEnable(Boolean.valueOf(true), 2, new String[]{"rate"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"obstacle"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"btn_add", "btn_delete"});
            this.getModel().setValue("redeemtype", (Object)"auto_redeem");
        }
    }

    protected void rateChgEvt(PropertyChangedArgs args) {
        int index = args.getChangeSet()[0].getRowIndex();
        String structType = (String)this.getModel().getValue("structtype");
        if (index == 0 && "total".equals(structType)) {
            this.getModel().setValue("rate", args.getChangeSet()[0].getNewValue(), index + 2);
        }
    }

    private void checkPriceValue(BeforeFieldPostBackEvent e, BigDecimal pricex, BigDecimal pricey, String message) {
        if (EmptyUtil.isNoEmpty((BigDecimal)pricex) && EmptyUtil.isNoEmpty((BigDecimal)pricey) && pricex.compareTo(pricey) >= 0) {
            this.getView().showTipNotification(message);
            e.setCancel(true);
        }
    }

    protected void initMarkPrice(boolean isInitForm) {
        if ("total".equals(this.getModel().getValue("structtype"))) {
            this.setValue(isInitForm, "obsfreq", ObsFrequeEnum.day);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"obsfreq"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"daytype"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"obsfreq"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"daytype"});
        }
        this.setValue(isInitForm, "hookmark", null);
        this.setValue(isInitForm, "markprice", null);
        String hookType = (String)this.getModel().getValue("hooktype");
        if (EmptyUtil.isEmpty((String)hookType)) {
            return;
        }
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"markprice"});
        if (hookType.equals(HookTypeEnum.exrate.getValue())) {
            this.setValue(isInitForm, "markprice", MarkPriceEnum.spec_point);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"markprice"});
        } else if (hookType.equals(HookTypeEnum.referrate.getValue())) {
            this.setValue(isInitForm, "markprice", MarkPriceEnum.end_price);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"markprice"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"markprice"});
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"markprice"});
        }
        this.initZoomFieldTitle();
    }

    private List<ComboItem> initComboItem(List<MarkPriceEnum> markPrices) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(markPrices.size());
        for (MarkPriceEnum markPrice : markPrices) {
            items.add(new ComboItem(new LocaleString(markPrice.getName()), markPrice.getValue()));
        }
        return items;
    }

    private List<ComboItem> initObsFrequeComboItem(List<ObsFrequeEnum> obsFreque) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(obsFreque.size());
        for (ObsFrequeEnum obsFre : obsFreque) {
            items.add(new ComboItem(new LocaleString(obsFre.getName()), obsFre.getValue()));
        }
        return items;
    }

    protected void initZoomFieldTitle() {
        DecimalEdit pricex = (DecimalEdit)this.getView().getControl("pricex");
        DecimalEdit pricey = (DecimalEdit)this.getView().getControl("pricey");
        DecimalEdit initprice = (DecimalEdit)this.getView().getControl("initialprice");
        String priceMethod = (String)this.getModel().getValue("pricemethod");
        String hooktype = (String)this.getModel().getValue("hooktype");
        if (EmptyUtil.isEmpty((String)priceMethod)) {
            return;
        }
        switch (priceMethod) {
            case "precent": {
                pricex.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u671f\u521d\u4ef7\u683c\u767e\u5206\u6bd4x\uff08%\uff09", (String)"StructDepositDefineEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                pricey.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u671f\u521d\u4ef7\u683c\u767e\u5206\u6bd4y\uff08%\uff09", (String)"StructDepositDefineEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                initprice.setMustInput(true);
                if (hooktype != null && hooktype.equals(HookTypeEnum.referrate.getValue())) {
                    initprice.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u4ef7\u683c\uff08%\uff09", (String)"StructDepositDefineEdit_5", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                    break;
                }
                initprice.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u521d\u4ef7\u683c", (String)"StructDepositDefineEdit_6", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                break;
            }
            case "price": {
                initprice.setMustInput(false);
                if (hooktype != null && hooktype.equals(HookTypeEnum.referrate.getValue())) {
                    pricex.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683cx\uff08%\uff09", (String)"StructDepositDefineEdit_7", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                    pricey.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683cy\uff08%\uff09", (String)"StructDepositDefineEdit_8", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                } else {
                    pricex.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683cx", (String)"StructDepositDefineEdit_9", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                    pricey.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683cy", (String)"StructDepositDefineEdit_10", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
                }
                this.getModel().setValue("initialprice", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        if ("bwsymbol".equals(((BasedataEdit)evt.getSource()).getKey())) {
            DynamicObject next;
            int index = evt.getRow();
            this.getModel().setValue("pricex", this.getModel().getValue("pricey", index - 1));
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject prev = (DynamicObject)this.getModel().getValue("bwsymbol", index - 1);
            if (prev != null) {
                QFilter qFilter = new QFilter("begin", "!=", prev.get("end"));
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
            if ((next = (DynamicObject)this.getModel().getValue("bwsymbol", index + 1)) != null) {
                QFilter qFilter = new QFilter("end", "!=", next.get("begin"));
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
            }
        }
    }

    protected void markPriceChgEvt(boolean isInitForm) {
        String markPrice = (String)this.getModel().getValue("markprice");
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"obsfreq"});
        if (MarkPriceEnum.spec_point.getValue().equals(markPrice)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"marktime", "markzone"});
            this.setValue(isInitForm, "markzone", TcDateUtils.getSysZone().getLong("id"));
        } else if (MarkPriceEnum.ctu_price.getValue().equals(markPrice)) {
            this.setValue(isInitForm, "obsfreq", ObsFrequeEnum.continuous);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"obsfreq"});
            this.setValue(isInitForm, "markzone", null);
        } else {
            this.setValue(isInitForm, "markzone", null);
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"marktime", "markzone"});
        }
    }

    private void setValue(boolean isInitForm, String k, Object v) {
        if (!isInitForm) {
            this.getModel().setValue(k, v);
        }
    }

    protected void initLastObsDate() {
        String obsFreq = (String)this.getModel().getValue("obsfreq");
        if (EmptyUtil.isNoEmpty((String)obsFreq) && ObsFrequeEnum.one.getValue().equals(obsFreq)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"lastobsdate"});
            this.getModel().setValue("lastobsdate", null);
        } else {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"lastobsdate"});
        }
    }

    protected void initEntrysObsDate() {
        String obsFreq = (String)this.getModel().getValue("obsfreq");
        if (EmptyUtil.isNoEmpty((String)obsFreq)) {
            ObsFrequeEnum freq = ObsFrequeEnum.valueOf((String)obsFreq);
            switch (freq) {
                case month: 
                case season: 
                case half_year: 
                case year: {
                    this.initObserveTime();
                    break;
                }
                default: {
                    this.getModel().deleteEntryData("observe");
                }
            }
        }
    }

    private void initObserveTime() {
        this.getModel().deleteEntryData("observe");
        Date intdate = (Date)this.getModel().getValue("intdate");
        Date firstObsTime = (Date)this.getModel().getValue("firstobsdate");
        Date lastObsTime = (Date)this.getModel().getValue("lastobsdate");
        if (EmptyUtil.isNoEmpty((Object)firstObsTime) && EmptyUtil.isNoEmpty((Object)lastObsTime)) {
            String obsFreq = (String)this.getModel().getValue("obsfreq");
            String term = ObsFrequeEnum.getTerm((String)obsFreq);
            this.getModel().deleteEntryData("observe");
            Date unChangeIntDate = intdate;
            while (intdate.before(TcDateUtils.getFirstDayOfMonth((Date)lastObsTime))) {
                if (intdate.compareTo(firstObsTime) <= 0 && unChangeIntDate.compareTo(intdate) == 0) {
                    this.initObsEntry(firstObsTime);
                } else if (intdate.compareTo(firstObsTime) > 0) {
                    this.initObsEntry(intdate);
                }
                intdate = TermUtils.getDateByBaseDate4ymd((String)term, (Date)intdate);
            }
            this.initObsEntry(lastObsTime);
        }
        this.getView().updateView("observe");
        List items = StructDepositHelper.initRedeemDateBox((IDataModel)this.getModel(), (IFormView)this.getView());
        if (items.size() > 0) {
            this.getModel().setValue("redeemdate2", (Object)((ComboItem)items.get(0)).getValue());
        }
    }

    private void initObsEntry(Date obsDate) {
        Date firstObsTime = (Date)this.getModel().getValue("firstobsdate");
        Date lastObsTime = (Date)this.getModel().getValue("lastobsdate");
        AdjustMethodEnum adjustMethod = AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod2")));
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Integer settleDelay = (Integer)this.getModel().getValue("settledelay");
        Date adjObsDate = obsDate;
        if (obsDate.compareTo(firstObsTime) != 0 && obsDate.compareTo(lastObsTime) != 0) {
            adjObsDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)obsDate, (AdjustMethodEnum)adjustMethod);
            adjObsDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)adjObsDate, (int)(-settleDelay.intValue()));
        }
        int index = this.getModel().createNewEntryRow("observe");
        this.getModel().setValue("obsdate", (Object)adjObsDate, index);
        Date sysObsDate = this.callObserveSysTime(adjObsDate, index);
        this.getModel().setValue("obssystime", (Object)sysObsDate, index);
    }

    private void callObserveSysTime() {
        this.isShowLabel();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("observe");
        for (int index = 0; index < entrys.size(); ++index) {
            DynamicObject entry = (DynamicObject)entrys.get(index);
            Date obsDate = entry.getDate("obsdate");
            Date obsSysDate = this.callObserveSysTime(obsDate, index);
            this.getModel().setValue("obssystime", (Object)obsSysDate, index);
        }
    }

    private Date callObserveSysTime(Date obsDate, int index) {
        Integer markTime = (Integer)this.getModel().getValue("marktime");
        DynamicObject markZone = (DynamicObject)this.getModel().getValue("markzone");
        if (EmptyUtil.isNoEmpty((Object)obsDate) && markTime > 0) {
            obsDate = TcDateUtils.addSecond((Date)obsDate, (int)markTime);
            if (EmptyUtil.isNoEmpty((DynamicObject)markZone)) {
                TimeZone zone = TcDateUtils.getTimeZone((DynamicObject)markZone);
                TimeZone sysZone = KDDateUtils.getSysTimeZone();
                if (!zone.getID().equals(sysZone.getID())) {
                    obsDate = TcDateUtils.getZoneTime((Date)obsDate, (TimeZone)zone);
                }
            }
        }
        return obsDate;
    }

    private void isShowLabel() {
        boolean isShow = false;
        String markPrice = (String)this.getModel().getValue("markprice");
        DynamicObject markZone = (DynamicObject)this.getModel().getValue("markzone");
        if (EmptyUtil.isNoEmpty((DynamicObject)markZone)) {
            TimeZone zone = TcDateUtils.getTimeZone((DynamicObject)markZone);
            TimeZone sysZone = KDDateUtils.getSysTimeZone();
            if (MarkPriceEnum.spec_point.getValue().equals(markPrice) && !zone.getID().equals(sysZone.getID())) {
                isShow = true;
            }
        }
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"labelobs"});
    }

    private void initAndDefaultLastObsDateVal() {
        Date firstObsDate = (Date)this.getModel().getValue("firstobsdate");
        Date settleDate = (Date)this.getModel().getValue("settledate");
        ((DateTimeEdit)this.getControl("lastobsdate")).setMaxDate(settleDate);
        ((DateTimeEdit)this.getControl("lastobsdate")).setMinDate(firstObsDate);
    }

    private void checkObsDate(Integer rowIndex) {
        Date lastDate;
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("observe");
        Date currDate = (Date)this.getModel().getValue("obsdate", rowIndex.intValue());
        Date beforeDate = rowIndex > 0 ? (Date)this.getModel().getValue("obsdate", rowIndex - 1) : null;
        Date date = lastDate = rowIndex + 1 < entrys.size() ? (Date)this.getModel().getValue("obsdate", rowIndex + 1) : null;
        if (EmptyUtil.isNoEmpty((Object)currDate) && rowIndex >= 0 && rowIndex < entrys.size()) {
            if (EmptyUtil.isNoEmpty((Object)beforeDate) && currDate.compareTo(beforeDate) <= 0) {
                this.getModel().setValue("obsdate", null, rowIndex.intValue());
                this.getView().showErrorNotification(TeBizResource.checkObsDateMin());
            }
            if (EmptyUtil.isNoEmpty((Object)lastDate) && currDate.compareTo(lastDate) >= 0) {
                this.getModel().setValue("obsdate", null, rowIndex.intValue());
                this.getView().showErrorNotification(TeBizResource.checkObsDateMax());
            }
        }
    }

    private void validInitialPrice(BigDecimal initialPrice, String hooktype, BeforeFieldPostBackEvent e) {
        String priceMethod = (String)this.getModel().getValue("pricemethod");
        if (!"precent".equals(priceMethod) || EmptyUtil.isEmpty((BigDecimal)initialPrice)) {
            return;
        }
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (hooktype != null && hooktype.equals(HookTypeEnum.referrate.getValue())) {
            if (initialPrice.compareTo(BigDecimal.valueOf(100L)) > 0 || initialPrice.compareTo(BigDecimal.ZERO) < 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u521d\u4ef7\u683c\uff08%\uff09\u53ef\u8f93\u5165\u7684\u8303\u56f4\u4e3a0\u5230100", (String)"BusinessInfoTabEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        } else if (initialPrice.compareTo(BigDecimal.valueOf(1000000L)) > 0 || initialPrice.compareTo(BigDecimal.ZERO) < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u671f\u521d\u4ef7\u683c\u53ef\u8f93\u5165\u7684\u8303\u56f4\u4e3a0\u52301000000", (String)"BusinessInfoTabEdit_1", (String)"tmc-cfm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            this.getView().updateView(key);
        }
    }
}

