/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.swaps;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class SettleAdjustFarPlugin
extends AbstractTmcBillEdit {
    private static final Date MAX_DATE = TcDateUtils.stringToDate((String)"2099-12-31", (String)"yyyy-MM-dd");

    public void afterCopyData(EventObject e) {
        this.initBySwapType();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSwapType();
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue() || OperationStatus.EDIT.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setControl();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "isovernight": {
                if (!ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(this.getModel().getValue("swaptype"))) {
                    this.getModel().setValue("swaptype", null);
                } else {
                    this.initBySwapType();
                    this.setControl();
                }
                this.initSwapType();
                break;
            }
            case "swaptype": {
                this.initBySwapType();
                this.setControl();
                break;
            }
            default: {
                boolean isRefreshControl = false;
                if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(this.getModel().getValue("swaptype"))) {
                    isRefreshControl = this.propertyChanged_spotToSpot(propName);
                } else if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(this.getModel().getValue("swaptype"))) {
                    isRefreshControl = this.propertyChanged_spotToFwd(propName);
                } else if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(this.getModel().getValue("swaptype"))) {
                    isRefreshControl = this.propertyChanged_fwdToFwd(propName);
                }
                if (!isRefreshControl) break;
                this.setControl();
            }
        }
    }

    private void initBySwapType() {
        Object swapType = this.getModel().getValue("swaptype");
        if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType)) {
            this.init_spotToSpot();
        } else if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType)) {
            this.init_spotToFwd();
        } else if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType)) {
            this.init_fwdToFwd();
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset", (Object)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term_far", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate_far", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"adjustsettledate", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"adjustsettledate_far", null);
        }
    }

    private void init_spotToSpot() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)0);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset", (Object)0);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", (Object)this.getModel().getValue("bizdate"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset_far", (Object)1);
        this.setDateByOffSet("settledate", 1, "settledate_far");
        this.setAdjDate("settledate", "adjustsettledate");
        this.setAdjDate("settledate_far", "adjustsettledate_far");
    }

    private void init_spotToFwd() {
        if (((Boolean)this.getModel().getValue("isovernight")).booleanValue()) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)2);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset", (Object)2);
            this.setDateByOffSet("bizdate", 2, "settledate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset_far", (Object)1);
            this.setDateByOffSet("settledate", 1, "settledate_far");
            this.setAdjDate("settledate", "adjustsettledate");
            this.setAdjDate("settledate_far", "adjustsettledate_far");
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)2);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)"0d");
            this.setDateByOffSet("bizdate", (Integer)this.getModel().getValue("settledelay"), "settledate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term_far", (Object)"1d");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate_far", (Object)TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term_far")), (Date)this.getDateByOffSet("bizdate", 2)));
            this.setAdjDate("settledate", "adjustsettledate");
            this.setAdjDate("settledate_far", "adjustsettledate_far");
        }
    }

    private void init_fwdToFwd() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)2);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)"1d");
        this.setDateByOffSetAndTerm("bizdate", 2, (String)this.getModel().getValue("term"), "settledate");
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term_far", (Object)"2d");
        this.setDateByOffSetAndTerm("bizdate", 2, (String)this.getModel().getValue("term_far"), "settledate_far");
        this.setAdjDate("settledate", "adjustsettledate");
        this.setAdjDate("settledate_far", "adjustsettledate_far");
    }

    private void setControl() {
        Object swapType = this.getModel().getValue("swaptype");
        if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType)) {
            this.setMinDate("bizdate", 0, null, "settledate");
            this.setMaxDate("bizdate", 1, null, "settledate");
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"offset", "offset_far", "settledate_far"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"settledelay", "settledate"});
        } else if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType)) {
            if (((Boolean)this.getModel().getValue("isovernight")).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"settledelay", "offset", "settledate", "offset_far", "settledate_far"});
            } else {
                this.setMinDate("bizdate", 0, null, "settledate");
                this.setMaxDate("bizdate", 2, null, "settledate");
                ((DateEdit)this.getControl("settledate_far")).setMinDate(TermUtils.getDateByTerm((String)"1d", (Date)this.getMaxDate((Date)this.getModel().getValue("settledate"), this.getDateByOffSet("bizdate", 2))));
                ((DateEdit)this.getControl("settledate_far")).setMaxDate(MAX_DATE);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"term"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"settledelay", "settledate", "term_far", "settledate_far"});
            }
        } else if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType)) {
            this.setMinDate("bizdate", 2, "1d", "settledate");
            ((DateEdit)this.getControl("settledate")).setMaxDate(MAX_DATE);
            this.setMinDate("bizdate", 2, "2d", "settledate_far");
            ((DateEdit)this.getControl("settledate_far")).setMaxDate(MAX_DATE);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"settledelay"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"term", "settledate", "term_far", "settledate_far"});
        }
    }

    private boolean propertyChanged_spotToSpot(String propName) {
        switch (propName) {
            case "bizdate": 
            case "workcalendar": 
            case "dateadjustmethod": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate", (Object)this.getModel().getValue("bizdate"));
                this.setDateByOffSet("bizdate", (Integer)this.getModel().getValue("settledelay"), "settledate");
                this.setDateByOffSet("settledate", 1, "settledate_far");
                this.setAdjDate("settledate", "adjustsettledate");
                this.setAdjDate("settledate_far", "adjustsettledate_far");
                return true;
            }
            case "settledelay": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset", (Object)this.getModel().getValue("settledelay"));
                this.setDateByOffSet("bizdate", (Integer)this.getModel().getValue("settledelay"), "settledate");
                this.setDateByOffSet("settledate", 1, "settledate_far");
                this.setAdjDate("settledate", "adjustsettledate");
                this.setAdjDate("settledate_far", "adjustsettledate_far");
                return true;
            }
            case "settledate": {
                int offSet = this.calcOffSet((Date)this.getModel().getValue("bizdate"), (Date)this.getModel().getValue("settledate"));
                if (offSet >= 0) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)offSet);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"offset", (Object)offSet);
                }
                this.setDateByOffSet("settledate", 1, "settledate_far");
                this.setAdjDate("settledate", "adjustsettledate");
                this.setAdjDate("settledate_far", "adjustsettledate_far");
                return true;
            }
        }
        return false;
    }

    private boolean propertyChanged_spotToFwd(String propName) {
        if (((Boolean)this.getModel().getValue("isovernight")).booleanValue()) {
            switch (propName) {
                case "bizdate": 
                case "workcalendar": 
                case "dateadjustmethod": {
                    this.setDateByOffSet("bizdate", 2, "settledate");
                    this.setDateByOffSet("settledate", 1, "settledate_far");
                    this.setAdjDate("settledate", "adjustsettledate");
                    this.setAdjDate("settledate_far", "adjustsettledate_far");
                    return true;
                }
            }
        } else {
            switch (propName) {
                case "bizdate": 
                case "workcalendar": 
                case "dateadjustmethod": {
                    this.setDateByOffSet("bizdate", (Integer)this.getModel().getValue("settledelay"), "settledate");
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate_far", (Object)TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term_far")), (Date)this.getDateByOffSet("bizdate", 2)));
                    this.setAdjDate("settledate", "adjustsettledate");
                    this.setAdjDate("settledate_far", "adjustsettledate_far");
                    return true;
                }
                case "settledelay": {
                    this.setDateByOffSet("bizdate", (Integer)this.getModel().getValue("settledelay"), "settledate");
                    this.setAdjDate("settledate", "adjustsettledate");
                    return true;
                }
                case "settledate": {
                    int offSet = this.calcOffSet((Date)this.getModel().getValue("bizdate"), (Date)this.getModel().getValue("settledate"));
                    if (offSet >= 0) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)offSet);
                    }
                    this.setAdjDate("settledate", "adjustsettledate");
                    return true;
                }
                case "term_far": {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledate_far", (Object)TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term_far")), (Date)this.getDateByOffSet("bizdate", 2)));
                    this.setAdjDate("settledate_far", "adjustsettledate_far");
                    return true;
                }
                case "settledate_far": {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term_far", (Object)TcDateUtils.getDiffYMD((Date)this.getDateByOffSet("bizdate", 2), (Date)((Date)this.getModel().getValue("settledate_far"))));
                    this.setAdjDate("settledate_far", "adjustsettledate_far");
                    return true;
                }
            }
        }
        return false;
    }

    private boolean propertyChanged_fwdToFwd(String propName) {
        switch (propName) {
            case "bizdate": 
            case "workcalendar": 
            case "dateadjustmethod": {
                this.setDateByOffSetAndTerm("bizdate", 2, (String)this.getModel().getValue("term"), "settledate");
                this.setDateByOffSetAndTerm("bizdate", 2, (String)this.getModel().getValue("term_far"), "settledate_far");
                this.setAdjDate("settledate", "adjustsettledate");
                this.setAdjDate("settledate_far", "adjustsettledate_far");
                return true;
            }
            case "term": {
                this.setDateByOffSetAndTerm("bizdate", 2, (String)this.getModel().getValue("term"), "settledate");
                this.setAdjDate("settledate", "adjustsettledate");
                return true;
            }
            case "settledate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term", (Object)TcDateUtils.getDiffYMD((Date)this.getDateByOffSet("bizdate", (int)((Integer)this.getModel().getValue("settledelay"))), (Date)((Date)this.getModel().getValue("settledate"))));
                this.setAdjDate("settledate", "adjustsettledate");
                return true;
            }
            case "term_far": {
                this.setDateByOffSetAndTerm("bizdate", 2, (String)this.getModel().getValue("term_far"), "settledate_far");
                this.setAdjDate("settledate_far", "adjustsettledate_far");
                return true;
            }
            case "settledate_far": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"term_far", (Object)TcDateUtils.getDiffYMD((Date)this.getDateByOffSet("bizdate", (int)((Integer)this.getModel().getValue("settledelay"))), (Date)((Date)this.getModel().getValue("settledate_far"))));
                this.setAdjDate("settledate_far", "adjustsettledate_far");
                return true;
            }
        }
        return false;
    }

    private int calcOffSet(Date startDate, Date endDate) {
        if (startDate.compareTo(endDate) == 0) {
            return 0;
        }
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date adjEndDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)endDate, (AdjustMethodEnum)AdjustMethodEnum.backward);
        if (startDate.compareTo(adjEndDate) == 0) {
            return 0;
        }
        if (this.getDateByOffSet(startDate, 1).compareTo(endDate) == 0) {
            return 1;
        }
        if (this.getDateByOffSet(startDate, 2).compareTo(endDate) == 0) {
            return 2;
        }
        return -1;
    }

    private Date getMaxDate(Date d1, Date d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return TcDateUtils.getDiffDays((Date)TcDateUtils.getDataFormat((Date)d1, (boolean)true), (Date)TcDateUtils.getDataFormat((Date)d2, (boolean)true)) > 0 ? d2 : d1;
    }

    private void setMaxDate(String dateProp, int offSet, String term, String targetDateProp) {
        Date date = (Date)this.getModel().getValue(dateProp);
        if (offSet != 0) {
            date = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)date, (int)offSet, (AdjustMethodEnum)(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("dateadjustmethod")) ? AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod"))) : AdjustMethodEnum.forward));
        }
        if (EmptyUtil.isNoEmpty((String)term)) {
            date = TermUtils.getDateByTerm((String)term, (Date)date);
        }
        ((DateEdit)this.getControl(targetDateProp)).setMaxDate(date);
    }

    private void setMinDate(String dateProp, int offSet, String term, String targetDateProp) {
        Date date = (Date)this.getModel().getValue(dateProp);
        if (offSet != 0) {
            date = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)date, (int)offSet, (AdjustMethodEnum)(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("dateadjustmethod")) ? AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod"))) : AdjustMethodEnum.forward));
        }
        if (EmptyUtil.isNoEmpty((String)term)) {
            date = TermUtils.getDateByTerm((String)term, (Date)date);
        }
        ((DateEdit)this.getControl(targetDateProp)).setMinDate(date);
    }

    private void setDateByOffSet(String dateProp, int offSet, String targetDateProp) {
        Date newDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)((Date)this.getModel().getValue(dateProp)), (int)offSet, (AdjustMethodEnum)(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("dateadjustmethod")) ? AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod"))) : AdjustMethodEnum.forward));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)targetDateProp, (Object)newDate);
    }

    private Date getDateByOffSet(String dateProp, int offSet) {
        return TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)((Date)this.getModel().getValue(dateProp)), (int)offSet, (AdjustMethodEnum)(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("dateadjustmethod")) ? AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod"))) : AdjustMethodEnum.forward));
    }

    private Date getDateByOffSet(Date date, int offSet) {
        return TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)date, (int)offSet, (AdjustMethodEnum)(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("dateadjustmethod")) ? AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod"))) : AdjustMethodEnum.forward));
    }

    private void setDateByOffSetAndTerm(String dateProp, int offSet, String term, String targetDateProp) {
        Date offSetDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)((Date)this.getModel().getValue(dateProp)), (int)offSet, (AdjustMethodEnum)(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("dateadjustmethod")) ? AdjustMethodEnum.valueOf((String)((String)this.getModel().getValue("dateadjustmethod"))) : AdjustMethodEnum.forward));
        Date termDate = TermUtils.getDateByTerm((String)term, (Date)offSetDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)targetDateProp, (Object)termDate);
    }

    private void initSwapType() {
        boolean isOverNight = (Boolean)this.getModel().getValue("isovernight");
        ComboEdit comboEdit = (ComboEdit)this.getControl("swaptype");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>(2);
        if (isOverNight) {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5373\u671f-\u5373\u671f", (String)"ForexSwapsEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])), ForexSwapsTypeEnum.SPOTTOSPOT.getValue()));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5373\u671f-\u8fdc\u671f", (String)"ForexSwapsEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0])), ForexSwapsTypeEnum.SPOTTOFWD.getValue()));
            comboEdit.setComboItems(data);
        } else {
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5373\u671f-\u8fdc\u671f", (String)"ForexSwapsEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0])), ForexSwapsTypeEnum.SPOTTOFWD.getValue()));
            data.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8fdc\u671f-\u8fdc\u671f", (String)"ForexSwapsEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0])), ForexSwapsTypeEnum.FWDTOFWD.getValue()));
            comboEdit.setComboItems(data);
        }
    }

    private void setAdjDate(String dateProp, String adjDateProp) {
        Date settleDate = (Date)this.getModel().getValue(dateProp);
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        String adjMtd = (String)this.getModel().getValue("dateadjustmethod");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{settleDate, adjMtd})) {
            return;
        }
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)adjMtd);
        Date adjDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)settleDate, (AdjustMethodEnum)adjMtdEnum);
        this.getModel().setValue(adjDateProp, (Object)adjDate);
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        super.verifyInput(key, value, e);
        Object swapType = this.getModel().getValue("swaptype");
        switch (key) {
            case "term_far": 
            case "term": {
                if (!TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) {
                    e.setCancel(true);
                    this.getView().updateView(key);
                    return;
                }
                if (!EmptyUtil.isEmpty((Object)swapType)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"SettleAdjustFarPlugin_7", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getModel().getProperty("swaptype").getDisplayName().getLocaleValue()}), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                return;
            }
            case "bizdate": 
            case "settledate": 
            case "settledate_far": {
                if (EmptyUtil.isEmpty((Object)value)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleAdjustFarPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}), Integer.valueOf(2000));
                    this.getView().updateView(key);
                    e.setCancel(true);
                    return;
                }
                if (!EmptyUtil.isEmpty((Object)swapType)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165%s\u3002", (String)"SettleAdjustFarPlugin_7", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getModel().getProperty("swaptype").getDisplayName().getLocaleValue()}), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                return;
            }
        }
        if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType) && "settledelay".equals(key)) {
            int v;
            int n = v = EmptyUtil.isEmpty((Object)e.getValue()) ? 0 : Integer.parseInt((String)e.getValue());
            if (v > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5373\u671f-\u5373\u671f\u6389\u671f\u7c7b\u578b\u4e0b\uff0c\u5373\u671f\u504f\u79fb\u53ea\u80fd\u5f55\u51650\u62161\u3002", (String)"SettleAdjustFarPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
            }
        } else if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType)) {
            if (!((Boolean)this.getModel().getValue("isovernight")).booleanValue() && "term_far".equals(key) && "0d".equals(value)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fdc\u7aef\u671f\u9650\u9700\u5927\u4e8e\u8fd1\u7aef\u671f\u9650\u3002", (String)"SettleAdjustFarPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
            }
        } else if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType)) {
            if ("settledate".equals(key)) {
                Date settleDay = TcDateUtils.stringToDate((String)((String)e.getValue()), (String)"yyyy-MM-dd");
                Date settleDayFar = (Date)this.getModel().getValue("settledate_far");
                if (settleDayFar != null && settleDay.compareTo(TcDateUtils.truncateDate((Date)settleDayFar)) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd1\u7aef\u4ea4\u5272\u65e5\u5fc5\u987b\u5c0f\u4e8e\u8fdc\u7aef\u4ea4\u5272\u65e5\u3002", (String)"SettleAdjustFarPlugin_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    this.getView().updateView(key);
                    e.setCancel(true);
                }
            }
            if ("settledate_far".equals(key)) {
                Date settleDayFar = TcDateUtils.stringToDate((String)((String)e.getValue()), (String)"yyyy-MM-dd");
                Date settleDay = (Date)this.getModel().getValue("settledate");
                if (settleDay != null && settleDayFar.compareTo(TcDateUtils.truncateDate((Date)settleDay)) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fdc\u7aef\u4ea4\u5272\u65e5\u5fc5\u987b\u5927\u4e8e\u8fd1\u7aef\u4ea4\u5272\u65e5\u3002", (String)"SettleAdjustFarPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    this.getView().updateView(key);
                    e.setCancel(true);
                }
            }
            if ("term".equals(key)) {
                if (TermUtils.getDateByTerm((String)((String)e.getValue()), (Date)MAX_DATE).compareTo(TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term_far")), (Date)MAX_DATE)) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd1\u7aef\u671f\u9650\u9700\u5c0f\u4e8e\u8fdc\u7aef\u671f\u9650\u3002", (String)"SettleAdjustFarPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    this.getView().updateView(key);
                    e.setCancel(true);
                }
                if ("0d".equals(e.getValue())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fdc\u671f-\u8fdc\u671f\u6389\u671f\u7c7b\u578b\u4e0b\uff0c\u8fd1\u7aef\u4e3a\u8fdc\u671f\u4ea4\u6613\uff0c\u8fd1\u7aef\u671f\u9650\u9700\u5927\u4e8e\u7b49\u4e8e1d\u3002", (String)"SettleAdjustFarPlugin_8", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                    this.getView().updateView(key);
                    e.setCancel(true);
                }
            }
            if ("term_far".equals(key) && TermUtils.getDateByTerm((String)((String)e.getValue()), (Date)MAX_DATE).compareTo(TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term")), (Date)MAX_DATE)) <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fdc\u7aef\u671f\u9650\u9700\u5927\u4e8e\u8fd1\u7aef\u671f\u9650\u3002", (String)"SettleAdjustFarPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
            }
        }
    }
}

