/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.business.service.bizbill.BizBillAuditServiceFactory;
import kd.tmc.tm.business.service.bizbill.IBizBillAuditService;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class TradeBillEdit
extends AbstractTmcBillEdit {
    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (e.getSource() instanceof BillShowParameter && !((BillShowParameter)e.getSource()).getCustomParams().containsKey("protecttype")) {
            Object billId = ((BillShowParameter)e.getSource()).getPkId();
            if (billId == null) {
                return;
            }
            if (OperationStatus.ADDNEW.equals((Object)((BillShowParameter)e.getSource()).getStatus())) {
                return;
            }
            DynamicObject info = QueryServiceHelper.queryOne((String)"tm_trade", (String)"billStatus", (QFilter[])new QFilter("id", "=", billId).toArray());
            if (info == null) {
                return;
            }
            String billStatus = info.getString("billstatus");
            if (TcBillStatusEnum.SURVIVAL.getValue().equals(billStatus) || TcBillStatusEnum.FINISH.getValue().equals(billStatus)) {
                ((BillShowParameter)e.getSource()).setBillStatus(BillOperationStatus.AUDIT);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Row row;
        Iterator it;
        String sSQL;
        DataSet ds;
        super.afterCreateNewData(e);
        String protecttype = (String)this.getView().getFormShowParameter().getCustomParam("protecttype");
        if (!EmptyUtil.isEmpty((String)protecttype)) {
            this.getModel().setValue("protecttype", (Object)Long.valueOf(protecttype));
        }
        if (!(ds = DB.queryDataSet((String)"default", (DBRoute)DBRouteConst.TC, (String)(sSQL = "Select FPriceRuleId From T_Tbd_Default"))).isEmpty() && (it = ds.iterator()).hasNext() && EmptyUtil.isNoEmpty((Long)(row = (Row)it.next()).getLong("FPriceRuleId"))) {
            this.getModel().setValue("pricerule", (Object)row.getLong("FPriceRuleId"));
        }
        this.getModel().setValue("referdate", (Object)TcDateUtils.getCurrentDate());
        this.getModel().setValue("bizdate", (Object)TcDateUtils.getCurrentDate());
        Long id = DBServiceHelper.genGlobalLongId();
        this.getModel().setValue("id", (Object)id);
        DynamicObject defaultPriceRule = TmcDataServiceHelper.loadSingle((String)"md_pricerule", (String)"id,defaultrule", (QFilter[])new QFilter[]{new QFilter("defaultrule", "=", (Object)Boolean.TRUE)});
        if (EmptyUtil.isNoEmpty((DynamicObject)defaultPriceRule)) {
            this.getModel().setValue("pricerule", defaultPriceRule.getPkValue());
        }
        this.setDefaultVariety();
    }

    private void setDefaultVariety() {
        DynamicObject protecttype = (DynamicObject)this.getModel().getValue("protecttype");
        if (EmptyUtil.isEmpty((DynamicObject)protecttype)) {
            return;
        }
        ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumById((String)String.valueOf(protecttype.getPkValue()));
        switch (productTypeEnum) {
            case FOREXSPOT: 
            case FOREXFORWARD: 
            case FOREXSWAPS: 
            case FOREXOPTION: {
                this.getModel().setValue("variety", (Object)ResManager.loadKDString((String)"\u5916\u6c47", (String)"TradeBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                break;
            }
            case SWAP: 
            case FORWRATEAGREE: {
                this.getModel().setValue("variety", (Object)ResManager.loadKDString((String)"\u5229\u7387", (String)"TradeBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String entity;
        IBizBillAuditService service;
        String billType;
        boolean composeAudit;
        DynamicObject dataEntity;
        IDataEntityType dataEntityType;
        boolean hasComposeaudit;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operate = op.getOperateKey();
        if ("submit".equals(operate) && (hasComposeaudit = (dataEntityType = (dataEntity = this.getModel().getDataEntity()).getDataEntityType()).getProperties().containsKey((Object)"composeaudit")) && (composeAudit = ((Boolean)this.getModel().getValue("composeaudit")).booleanValue())) {
            FormOperate source = (FormOperate)args.getSource();
            source.getOption().setVariableValue("WF", "TRUE");
        }
        if (EmptyUtil.isEmpty((String)BizOperateEnum.getName((String)operate))) {
            return;
        }
        if (!op.getOption().containsVariable("billType") && EmptyUtil.isNoEmpty((String)(billType = (service = BizBillAuditServiceFactory.createTradeFactory((String)(entity = this.getModel().getDataEntityType().getName()))).getBizBillTypeId(operate)))) {
            if (!this.verify((Long)this.getModel().getValue("id"), service, operate)) {
                args.setCancel(true);
                return;
            }
            op.getOption().setVariableValue("billType", billType);
        }
        op.getOption().setVariableValue("operate", operate);
    }

    protected boolean verify(Long id, IBizBillAuditService service, String operate) {
        Map result = service.verifyBeforeDo(id, operate);
        if (EmptyUtil.isEmpty((Object)result)) {
            return true;
        }
        String tip = (String)result.get("tip");
        if (EmptyUtil.isNoEmpty((String)tip)) {
            this.getView().showTipNotification(tip);
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        if (args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            switch (opKey) {
                case "tradecfg": 
                case "cancelcfg": {
                    this.getView().invokeOperation("refresh");
                    break;
                }
                case "delete": {
                    this.getView().getModel().setDataChanged(false);
                    this.getView().close();
                    break;
                }
                case "viewpl": {
                    if (EmptyUtil.isEmpty((Object)this.getModel().getDataEntity().getPkValue())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u635f\u76ca\u4fe1\u606f\u3002", (String)"FindNotPlInfo", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                        break;
                    }
                    QFilter filter = new QFilter("tradebill", "=", this.getModel().getDataEntity().getPkValue());
                    if (TmcDataServiceHelper.exists((String)"tbo_plinfo", (QFilter[])new QFilter[]{filter})) {
                        DynamicObject[] plInfos = TmcDataServiceHelper.load((String)"tbo_plinfo", (String)"id", (QFilter[])new QFilter[]{filter});
                        Object plBillId = plInfos[0].get("id");
                        String formId = this.getFormId(plBillId, plInfos.length);
                        if (plInfos.length > 1) {
                            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)0, (boolean)false);
                            parameter.setCaption(ResManager.loadKDString((String)"\u635f\u76ca\u4fe1\u606f\u5217\u8868", (String)"TradeList_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                            parameter.getListFilterParameter().getQFilters().add(filter);
                            DynamicObject trade = QueryServiceHelper.queryOne((String)"tm_trade", (String)"org", (QFilter[])new QFilter("id", "=", this.getModel().getValue("id")).toArray());
                            parameter.setCustomParam("trade_org_id", (Object)String.valueOf(trade.getLong("org")));
                            this.getView().showForm((FormShowParameter)parameter);
                            break;
                        }
                        BillShowParameter param = new BillShowParameter();
                        param.setStatus(OperationStatus.VIEW);
                        param.setFormId(formId);
                        param.setCaption(ResManager.loadKDString((String)"\u635f\u76ca\u4fe1\u606f", (String)"TradeList_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                        param.setPkId(plBillId);
                        this.getView().showForm((FormShowParameter)param);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u635f\u76ca\u4fe1\u606f\u3002", (String)"FindNotPlInfo", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term": {
                if (TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) break;
                e.setCancel(true);
                this.getView().updateView(key);
                return;
            }
        }
    }

    private String getFormId(Object plBillId, int plInfoCount) {
        DynamicObject plBill = QueryServiceHelper.queryOne((String)"tbo_plinfo", (String)"tradetype", (QFilter[])new QFilter("id", "=", plBillId).toArray());
        if (ProductTypeEnum.FOREXSPOT.getId().equals(plBill.getString("tradetype")) || ProductTypeEnum.FOREXFORWARD.getId().equals(plBill.getString("tradetype")) || ProductTypeEnum.FOREXSWAPS.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_plinfo_forexfwd_l";
        }
        if (ProductTypeEnum.FOREXOPTION.getId().equals(plBill.getString("tradetype"))) {
            if (plInfoCount > 1) {
                return "tbo_plinfo_forexfwd_l";
            }
            return "tbo_plinfo_forexoption_l";
        }
        if (ProductTypeEnum.STRUCTDEPOSIT.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_pl_structdeposit_l";
        }
        if (ProductTypeEnum.SWAP.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_plinfo_swap_l";
        }
        if (ProductTypeEnum.FORWRATEAGREE.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_plinfo_forwrateag_l";
        }
        return "tbo_plinfo";
    }
}

