/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.events.BillClosedCallBackEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.tm.business.service.bizbill.BizBillAuditServiceFactory;
import kd.tmc.tm.business.service.bizbill.IBizBillAuditService;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class TradeBizDealList
extends AbstractTmcListPlugin {
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (StringUtils.equals((CharSequence)"settle", (CharSequence)args.getOperateKey()) || StringUtils.equals((CharSequence)"unsettle", (CharSequence)args.getOperateKey())) {
            ((BillList)this.getControl("billlistap")).refresh();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        if (e.getParameter().getFormId().equals("tm_trade") && !OperationStatus.ADDNEW.equals((Object)e.getParameter().getStatus())) {
            Object pkId = e.getParameter().getPkId();
            DynamicObject tradeBill = QueryServiceHelper.queryOne((String)"tm_trade", (String)"billstatus, protecttype", (QFilter[])new QFilter[]{new QFilter("id", "=", pkId)});
            String billStaus = tradeBill.getString("billstatus");
            if (billStaus.equals(TcBillStatusEnum.SURVIVAL.getValue()) || billStaus.equals(TcBillStatusEnum.FINISH.getValue())) {
                e.getParameter().setStatus(OperationStatus.VIEW);
            }
            QFilter filter = new QFilter("tradetype.id", "=", (Object)tradeBill.getLong("protecttype"));
            Map setColl = TmcDataServiceHelper.loadFromCache((String)"tbd_tradeset", (QFilter[])filter.toArray());
            setColl.forEach((key, tradeSet) -> {
                if (EmptyUtil.isNoEmpty((DynamicObject)tradeSet) && tradeSet.getDynamicObject("bill").getString("number").endsWith("_l")) {
                    e.getParameter().setFormId(tradeSet.getDynamicObject("bill").getString("number"));
                }
            });
        }
    }

    public void billClosedCallBack(BillClosedCallBackEvent e) {
        ((BillList)this.getControl("billlistap")).refresh();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        BillList billList;
        String entity;
        IBizBillAuditService service;
        String billType;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operate = op.getOperateKey();
        if (EmptyUtil.isEmpty((String)BizOperateEnum.getName((String)operate))) {
            return;
        }
        if (!op.getOption().containsVariable("billType") && EmptyUtil.isNoEmpty((String)(billType = (service = BizBillAuditServiceFactory.createTradeFactory((String)(entity = (billList = (BillList)this.getControl("billlistap")).getEntityId()))).getBizBillTypeId(operate)))) {
            Long id = this.getSelectedId();
            if (EmptyUtil.isEmpty((Long)id)) {
                args.setCancel(true);
            } else {
                if (!this.verify(id, service, operate)) {
                    args.setCancel(true);
                    return;
                }
                if (this.isCfgVerify(id, entity, operate, billType)) {
                    args.setCancel(true);
                }
            }
            op.getOption().setVariableValue("billType", billType);
        }
        op.getOption().setVariableValue("operate", operate);
    }

    protected boolean verify(Long id, IBizBillAuditService service, String operate) {
        Map result = service.verifyBeforeDo(id, operate);
        if (EmptyUtil.isEmpty((Object)result)) {
            return true;
        }
        String tip = (String)result.get("tip");
        if (EmptyUtil.isNoEmpty((String)tip)) {
            this.getView().showTipNotification(tip);
            return false;
        }
        return true;
    }

    protected boolean isCfgVerify(Long id, String entity, String operate, String billType) {
        return false;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if ("cfgVerify".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("billType", this.getPageCache().get("billType"));
            this.getView().invokeOperation(this.getPageCache().get("operate"), op);
        }
    }

    protected boolean disableDoubleClick() {
        FormShowParameter param = this.getView().getFormShowParameter();
        return param.getCustomParams().containsKey("isOptionCombTrade") || param.getCustomParams().containsKey("isCombTrade");
    }
}

