/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizRecordDescEnum;

public class TradeBizRecordTabEdit
extends AbstractFormPlugin
implements TabSelectListener {
    public static final String RECORD_KEYS = "recordkeys";
    public static final String RECORD_KEY_PRE = "recordcontain";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Container control = (Container)this.getView().getControl("fp_bizbody");
        QFilter filter = new QFilter("tradebillid", "=", (Object)this.getModel().getDataEntity().getLong("id"));
        Object[] bizrecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"id,pid,lv,seqno,bizdate,enddate,restamt,exrate,currency,desc,srcbizbill,entryentity.bizop,entryentity.opdate,entryentity.amount,entryentity.bizbillid", (QFilter[])new QFilter[]{filter}, (String)"lv,seqno");
        if (EmptyUtil.isNoEmpty((Object[])bizrecords)) {
            this.orderByBizDate((DynamicObject[])bizrecords);
            List<DynamicObject> result = this.getDataForDraw((DynamicObject[])bizrecords);
            this.drawBizRecord(control, result, "bizrecord");
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fp_bizbody"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fp_bizbody"});
        }
    }

    protected void orderByBizDate(DynamicObject[] bizrecords) {
        HashMap<Long, Date> map = new HashMap<Long, Date>();
        for (DynamicObject bizRecord : bizrecords) {
            DynamicObjectCollection entryEntity = bizRecord.getDynamicObjectCollection("entryentity");
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entryEntity)) continue;
            for (DynamicObject entityRow : entryEntity) {
                if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{entityRow.getLong("bizbillid"), entityRow.getDate("opdate")})) continue;
                map.put(entityRow.getLong("bizbillid"), entityRow.getDate("opdate"));
            }
        }
        Arrays.sort(bizrecords, (o1, o2) -> {
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{o1.get("srcbizbill"), o2.get("srcbizbill"), map.get(o1.get("srcbizbill")), map.get(o2.get("srcbizbill"))})) {
                return 1;
            }
            return ((Date)map.get(o1.get("srcbizbill"))).compareTo((Date)map.get(o2.get("srcbizbill")));
        });
    }

    protected List<DynamicObject> getDataForDraw(DynamicObject[] bizrecords) {
        HashMap<Long, DynamicObject> key_object = new HashMap<Long, DynamicObject>(bizrecords.length);
        HashMap<Long, List<Long>> key_node = new HashMap<Long, List<Long>>(bizrecords.length);
        for (DynamicObject record : bizrecords) {
            key_object.put(record.getLong("id"), record);
            Long pid = record.getLong("pid");
            if (!EmptyUtil.isNoEmpty((Long)pid)) continue;
            ArrayList sub = (ArrayList)key_node.get(pid);
            if (EmptyUtil.isEmpty((Collection)sub)) {
                sub = new ArrayList(1);
            }
            key_node.put(pid, sub);
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (DynamicObject record : bizrecords) {
            Long id = record.getLong("id");
            if (!key_object.containsKey(id)) continue;
            this.dealData(id, key_object, key_node, result);
        }
        return result;
    }

    protected void drawBizRecord(Container control, List<DynamicObject> result, String recordPanelFlag) {
        int i;
        String recordKeys = this.getView().getPageCache().get(RECORD_KEYS);
        if (EmptyUtil.isNoEmpty((String)recordKeys)) {
            control.deleteControls(recordKeys.split(","));
        }
        HashMap<Long, FlexPanelAp> containAps = new HashMap<Long, FlexPanelAp>(result.size());
        CharSequence[] keys = new String[result.size()];
        for (i = 0; i < result.size(); ++i) {
            DynamicObject oneRecord = result.get(i);
            FlexPanelAp oneBizPanelAp = new FlexPanelAp();
            oneBizPanelAp.setName(new LocaleString(BizRecordDescEnum.getName((String)oneRecord.getString("desc"))));
            oneBizPanelAp.setDirection("column");
            oneBizPanelAp.setAlignItems("stretch");
            oneBizPanelAp.setJustifyContent("center");
            oneBizPanelAp.setDefaultcollapse(false);
            oneBizPanelAp.setCollapsible(true);
            String key = RECORD_KEY_PRE + i;
            keys[i] = key;
            oneBizPanelAp.setKey(key);
            FlexPanelAp containerAp = new FlexPanelAp();
            containerAp.setKey(recordPanelFlag + i);
            oneBizPanelAp.getItems().add(containerAp);
            FlexPanelAp pContainerAp = (FlexPanelAp)containAps.get(oneRecord.getLong("pid"));
            if (EmptyUtil.isNoEmpty((Object)pContainerAp)) {
                pContainerAp.getItems().add(oneBizPanelAp);
            }
            containAps.put(oneRecord.getLong("id"), oneBizPanelAp);
        }
        this.getView().getPageCache().put(RECORD_KEYS, String.join((CharSequence)",", keys));
        control.addControls(Collections.singletonList(((FlexPanelAp)containAps.get(result.get(0).getLong("id"))).createControl()));
        for (i = 0; i < result.size(); ++i) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId("tm_bizrecord");
            showParameter.getOpenStyle().setShowType(ShowType.InContainer);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.getOpenStyle().setTargetKey(recordPanelFlag + i);
            showParameter.setPkId((Object)result.get(i).getLong("id"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void dealData(Long id, Map<Long, DynamicObject> key_object, Map<Long, List<Long>> key_node, List<DynamicObject> result) {
        DynamicObject temp = key_object.remove(id);
        result.add(temp);
        List<Long> sub = key_node.get(id);
        if (EmptyUtil.isNoEmpty(sub)) {
            for (Long subId : sub) {
                this.dealData(subId, key_object, key_node, result);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
        }
        this.getModel().setValue("contractno_v", this.getModel().getValue("contractnumber"));
        this.getModel().setValue("bizdate_v", this.getModel().getValue("bizdate"));
        this.getModel().setValue("org_v", this.getModel().getValue("org"));
        this.getModel().setValue("counterparty_v", this.getModel().getValue("counterparty"));
        this.getModel().setValue("protecttype_v", this.getModel().getValue("protecttype"));
        this.getModel().setValue("billno_v", this.getModel().getValue("billno"));
        this.getModel().setValue("contract_v", this.getModel().getValue("contractname"));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        if (tabap != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        if (tabSelectEvent.getTabKey().equals("tabbusiness")) {
            boolean dataChanged = this.getModel().getDataChanged();
            this.getModel().setValue("contractno_v", this.getModel().getValue("contractnumber"));
            this.getModel().setValue("bizdate_v", this.getModel().getValue("bizdate"));
            this.getModel().setValue("org_v", this.getModel().getValue("org"));
            this.getModel().setValue("counterparty_v", this.getModel().getValue("counterparty"));
            this.getModel().setValue("protecttype_v", this.getModel().getValue("protecttype"));
            this.getModel().setValue("billno_v", this.getModel().getValue("billno"));
            this.getModel().setValue("contract_v", this.getModel().getValue("contractname"));
            this.getModel().setDataChanged(dataChanged);
        }
    }
}

