/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.tm.common.resource.TeBizResource;

public class TradeList
extends AbstractTmcListPlugin {
    private static final String PARAM_KEY_IS_OPTIONCOMBTRADE = "isOptionCombTrade";
    private static final String PARAM_KEY_IS_COMBTRADE = "isCombTrade";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        ProductTypeEnum productType;
        DynamicObject info;
        Object pkId = e.getParameter().getPkId();
        if (!EmptyUtil.isEmpty((Object)pkId) && (info = QueryServiceHelper.queryOne((String)"tm_trade", (String)"org, protecttype", (QFilter[])new QFilter("id", "=", pkId).toArray())) != null && (productType = ProductTypeEnum.getEnumById((String)info.getString("protecttype"))) != null) {
            e.getParameter().setFormId(productType.getFormId());
            String srcEntity = ((IListView)this.getView()).getListModel().getEntityId();
            if ("tm_trade".equals(srcEntity)) {
                String entity = productType.getEntity();
                String appid = EmptyUtil.isEmpty((String)e.getParameter().getAppId()) ? "tm" : e.getParameter().getAppId();
                Long orgid = info.getLong("org");
                TmcOrgDataHelper.checkFunctionPermission((String)appid, (long)RequestContext.get().getCurrUserId(), (long)orgid, (String)entity, (String)"47150e89000000ac");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("viewpl".equals(key)) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"TradeList_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            Set tradeIds = selectedRows.stream().map(row -> row.getPrimaryKeyValue()).collect(Collectors.toSet());
            QFilter filter = new QFilter("tradebill", "in", tradeIds);
            DynamicObjectCollection plInfos = QueryServiceHelper.query((String)"tbo_plinfo", (String)"id,org,tradebill", (QFilter[])filter.toArray());
            long size = plInfos.stream().map(pl -> pl.getLong("tradebill")).distinct().count();
            if ((long)tradeIds.size() > size) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u9009\u4ea4\u6613\u7684\u5355\u636e\u72b6\u6001\u4e0b\u635f\u76ca\u5c1a\u672a\u751f\u6210\uff0c\u65e0\u6cd5\u67e5\u770b\u635f\u76ca\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u636e\u3002", (String)"TradeList_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!this.validatePlPermission(plInfos)) {
                return;
            }
            Object plBillId = ((DynamicObject)plInfos.get(0)).get("id");
            String formId = this.getFormId(plBillId, plInfos.size());
            if (plInfos.size() > 1) {
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)true, (int)0, (boolean)false);
                parameter.setCaption(ResManager.loadKDString((String)"\u635f\u76ca\u4fe1\u606f\u5217\u8868", (String)"TradeList_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                parameter.getListFilterParameter().getQFilters().add(filter);
                DynamicObjectCollection tradeCol = QueryServiceHelper.query((String)"tm_trade", (String)"org", (QFilter[])new QFilter("id", "in", tradeIds).toArray());
                parameter.setCustomParam("trade_org_ids", tradeCol.stream().map(trade -> String.valueOf(trade.getLong("org"))).distinct().toArray(String[]::new));
                this.getView().showForm((FormShowParameter)parameter);
            } else {
                BillShowParameter param = new BillShowParameter();
                param.setStatus(OperationStatus.VIEW);
                param.setFormId(formId);
                param.setCaption(ResManager.loadKDString((String)"\u635f\u76ca\u4fe1\u606f", (String)"TradeList_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setPkId(plBillId);
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    private String getFormId(Object plBillId, int plInfoCount) {
        DynamicObject plBill = QueryServiceHelper.queryOne((String)"tbo_plinfo", (String)"tradetype", (QFilter[])new QFilter("id", "=", plBillId).toArray());
        if (ProductTypeEnum.FOREXSPOT.getId().equals(plBill.getString("tradetype")) || ProductTypeEnum.FOREXFORWARD.getId().equals(plBill.getString("tradetype")) || ProductTypeEnum.FOREXSWAPS.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_plinfo_forexfwd_l";
        }
        if (ProductTypeEnum.FOREXOPTION.getId().equals(plBill.getString("tradetype"))) {
            if (plInfoCount > 1) {
                return "tbo_plinfo_forexfwd_l";
            }
            return "tbo_plinfo_forexoption_l";
        }
        if (ProductTypeEnum.STRUCTDEPOSIT.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_pl_structdeposit_l";
        }
        if (ProductTypeEnum.SWAP.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_plinfo_swap_l";
        }
        if (ProductTypeEnum.FORWRATEAGREE.getId().equals(plBill.getString("tradetype"))) {
            return "tbo_plinfo_swap_l";
        }
        return "tbo_plinfo";
    }

    private boolean validatePlPermission(DynamicObjectCollection plInfos) {
        if (plInfos.stream().map(o -> o.get("org")).distinct().count() > 1L) {
            List<Long> allPermOrgIds = this.getAllPermOrgIds("tm", "tbo_plinfo");
            if (allPermOrgIds != null) {
                for (DynamicObject plInfo : plInfos) {
                    if (!EmptyUtil.isNoEmpty((Object)plInfo.get("org")) || allPermOrgIds.contains(plInfo.getLong("org"))) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u7ec4\u7ec7\u635f\u76ca\u4fe1\u606f\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"TradeList_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return false;
                }
            }
        } else if (plInfos.size() > 1) {
            if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)((DynamicObject)plInfos.get(0)).getLong("org"), (String)"tm", (String)"tbo_plinfo", (String)"47150e89000000ac") == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u7ec4\u7ec7\u635f\u76ca\u4fe1\u606f\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"TradeList_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (Long)((DynamicObject)plInfos.get(0)).getLong("org"), (String)"tm", (String)"tbo_plinfo", (String)"47150e89000000ac") == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u8be5\u7ec4\u7ec7\u635f\u76ca\u4fe1\u606f\u7684\u201c\u67e5\u770b\u201d\u6743\u9650\u3002", (String)"TradeList_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getAllPermOrgIds(String appId, String entityNum) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)OrgViewTypeEnum.IS_BANKROLL.getViewType(), (String)appId, (String)entityNum, (String)"47150e89000000ac");
        return result.hasAllOrgPerm() ? null : result.getHasPermOrgs();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("billFormId") && "tm_trade_l".equals(this.getView().getFormShowParameter().getCustomParam("billFormId"))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"tblnew", "tbldel", "tblsubmit", "tblcheck", "bar_tradecfg", "uploadattach", "bar_trace", "bar_viewflow", "tblprint", "baritemap"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operate = op.getOperateKey();
        if ("submit".equals(operate)) {
            List selectedIdList = this.getSelectedIdList();
            QFilter filter = new QFilter("id", "in", (Object)selectedIdList);
            DynamicObjectCollection trades = QueryServiceHelper.query((String)"tm_trade", (String)"composeaudit", (QFilter[])filter.toArray());
            boolean composeaudit = trades.stream().allMatch(e -> e.getBoolean("composeaudit"));
            boolean nocomposeaudit = trades.stream().noneMatch(e -> e.getBoolean("composeaudit"));
            if (composeaudit) {
                FormOperate source = (FormOperate)args.getSource();
                source.getOption().setVariableValue("WF", "TRUE");
            } else if (!nocomposeaudit) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5ba1\u6279\u548c\u975e\u7ec4\u5408\u5ba1\u6279\u4e0d\u80fd\u4e00\u8d77\u63d0\u4ea4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"TradeList_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        FormShowParameter param;
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key) && (param = this.getView().getFormShowParameter()).getCustomParams().containsKey(PARAM_KEY_IS_OPTIONCOMBTRADE)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            Object[] idList = new Object[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                idList[i] = selectedRows.get(i).getPrimaryKeyValue();
            }
            QFilter idQF = new QFilter("id", "in", (Object)idList);
            DynamicObjectCollection options = QueryServiceHelper.query((String)"tm_forex_options", (String)"adjexpiredate", (QFilter[])new QFilter[]{idQF}, null);
            if (options != null && options.size() > 0) {
                Date opDate = ((DynamicObject)options.get(0)).getDate("adjexpiredate");
                opDate = DateUtils.truncateDate((Date)opDate);
                for (int i = 1; i < options.size(); ++i) {
                    Date nextDate = ((DynamicObject)options.get(i)).getDate("adjexpiredate");
                    if (opDate != null && opDate.equals(DateUtils.truncateDate((Date)nextDate))) continue;
                    this.getView().showErrorNotification(TeBizResource.noOptionStruct());
                    evt.setCancel(true);
                    return;
                }
            }
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param.getCustomParams().containsKey(PARAM_KEY_IS_OPTIONCOMBTRADE) || param.getCustomParams().containsKey(PARAM_KEY_IS_COMBTRADE)) {
            for (IListColumn col : args.getListColumns()) {
                col.setHyperlink(false);
            }
        }
    }

    protected boolean disableDoubleClick() {
        FormShowParameter param = this.getView().getFormShowParameter();
        return param.getCustomParams().containsKey(PARAM_KEY_IS_OPTIONCOMBTRADE) || param.getCustomParams().containsKey(PARAM_KEY_IS_COMBTRADE);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter filter = new QFilter("bill", "=", (Object)this.getBillFormId());
        DynamicObject tradeset = QueryServiceHelper.queryOne((String)"tbd_tradeset", (String)"tradetype", (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((DynamicObject)tradeset)) {
            this.getPageCache().put("protecttype", tradeset.getString("tradetype"));
            QFilter fi = new QFilter("protecttype.id", "=", tradeset.get("tradetype"));
            e.getCustomQFilters().add(fi);
        }
    }
}

