/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.trade;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.formplugin.trade.TradeTreeList;

public class TradeTreeF7List
extends TradeTreeList {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void setFilter(SetFilterEvent e) {
        boolean isCombTrade;
        boolean isUnique;
        Object filter;
        List ids;
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param.getCustomParams().containsKey("noFilterIds") && EmptyUtil.isNoEmpty((Object)(ids = (List)param.getCustomParam("noFilterIds"))) && ids.size() > 0) {
            filter = new QFilter("id", "not in", (Object)ids);
            e.addCustomQFilter(filter);
        }
        if (param.getCustomParams().containsKey("isUnique") && (isUnique = ((Boolean)param.getCustomParam("isUnique")).booleanValue())) {
            filter = new QFilter("portfolio", "=", (Object)0);
            e.addCustomQFilter(filter);
        }
        if (param.getCustomParams().containsKey("isLowRisk")) {
            BillList billList = (BillList)this.getControl("billlistap");
            filter = billList.getEntryEntity();
        }
        if (param.getCustomParams().containsKey("isCombTrade") && (isCombTrade = ((Boolean)param.getCustomParam("isCombTrade")).booleanValue())) {
            List filterBillType = (List)param.getCustomParam("filterBillType");
            QFilter filter2 = new QFilter("protecttype.id", "in", (Object)filterBillType);
            e.getQFilters().add(filter2);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            this.okData();
        }
    }

    private void okData() {
        QFilter filter = new QFilter("1", "=", (Object)1);
        Map setColl = TmcDataServiceHelper.loadFromCache((String)"tbd_tradeset", (QFilter[])filter.toArray());
        HashMap<Long, String> protecttype_entity = new HashMap<Long, String>(16);
        for (DynamicObject object : setColl.values()) {
            String entity = object.getDynamicObject("bill").get("number").toString();
            if (entity.endsWith("_l")) {
                entity = entity.substring(0, entity.length() - 2);
            }
            protecttype_entity.put(object.getDynamicObject("tradetype").getLong("id"), entity);
        }
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        Object[] idList = new Object[selectedRows.size()];
        for (int i = 0; i < selectedRows.size(); ++i) {
            idList[i] = selectedRows.get(i).getPrimaryKeyValue();
        }
        QFilter idQF = new QFilter("id", "in", (Object)idList);
        HashMap selectedMap = new HashMap(16);
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"tm_trade", (String)"id,protecttype", (QFilter[])new QFilter[]{idQF});
        for (DynamicObject bill : bills) {
            selectedMap.put(bill.getString("id"), protecttype_entity.get(bill.getLong("protecttype")));
        }
        bills = QueryServiceHelper.query((String)"mrm_rateopen", (String)"id", (QFilter[])new QFilter[]{idQF});
        for (DynamicObject bill : bills) {
            selectedMap.put(bill.getString("id"), "mrm_rateopen");
        }
        bills = QueryServiceHelper.query((String)"mrm_exrateopen", (String)"id", (QFilter[])new QFilter[]{idQF});
        for (DynamicObject bill : bills) {
            selectedMap.put(bill.getString("id"), "mrm_exrateopen");
        }
        this.getView().returnDataToParent(selectedMap);
        this.getModel().setDataChanged(false);
    }

    @Override
    protected QFilter getFilter() {
        QFilter filter = new QFilter("enable", "=", (Object)true);
        filter.and(new QFilter("longnumber", "!=", (Object)"BONDISSUE")).and(new QFilter("longnumber", "!=", (Object)"trade"));
        FormShowParameter param = this.getView().getFormShowParameter();
        if (param.getCustomParams().containsKey("NeedBillType")) {
            String needBillType = (String)param.getCustomParams().get("NeedBillType");
            String[] needList = needBillType.split(",");
            QFilter filter_need = new QFilter("longnumber", "like", (Object)("%" + needList[0]));
            for (int i = 1; i < needList.length; ++i) {
                filter_need.or(new QFilter("longnumber", "like", (Object)("%" + needList[i])));
            }
            filter.and(filter_need);
        }
        return filter;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        BillList billList = (BillList)this.getControl("billlistap");
        billList.changeBillFormId("tm_trade_f7");
        this.getView().updateView("billlistap");
        super.filterContainerSearchClick(args);
    }
}

