/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.opservice.plprovision;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.enums.PlProvisionTypeEnum;
import kd.tmc.tbo.common.enums.WriteOffStatusEnum;

public class PlProvisionWriteOffService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("billstatus");
        sic.add("org");
        sic.add("plcurrencyfloatplamt");
        sic.add("localcurrencyfloatplamt");
        sic.add("plinfo");
        sic.add("tradebill");
        sic.add("tradetype");
        sic.add("tradetypes");
        sic.add("type");
        sic.add("provisiondate");
        sic.add("plcurrency");
        sic.add("localcurrency");
        sic.add("plprovisioncurrency");
        sic.add("totalprovisionamt");
        sic.add("writeoffamt");
        sic.add("writeoffstatus");
        sic.add("writeoffbill");
        sic.add("sourcebill");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        DynamicObject[] writeOffBills = new DynamicObject[dataEntities.length];
        long[] ids = DB.genGlobalLongIds((int)dataEntities.length);
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject plProvisionBill = dataEntities[i];
            plProvisionBill.set("writeoffamt", plProvisionBill.get("totalprovisionamt"));
            plProvisionBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITTENOFF.getValue());
            DynamicObject writeOffBill = BusinessDataServiceHelper.newDynamicObject((String)"tbo_pl_provision");
            DynamicObject org = plProvisionBill.getDynamicObject("org");
            String orgId = org.getString("id");
            String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_pl_provision", (DynamicObject)plProvisionBill, (String)orgId);
            if (EmptyUtil.isEmpty((String)billNo)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u6b63\u786e\u8bbe\u7f6e\u635f\u76ca\u8ba1\u63d0\u5355\u636e\u7f16\u53f7\u89c4\u5219\u3002", (String)"PlProvisionWriteOffService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            writeOffBill.set("billno", (Object)billNo);
            writeOffBill.set("id", (Object)ids[i]);
            writeOffBill.set("type", (Object)PlProvisionTypeEnum.WRITEOFF.getValue());
            writeOffBill.set("writeoffstatus", (Object)WriteOffStatusEnum.WRITTENOFF.getValue());
            writeOffBill.set("provisiondate", plProvisionBill.get("provisiondate"));
            writeOffBill.set("billstatus", (Object)BillStatusEnum.AUDIT.getValue());
            writeOffBill.set("createtime", (Object)new Date());
            writeOffBill.set("creator", (Object)RequestContext.get().getCurrUserId());
            writeOffBill.set("org", plProvisionBill.get("org"));
            writeOffBill.set("plcurrency", plProvisionBill.get("plcurrency"));
            writeOffBill.set("localcurrency", plProvisionBill.get("localcurrency"));
            writeOffBill.set("plprovisioncurrency", plProvisionBill.get("plprovisioncurrency"));
            writeOffBill.set("tradetypes", plProvisionBill.get("tradetypes"));
            writeOffBill.set("totalprovisionamt", plProvisionBill.get("totalprovisionamt"));
            writeOffBill.set("writeoffamt", plProvisionBill.get("writeoffamt"));
            writeOffBill.set("writeoffstatus", plProvisionBill.get("writeoffstatus"));
            for (DynamicObject item : writeOffBill.getDynamicObjectCollection("tradetypes")) {
                item.set("pkid", null);
                item.set("fbasedataid", item.getDynamicObject("fbasedataid").getPkValue());
            }
            plProvisionBill.set("writeoffbill", (Object)ids[i]);
            writeOffBill.set("sourcebill", plProvisionBill.getPkValue());
            DynamicObjectCollection entryEntity = writeOffBill.getDynamicObjectCollection("entryentity");
            for (DynamicObject sourceRow : plProvisionBill.getDynamicObjectCollection("entryentity")) {
                DynamicObject entryRow = entryEntity.addNew();
                entryRow.set("plinfo", sourceRow.get("plinfo"));
                entryRow.set("tradebill", sourceRow.get("tradebill"));
                entryRow.set("tradetype", sourceRow.get("tradetype"));
                entryRow.set("plcurrencyfloatplamt", sourceRow.get("plcurrencyfloatplamt"));
                entryRow.set("localcurrencyfloatplamt", sourceRow.get("localcurrencyfloatplamt"));
            }
            writeOffBills[i] = writeOffBill;
        }
        SaveServiceHelper.save((DynamicObject[])writeOffBills);
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }
}

