/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.business.opservice.pnl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.helper.PlInfoCalculateHelper;

public class PlInfoSaveService
extends AbstractTmcBizOppService {
    public static final String SETTLE_CURRENCY = "settlecurrency";

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("org");
        sic.add("tradetype");
        sic.add("tradebill");
        sic.add("forexquote");
        sic.add("fxquote");
        sic.add("plcurrency");
        sic.add("plcurrency_s");
        sic.add("referexrate");
        sic.add("updatedate");
        sic.add("floatplamt");
        sic.add("exrate_local");
        sic.add("floatpllocalamt");
        sic.add("localcurrency");
        sic.add("fxquote_local");
        sic.add("srcbizbill");
        sic.add("bizrecord");
        sic.add("swapdir");
        sic.add("fxquotetype");
        sic.add("payfloatplamt");
        sic.add("recfloatplamt");
        sic.add("spotrate");
        sic.add("type");
        sic.add("floatplamt_in");
        sic.add("floatpllocalamt_in");
        sic.add("lastenterdate");
        sic.add("bizdate");
        sic.add("settledate");
        sic.add("biztype");
        sic.add("plamt");
        sic.add("pllocalamt");
        sic.add("bizbillid");
        sic.add("bizbillno");
        sic.add("bizop");
        sic.add("floatplamtcalcdate");
        sic.add("lastobsdate");
        sic.add("payyields");
        sic.add("recyields");
        sic.add("referpremium");
        sic.add("yieldcurve");
        sic.add("billno");
        sic.add("billstatus");
        sic.add("pllocalamt_sum");
        sic.add("forreferexrate");
        sic.add("forfloatplamt");
        sic.add("plcalcmethod");
        sic.add("issuedate");
        sic.add("buycurrency");
        sic.add("sellcurrency");
        sic.add("standardcurrency");
        sic.add("buyamount");
        sic.add("sellamount");
        sic.add("amount");
        sic.add("exrate");
        sic.add("buy_local_fq");
        sic.add("buy_local_exrate");
        sic.add("sell_local_fq");
        sic.add("sell_local_exrate");
        sic.add("bizrestamt");
        sic.add("voucher_pl");
        sic.add("bizbillamt");
        sic.add("bizbillvoucherpl");
        sic.add("forwrate");
        sic.add("currencyrate");
        sic.add("pricecurrencyrate");
        sic.add("volatility");
        sic.add("optiontype");
        sic.add("premiumcurrency");
        sic.add("premium");
        sic.add("swaptype");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> plHistoryInfoList = new ArrayList<DynamicObject>();
        for (DynamicObject info : dataEntities) {
            long historyPlInfoId;
            List plHistoryID_maxDate;
            DynamicObject plHistoryInfo;
            DeleteServiceHelper.delete((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", info.get("id")).and("updatedate", "=", info.get("updatedate")).toArray());
            DynamicObject tradeType = info.getDynamicObject("tradetype");
            String number = tradeType.getString("number");
            if ((ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number) || ProductTypeEnum.FOREXOPTION.getValue().equals(number)) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{info.get("forexquote"), info.get("updatedate"), info.get("referexrate")})) {
                this.clearUselessColumns(info, number);
                plHistoryInfo = PlInfoCalculateHelper.buildPlHistory((DynamicObject)info);
                plHistoryInfoList.add(plHistoryInfo);
                plHistoryID_maxDate = QueryServiceHelper.queryPrimaryKeys((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", info.getPkValue()).and("updatedate", ">", info.get("updatedate")).toArray(), (String)"updatedate desc", (int)1);
                if (EmptyUtil.isNoEmpty((Object)plHistoryID_maxDate)) {
                    info.set("maxhistoryplinfo", plHistoryID_maxDate.get(0));
                } else {
                    historyPlInfoId = DBServiceHelper.genGlobalLongId();
                    info.set("maxhistoryplinfo", (Object)historyPlInfoId);
                    plHistoryInfo.set("id", (Object)historyPlInfoId);
                }
            }
            if (ProductTypeEnum.SWAP.getValue().equals(number)) {
                DynamicObject tradebill = info.getDynamicObject("tradebill");
                if (tradebill == null) continue;
                QFilter qFilter = new QFilter("id", "=", tradebill.getPkValue());
                DynamicObject bill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"rateswaptype,billstatus,isbuysettle", (QFilter[])qFilter.toArray());
                boolean isbuysettle = bill.getBoolean("isbuysettle");
                String billstatus = bill.getString("billstatus");
                String rateswaptype = bill.getString("rateswaptype");
                if ("currency".equals(rateswaptype) && TcBillStatusEnum.AUDIT.getValue().equals(billstatus) && isbuysettle) continue;
                DynamicObject plHistoryInfo2 = PlInfoCalculateHelper.buildPlHistory((DynamicObject)info);
                plHistoryInfoList.add(plHistoryInfo2);
                List plHistoryID_maxDate2 = QueryServiceHelper.queryPrimaryKeys((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", info.getPkValue()).and("updatedate", ">", info.get("updatedate")).toArray(), (String)"updatedate desc", (int)1);
                if (EmptyUtil.isNoEmpty((Object)plHistoryID_maxDate2)) {
                    info.set("maxhistoryplinfo", plHistoryID_maxDate2.get(0));
                    continue;
                }
                long historyPlInfoId2 = DBServiceHelper.genGlobalLongId();
                info.set("maxhistoryplinfo", (Object)historyPlInfoId2);
                plHistoryInfo2.set("id", (Object)historyPlInfoId2);
                continue;
            }
            if (!ProductTypeEnum.FORWRATEAGREE.getValue().equals(number)) continue;
            this.clearUselessColumns(info, number);
            plHistoryInfo = PlInfoCalculateHelper.buildPlHistory((DynamicObject)info);
            plHistoryInfoList.add(plHistoryInfo);
            plHistoryID_maxDate = QueryServiceHelper.queryPrimaryKeys((String)"tbo_plinfo_history", (QFilter[])new QFilter("plbill", "=", info.getPkValue()).and("updatedate", ">", info.get("updatedate")).toArray(), (String)"updatedate desc", (int)1);
            if (EmptyUtil.isNoEmpty((Object)plHistoryID_maxDate)) {
                info.set("maxhistoryplinfo", plHistoryID_maxDate.get(0));
                continue;
            }
            historyPlInfoId = DBServiceHelper.genGlobalLongId();
            info.set("maxhistoryplinfo", (Object)historyPlInfoId);
            plHistoryInfo.set("id", (Object)historyPlInfoId);
        }
        if (!plHistoryInfoList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])plHistoryInfoList.toArray(new DynamicObject[0]));
        }
    }

    private void clearUselessColumns(DynamicObject info, String number) {
        DynamicObject plCurrency;
        DynamicObject localCurrency = info.getDynamicObject("localcurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{localCurrency, plCurrency = info.getDynamicObject("plcurrency")}) && localCurrency.getPkValue().equals(plCurrency.getPkValue())) {
            info.set("floatpllocalamt", (Object)BigDecimal.ZERO);
        }
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number) && PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(info.get("plcalcmethod"))) {
            info.set("voucher_pl", (Object)BigDecimal.ZERO);
        }
    }
}

