/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.attachment;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.attachment.IAttachmentOperateService;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class AttachmentUploadService
extends AbstractTmcBizOppService {
    private static Log logger = LogFactory.getLog(AttachmentUploadService.class);

    public void process(DynamicObject[] dataEntities) throws KDException {
        String attachmentPanelStr = (String)this.getOperationVariable().get("AttachmentPanel");
        if (EmptyUtil.isNoEmpty((String)attachmentPanelStr)) {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    OperateOption option = OperateOption.create();
                    option.setVariableValue("AttachmentPanel", attachmentPanelStr);
                    IAttachmentOperateService attService = (IAttachmentOperateService)ServiceFactory.getService(IAttachmentOperateService.class);
                    attService.persistAttachments(option, dataEntities);
                    this.getOperationVariable().remove("AttachmentPanel");
                }
                catch (Exception e) {
                    logger.error(String.format("\u9644\u4ef6\u4e0a\u4f20\u5f02\u5e38\uff0c\u3010%s\u3011", e.getMessage()));
                    tx.markRollback();
                    throw e;
                }
            }
            String entityNum = dataEntities[0].getDataEntityType().getName();
            MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityNum);
            if (dt.getProperty("isupattch") == null) {
                return;
            }
            List upattBillIds = Arrays.stream(dataEntities).map(v -> v.getLong("id")).collect(Collectors.toList());
            QFilter qf = new QFilter("id", "in", upattBillIds);
            qf.and(new QFilter("isupattch", "=", (Object)Boolean.FALSE));
            Object[] updateBills = TmcDataServiceHelper.load((String)entityNum, (String)"isupattch", (QFilter[])qf.toArray());
            if (!EmptyUtil.isEmpty((Object[])updateBills)) {
                for (Object bill : updateBills) {
                    bill.set("isupattch", (Object)"1");
                }
                SaveServiceHelper.update((DynamicObject[])updateBills);
            }
        }
    }
}

