/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import kd.tmc.tm.common.helper.PlHelper;

public class BizUpdatePlCfgService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billstatus");
        sic.add("isplconfirm");
        sic.add("execexrate");
        sic.add("plamt");
        sic.add("settleamount");
        sic.add("baseexrate");
        sic.add("baseplamt");
        sic.add("tradebill");
        sic.add("tradebill.protecttype");
        sic.add("tradebill.pricerule");
        sic.add("tradebill.deliveryway");
        sic.add("tradebill.pair");
        sic.add("tradebill.fxquote");
        sic.add("tradebill.tradedirect");
        sic.add("tradebill.currency");
        sic.add("tradebill.sellcurrency");
        sic.add("tradebill.adjustsettledate");
        sic.add("tradebill.tradetype");
        sic.add("tradebill.exchangerate");
        sic.add("tradebill.settlecurrency");
        sic.add("tradebill.premiumcurrency");
        sic.add("tradebill.premium");
        sic.add("tradebill.amount");
        sic.add("tradebill.reccurrency");
        sic.add("tradebill.rateswaptype");
        sic.add("tradebill.settledate");
        sic.add("bizrecordid");
        sic.add("operate");
        sic.add("bizdate");
        sic.add("basecurrency");
        sic.add("plcurrency");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("exratecalmtd");
        sic.add("deliverydate");
        sic.add("spotrate_dey");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("fxquotetype");
        sic.add("settlecurrency");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> needUpdate = new ArrayList<DynamicObject>(dataEntities.length);
        block15: for (DynamicObject bill : dataEntities) {
            String entityType;
            if (!PlHelper.isEnableCommonForPlConfirm((DynamicObject)bill).booleanValue()) continue;
            needUpdate.add(bill);
            DynamicObject productType = bill.getDynamicObject("tradebill").getDynamicObject("protecttype");
            switch (entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity()) {
                case "tm_forex": {
                    this.updateForex(bill);
                    continue block15;
                }
                case "tm_forex_forward": 
                case "tm_forex_swaps": {
                    this.updateForexFwd(bill);
                    continue block15;
                }
                case "tm_forex_options": {
                    this.updateForexOption(bill);
                    continue block15;
                }
                case "tm_structdeposit": {
                    this.updateStructDeposit(bill);
                    continue block15;
                }
                case "tm_rateswap": {
                    this.updateRateSwap(bill);
                }
            }
        }
        if (needUpdate.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needUpdate.toArray(new DynamicObject[0]));
        }
    }

    protected void updateForex(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case flat: {
                Boolean enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                if (enable.booleanValue()) {
                    BigDecimal exRate = this.getExRate(tradeBill, bizdate, tradeBill.getDate("settledate"), Boolean.TRUE);
                    Long bizRecordId = bill.getLong("bizrecordid");
                    DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"exrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizRecordId)});
                    BigDecimal plAmt = PlHelper.calPlAmtWithPlCurrency((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)exRate, (BigDecimal)bizRecord.getBigDecimal("exrate"));
                    bill.set("execexrate", (Object)exRate);
                    bill.set("plamt", (Object)plAmt);
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                DynamicObject plInfo = PlHelper.getPlInfoForPlConfirm((DynamicObject)bill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
            }
        }
    }

    protected void updateForexFwd(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        String deliveryWay = tradeBill.getString("deliveryway");
        String exrateCalMtd = bill.getString("exratecalmtd");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case expiredey: 
            case expiredey_f: 
            case expiredey_n: {
                Boolean enable = DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) ? Boolean.valueOf(TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) : Boolean.TRUE;
                if (enable.booleanValue()) {
                    BigDecimal exRate = this.getExRate(tradeBill, bizdate, null, BusinessBillHelper.isSwapFar((String)op));
                    Long bizRecordId = bill.getLong("bizrecordid");
                    DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"exrate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizRecordId)});
                    BigDecimal plAmt = PlHelper.calPlAmtWithPlCurrency((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)exRate, (BigDecimal)bizRecord.getBigDecimal("exrate"));
                    if (BusinessBillHelper.isSwapFar((String)op).booleanValue()) {
                        plAmt = plAmt.negate();
                    }
                    bill.set("execexrate", (Object)exRate);
                    bill.set("plamt", (Object)plAmt);
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
                break;
            }
            case flat: 
            case flat_n: 
            case flat_f: {
                Boolean enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                if (enable.booleanValue()) {
                    Long bizRecordId = bill.getLong("bizrecordid");
                    DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"exrate,bizdate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizRecordId)});
                    Date Dm = bizRecord.getDate("enddate");
                    if (EmptyUtil.isEmpty((Object)Dm)) {
                        Dm = bizRecord.getDate("bizdate");
                    }
                    BigDecimal exRate = this.getExRate(tradeBill, bizdate, Dm, BusinessBillHelper.isSwapFar((String)op) == false);
                    BigDecimal plAmt = PlHelper.calAmt_PL((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)exRate, (BigDecimal)bizRecord.getBigDecimal("exrate"));
                    plAmt = PlHelper.dealPlAmt_PlCurrencyNotSrc((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)plAmt);
                    if (BusinessBillHelper.isSwapFar((String)op).booleanValue()) {
                        plAmt = plAmt.negate();
                    }
                    bill.set("execexrate", (Object)exRate);
                    bill.set("plamt", (Object)plAmt);
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
                break;
            }
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                BigDecimal plAmt;
                BigDecimal exRate;
                if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
                    DynamicObject plCurrencySrc;
                    Date Dm = bill.getDate("deliverydate");
                    exRate = this.getExRate(tradeBill, bizdate, Dm, BusinessBillHelper.isSwapFar((String)op));
                    BigDecimal beforeExrate = bill.getBigDecimal("spotrate_dey");
                    plAmt = PlHelper.calAmt_PL((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)exRate, (BigDecimal)beforeExrate);
                    DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, plCurrencySrc = tradeBill.getDynamicObject("sellcurrency")}) && plCurrency.getLong("id") != plCurrencySrc.getLong("id")) {
                        plAmt = EmptyUtil.isEmpty((BigDecimal)exRate) ? BigDecimal.ZERO : (plCurrencySrc.getString("number").equals(tradeBill.getString("fxquote").split("/")[0]) ? plAmt.multiply(exRate) : plAmt.divide(exRate, 10, 4));
                    }
                    if (BusinessBillHelper.isSwapFar((String)op).booleanValue()) {
                        plAmt = plAmt.negate();
                    }
                    bill.set("execexrate", (Object)exRate);
                    bill.set("plamt", (Object)plAmt);
                }
                if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd) && TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    Long bizRecordId = bill.getLong("bizrecordid");
                    DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"exrate,bizdate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizRecordId)});
                    Date Dm = bizRecord.getDate("enddate");
                    if (EmptyUtil.isEmpty((Object)Dm)) {
                        Dm = bizRecord.getDate("bizdate");
                    }
                    exRate = this.getExRate(tradeBill, bizdate, Dm, BusinessBillHelper.isSwapFar((String)op) == false);
                    plAmt = PlHelper.calAmt_PL((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)exRate, (BigDecimal)bizRecord.getBigDecimal("exrate"));
                    plAmt = PlHelper.dealPlAmt_PlCurrencyNotSrc((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)plAmt);
                    if (BusinessBillHelper.isSwapFar((String)op).booleanValue()) {
                        plAmt = plAmt.negate();
                    }
                    bill.set("execexrate", (Object)exRate);
                    bill.set("plamt", (Object)plAmt);
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
                break;
            }
            case defer: 
            case maudate: 
            case defer_f: 
            case defer_n: 
            case maudate_f: 
            case maudate_n: {
                if (!ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) break;
                if (TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    Long bizRecordId = bill.getLong("bizrecordid");
                    DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"exrate,bizdate,enddate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bizRecordId)});
                    Date Dm = bizRecord.getDate("enddate");
                    if (EmptyUtil.isEmpty((Object)Dm)) {
                        Dm = bizRecord.getDate("bizdate");
                    }
                    BigDecimal exRate = this.getExRate(tradeBill, bizdate, Dm, BusinessBillHelper.isSwapFar((String)op) == false);
                    BigDecimal plAmt = PlHelper.calAmt_PL((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)exRate, (BigDecimal)bizRecord.getBigDecimal("exrate"));
                    plAmt = PlHelper.dealPlAmt_PlCurrencyNotSrc((DynamicObject)bill, (DynamicObject)tradeBill, (BigDecimal)plAmt);
                    if (BusinessBillHelper.isSwapFar((String)op).booleanValue()) {
                        plAmt = plAmt.negate();
                    }
                    bill.set("execexrate", (Object)exRate);
                    bill.set("plamt", (Object)plAmt);
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
            }
        }
    }

    protected void updateForexOption(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        Date bizdate = bill.getDate("bizdate");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case exercise: {
                Boolean enable = Boolean.TRUE;
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                    enable = TcBillStatusEnum.AUDIT.getValue().equals(billStatus);
                }
                if (enable.booleanValue()) {
                    BigDecimal exRate = this.getExRateOption(tradeBill, bizdate, bill.getDate("deliverydate"));
                    bill.set("execexrate", (Object)exRate);
                    BigDecimal settleAmt = BusinessBillHelper.calSettleAmount_ForexOptionForBusinessBill((DynamicObject)tradeBill, (DynamicObject)bill);
                    bill.set("settleamount", (Object)settleAmt);
                    Map result = PlHelper.calPlAmt_Ex_ForexOptionForBusinessBill((DynamicObject)tradeBill, (DynamicObject)bill);
                    for (Map.Entry e : result.entrySet()) {
                        bill.set((String)e.getKey(), e.getValue());
                    }
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
                break;
            }
            case giveup: {
                BigDecimal exRate = this.getExRateOption(tradeBill, bizdate, tradeBill.getDate("adjustsettledate"));
                Map result = PlHelper.calPlAmt_GiveUp_ForexOptionForBusinessBill((DynamicObject)tradeBill, (DynamicObject)bill);
                for (Map.Entry e : result.entrySet()) {
                    bill.set((String)e.getKey(), e.getValue());
                }
                bill.set("execexrate", (Object)exRate);
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
                break;
            }
            case flat: {
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
            }
        }
    }

    protected void updateStructDeposit(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case pay: {
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
            }
        }
    }

    protected void updateRateSwap(DynamicObject bill) {
        DynamicObject tradeBill = bill.getDynamicObject("tradebill");
        String billStatus = bill.getString("billstatus");
        String op = bill.getString("operate");
        BizOperateEnum opEnum = BizOperateEnum.valueOf((String)op);
        switch (opEnum) {
            case interestpay: 
            case capitalpay: {
                String swapType = tradeBill.getString("rateswaptype");
                if (SwapTypeEnum.rate.getValue().equals(swapType) && TcBillStatusEnum.AUDIT.getValue().equals(billStatus)) {
                    BigDecimal plAmt = PlHelper.calPlAmt_Rate_RateSwapForBusinessBill((DynamicObject)bill);
                    bill.set("plamt", (Object)plAmt);
                }
                if (SwapTypeEnum.currency.getValue().equals(swapType)) {
                    Boolean isPay = EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_pay"));
                    Boolean isRec = EmptyUtil.isNoEmpty((Long)bill.getLong("cashflow_rec"));
                    DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
                    if (!(plCurrency == null || isPay.booleanValue() && !isRec.booleanValue() && plCurrency.getLong("id") == tradeBill.getDynamicObject("currency").getLong("id") || !isPay.booleanValue() && isRec.booleanValue() && plCurrency.getLong("id") != tradeBill.getDynamicObject("currency").getLong("id"))) {
                        DynamicObject temp = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradeBill.getDynamicObject("pricerule").getLong("id"))});
                        Long fqId = temp.getLong("forexquote.id");
                        DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
                        DynamicObject recCurrency = tradeBill.getDynamicObject("reccurrency");
                        String pair = payCurrency.getString("number") + "/" + recCurrency.getString("number");
                        Date bizdate = bill.getDate("bizdate");
                        ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfoWithIssueTime((Long)fqId, (String)pair, (Date)bizdate, null);
                        String fxquote = fqInfo.getFxquote();
                        BigDecimal rate = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice();
                        bill.set("execexrate", (Object)rate);
                        BigDecimal plAmt = PlHelper.calPlAmt_Currency_RateSwapForBusinessBill((DynamicObject)bill);
                        bill.set("plamt", (Object)plAmt);
                    }
                }
                PlHelper.setBaseInfo_PlForBizUpdate((DynamicObject)bill, (DynamicObject)tradeBill);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{PlHelper.getPlInfoForPlConfirm((DynamicObject)bill)});
            }
        }
    }

    public ForexQuoteInfo getForexQuoteInfo(DynamicObject tradebill, Date issueTime, Date Dm) {
        DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
        Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
        String fxQuote = tradebill.getString("fxquote");
        return MarketDataServiceHelper.getForexQuoteInfoWithIssueTime((Long)fqId, (String)fxQuote, (Date)issueTime, (Date)Dm);
    }

    public BigDecimal getExRate(DynamicObject tradebill, Date issueTime, Date Dm, boolean isSameDirBuy) {
        ForexQuoteInfo info = this.getForexQuoteInfo(tradebill, issueTime, Dm);
        if (info == null) {
            return BigDecimal.ZERO;
        }
        String fxQuote = tradebill.getString("fxquote");
        String pair = tradebill.getString("pair");
        String dir = tradebill.getString("tradedirect");
        if (isSameDirBuy) {
            if (dir.equals(TradeDirectionEnum.buy.getValue()) && pair.equals(fxQuote) || dir.equals(TradeDirectionEnum.sell.getValue()) && !pair.equals(fxQuote)) {
                return info.getBuyPrice();
            }
            return info.getSellPrice();
        }
        if (dir.equals(TradeDirectionEnum.buy.getValue()) && pair.equals(fxQuote) || dir.equals(TradeDirectionEnum.sell.getValue()) && !pair.equals(fxQuote)) {
            return info.getSellPrice();
        }
        return info.getBuyPrice();
    }

    public BigDecimal getExRateOption(DynamicObject tradebill, Date issueTime, Date Dm) {
        ForexQuoteInfo info = this.getForexQuoteInfo(tradebill, issueTime, Dm);
        if (EmptyUtil.isEmpty((Object)info)) {
            return BigDecimal.ZERO;
        }
        String fxQuote = tradebill.getString("fxquote");
        String pair = tradebill.getString("pair");
        String dir = tradebill.getString("tradedirect");
        String tradeType = tradebill.getString("tradetype");
        BigDecimal sellPrice = BigDecimal.ZERO;
        BigDecimal buyPrice = BigDecimal.ZERO;
        if (info != null) {
            sellPrice = info.getSellPrice();
            buyPrice = info.getBuyPrice();
        }
        if (pair.equals(fxQuote)) {
            if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
                return sellPrice;
            }
            return buyPrice;
        }
        if (ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType)) {
            return sellPrice;
        }
        return buyPrice;
    }
}

