/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BusCreditOccUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("protecttype");
        sic.add("entrydetail");
        sic.add("operate");
        sic.add("bizamt1");
        return sic;
    }

    public void process(DynamicObject[] entities) throws KDException {
        for (DynamicObject entity : entities) {
            Long entityId;
            DynamicObject credituse;
            QFilter qFilter;
            if (!"tm_businessbill".equals(entity.getDataEntityType().getName())) continue;
            String tradebill = entity.getString("tradebill.number");
            String product = entity.getDynamicObject("protecttype").getString("number");
            String entityName = ProductTypeEnum.getEnumByValue((String)product).getEntity();
            DynamicObject bill = TmcDataServiceHelper.loadSingle((String)entityName, (String)"billno,credituse,currency,nearend,farend", (QFilter[])new QFilter[]{qFilter = new QFilter("billno", "=", (Object)tradebill)});
            if (!bill.getDataEntityType().getProperties().containsKey((Object)"credituse") || EmptyUtil.isEmpty((DynamicObject)(credituse = bill.getDynamicObject("credituse")))) continue;
            BigDecimal amt = entity.getBigDecimal("bizamt1");
            String operate = entity.getString("operate");
            if ("expiredey".equals(operate) || "bdelivery".equals(operate) || "flat".equals(operate) || "exercise".equals(operate) || "giveup".equals(operate)) {
                entityId = entity.getLong("id");
                CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)entity, (DynamicObject)bill, (boolean)false, (BigDecimal)amt, (Long)entityId);
                continue;
            }
            if ("expiredey_n".equals(operate) || "flat_n".equals(operate) || "bdelivery_n".equals(operate)) {
                if (!bill.getBoolean("nearend")) continue;
                entityId = entity.getLong("id");
                CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)entity, (DynamicObject)bill, (boolean)false, (BigDecimal)amt, (Long)entityId);
                continue;
            }
            if (!"expiredey_f".equals(operate) && !"flat_f".equals(operate) && !"bdelivery_f".equals(operate) || !bill.getBoolean("farend")) continue;
            entityId = entity.getLong("id");
            CreditLimitServiceHelper.cancelReturnCreditLimit((DynamicObject)entity, (DynamicObject)bill, (boolean)false, (BigDecimal)amt, (Long)entityId);
        }
    }
}

