/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.BizBillAuditServiceFactory;
import kd.tmc.tm.business.service.bizbill.IBizBillAuditService;
import kd.tmc.tm.business.service.bizbill.forex.ForexLifecycleService;

public class BusinessAuditService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BusinessAuditService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("tradebill");
        sic.add("operate");
        sic.add("org");
        sic.add("billstatus");
        sic.add("structtype");
        sic.add("settledate_dey");
        sic.add("referrate");
        sic.add("buynalprincipal");
        sic.add("sellnalprincipal");
        sic.add("settleamount_er");
        sic.add("spotrate_c");
        sic.add("settleamount_er");
        sic.add("srcbillid");
        sic.add("ratefixdate");
        sic.add("cfgrate");
        sic.add("settledate_s");
        sic.add("isrollsettle");
        sic.add("redeemdate");
        sic.add("deliveryway");
        sic.add("execrate");
        sic.add("execexrate");
        sic.add("settlecurrency");
        sic.add("settleamount");
        sic.add("optdate");
        sic.add("cfcurrency");
        sic.add("cfamount");
        sic.add("cfpayamount");
        sic.add("cfpaydate");
        sic.add("feedetail");
        sic.add("billno");
        sic.add("protecttype");
        sic.add("org");
        sic.add("fixeddate");
        sic.add("tradedirect");
        sic.add("restamt1");
        sic.add("restamt2");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("plsettledate");
        sic.add("plcurrency");
        sic.add("plamt");
        sic.add("baseplamt");
        sic.add("bizrecordid");
        sic.add("bizdate");
        sic.add("isdaterange");
        sic.add("deliverydate");
        sic.add("deydate_start");
        sic.add("deydate_end");
        sic.add("spotrate_dey");
        sic.add("exratecalmtd");
        sic.add("rate");
        sic.add("markprice");
        sic.add("redeemday");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("totalrate_pay");
        sic.add("totalrate_rec");
        sic.add("ratefixdate_pay");
        sic.add("ratefixdate_rec");
        sic.add("fixedrate_pay");
        sic.add("fixedrate_rec");
        sic.add("voucher_pl");
        sic.add("basecurrency");
        sic.add("expireddate");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            DynamicObject productType = bill.getDynamicObject("protecttype");
            String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            DynamicObject tradebill = bill.getDynamicObject("tradebill");
            tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)entityType);
            IBizBillAuditService tradeFactory = BizBillAuditServiceFactory.createTradeFactory(entityType);
            tradeFactory.auditBusinessBill(tradebill, bill);
            ForexLifecycleService.deal(tradebill, true);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        ArrayList<Object> forexSpotIds = new ArrayList<Object>(10);
        ArrayList<Object> forexForwardIds = new ArrayList<Object>(10);
        ArrayList<Object> forexSwapIds = new ArrayList<Object>(10);
        ArrayList<Object> forexOptionIds = new ArrayList<Object>(10);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject productType = dataEntity.getDynamicObject("protecttype");
            DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
            if (ProductTypeEnum.FOREXSPOT.getId().equals(productType.getString("id"))) {
                forexSpotIds.add(tradeBill.getPkValue());
            }
            if (ProductTypeEnum.FOREXFORWARD.getId().equals(productType.getString("id"))) {
                forexForwardIds.add(tradeBill.getPkValue());
            }
            if (ProductTypeEnum.FOREXSWAPS.getId().equals(productType.getString("id"))) {
                forexSwapIds.add(tradeBill.getPkValue());
            }
            if (!ProductTypeEnum.FOREXOPTION.getId().equals(productType.getString("id"))) continue;
            forexOptionIds.add(tradeBill.getPkValue());
        }
        if (!forexSpotIds.isEmpty()) {
            this.updateCashFlow("tm_forex", forexSpotIds);
        }
        if (!forexForwardIds.isEmpty()) {
            this.updateCashFlow("tm_forex_forward", forexForwardIds);
        }
        if (!forexSwapIds.isEmpty()) {
            this.updateCashFlow("tm_forex_swaps", forexSwapIds);
        }
        if (!forexOptionIds.isEmpty()) {
            this.updateCashFlow("tm_forex_options", forexOptionIds);
        }
    }

    private void updateCashFlow(String entityNumber, List<Object> forexSwapIds) {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isStrict", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"updatecf", (String)entityNumber, (Object[])forexSwapIds.toArray(), (OperateOption)operateOption);
        if (EmptyUtil.isNoEmpty((Object)result.getAllErrorInfo())) {
            logger.error("\u73b0\u91d1\u6d41\u66f4\u65b0\u5f02\u5e38\uff1a");
            for (OperateErrorInfo operateErrorInfo : result.getAllErrorInfo()) {
                logger.error(operateErrorInfo.getMessage());
            }
        }
    }
}

