/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.BizBillWriteBackPayHelper;
import org.apache.commons.lang3.tuple.Pair;

public class BusinessBillSubmitOpService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(BusinessBillSubmitOpService.class);

    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("plamt");
        sic.add("settleamount");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("plpayamt");
        sic.add("paybizamt1");
        sic.add("paybizamt2");
        sic.add("abssettleamt");
        sic.add("tradebill");
        sic.add("plcurrency");
        sic.add("settlecurrency");
        sic.add("paycurrency");
        sic.add("reccurrency");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            BigDecimal payAmt;
            String payAmtProp;
            List<Object> list;
            block8: {
                logger.info("\u751f\u547d\u5468\u671f\u64cd\u4f5c\u5355\u7f16\u7801={}", (Object)bill.getString("billno"));
                list = new ArrayList();
                try {
                    list = BizBillWriteBackPayHelper.getAmtAndCurrencyColName(bill, null);
                }
                catch (KDBizException e) {
                    if (e.getMessage().contains("Unknown entityType")) break block8;
                    throw e;
                }
            }
            if (list.size() == 1) {
                Pair AmtAndCurrencyColName = (Pair)list.get(0);
                String amtProp = (String)AmtAndCurrencyColName.getKey();
                String currencyProp = (String)AmtAndCurrencyColName.getValue();
                DynamicObject currency = this.getCurrency(bill, currencyProp);
                if (currency == null) continue;
                int amtPrecision = currency.getInt("amtprecision");
                payAmtProp = this.getProp(amtProp);
                payAmt = this.getAmt(amtProp, bill);
                payAmt = payAmt.setScale(amtPrecision, 4);
                logger.info("\u91d1\u989d\u6807\u8bc6={}, \u5e01\u79cd\u6807\u8bc6={}, \u91d1\u989d={}, \u5e01\u79cd={}, \u5e01\u79cd\u7cbe\u5ea6={}", new Object[]{amtProp, currencyProp, bill.getBigDecimal(amtProp), currency.getString("number"), amtPrecision});
                logger.info("\u9632\u8d85\u989d\u91d1\u989d\u6807\u8bc6={}, \u9632\u8d85\u989d\u91d1\u989d={}", new Object[]{payAmtProp, payAmt});
                bill.set(payAmtProp, (Object)payAmt);
                continue;
            }
            if (list.size() != 2) continue;
            Pair AmtAndCurrencyColName1 = (Pair)list.get(0);
            Pair AmtAndCurrencyColName2 = (Pair)list.get(1);
            if ("bizamt1".equals(AmtAndCurrencyColName1.getKey()) || "bizamt1".equals(AmtAndCurrencyColName2.getKey())) {
                payAmtProp = "paybizamt1";
            } else if ("bizamt2".equals(AmtAndCurrencyColName1.getKey()) || "bizamt2".equals(AmtAndCurrencyColName2.getKey())) {
                payAmtProp = "paybizamt2";
            } else {
                throw new KDBizException("get payAmtProp unExpected exception");
            }
            String amtProp1 = (String)AmtAndCurrencyColName1.getKey();
            String currencyProp1 = (String)AmtAndCurrencyColName1.getValue();
            BigDecimal amt1 = this.getAmt(amtProp1, bill);
            DynamicObject currency1 = this.getCurrency(bill, currencyProp1);
            if (currency1 == null) continue;
            int amtPrecision1 = currency1.getInt("amtprecision");
            amt1 = amt1.setScale(amtPrecision1, 4);
            logger.info("1.\u91d1\u989d\u6807\u8bc6={}, \u5e01\u79cd\u6807\u8bc6={}, \u91d1\u989d={}, \u4ed8\u6b3e\u91d1\u989d={}, \u5e01\u79cd={}, \u5e01\u79cd\u7cbe\u5ea6={}", new Object[]{amtProp1, currencyProp1, bill.getBigDecimal(amtProp1), amt1, currency1.getString("number"), amtPrecision1});
            String amtProp2 = (String)AmtAndCurrencyColName2.getKey();
            String currencyProp2 = (String)AmtAndCurrencyColName2.getValue();
            BigDecimal amt2 = this.getAmt(amtProp2, bill);
            DynamicObject currency2 = this.getCurrency(bill, currencyProp2);
            if (currency2 == null) continue;
            int amtPrecision2 = currency2.getInt("amtprecision");
            amt2 = amt2.setScale(amtPrecision2, 4);
            logger.info("2.\u91d1\u989d\u6807\u8bc6={}, \u5e01\u79cd\u6807\u8bc6={}, \u91d1\u989d={}, \u4ed8\u6b3e\u91d1\u989d={}, \u5e01\u79cd={}, \u5e01\u79cd\u7cbe\u5ea6={}", new Object[]{amtProp2, currencyProp2, bill.getBigDecimal(amtProp2), amt2, currency2.getString("number"), amtPrecision2});
            payAmt = amt1.add(amt2);
            logger.info("\u9632\u8d85\u989d\u91d1\u989d\u6807\u8bc6={}, \u9632\u8d85\u989d\u91d1\u989d={}", new Object[]{payAmtProp, payAmt});
            bill.set(payAmtProp, (Object)payAmt);
        }
    }

    private DynamicObject getCurrency(DynamicObject bill, String currencyProp) {
        DynamicObject currency = "currency".equals(currencyProp) || "sellcurrency".equals(currencyProp) ? bill.getDynamicObject("tradebill").getDynamicObject(currencyProp) : bill.getDynamicObject(currencyProp);
        if (currency == null) {
            logger.info("\u3010{}\u3011\u7684\u3010{}\u3011\u4e3a\u7a7a", new Object[]{bill.getString("billno"), currencyProp});
        }
        return currency;
    }

    private BigDecimal getAmt(String amtProp, DynamicObject bill) {
        BigDecimal payAmt = bill.getBigDecimal(amtProp);
        if (payAmt == null) {
            payAmt = BigDecimal.ZERO;
        }
        if ("plamt".equals(amtProp)) {
            return payAmt.compareTo(BigDecimal.ZERO) >= 0 ? BigDecimal.ZERO : payAmt.abs();
        }
        if ("settleamount".equals(amtProp)) {
            return payAmt.abs();
        }
        return payAmt;
    }

    private String getProp(String payAmtProp) {
        if ("bizamt1".equals(payAmtProp)) {
            return "paybizamt1";
        }
        if ("bizamt2".equals(payAmtProp)) {
            return "paybizamt2";
        }
        if ("plamt".equals(payAmtProp)) {
            return "plpayamt";
        }
        if ("settleamount".equals(payAmtProp)) {
            return "abssettleamt";
        }
        return null;
    }

    public void beforeCommit(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            Long sid = bill.getDynamicObject("tradebill").getLong("id");
            QFilter filter = new QFilter("billstatus", "<", (Object)TcBillStatusEnum.AUDIT.getValue()).and("tradebill", "=", (Object)sid).and("id", "!=", (Object)bill.getLong("id"));
            DynamicObjectCollection businessBillCol = QueryServiceHelper.query((String)"tm_businessbill", (String)"id", (QFilter[])filter.toArray());
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)businessBillCol)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"%s\u5b58\u5728\u672a\u5ba1\u6279\u7684\u4e1a\u52a1\u5904\u7406\u5355\u3002", (String)"TeBizResource_32", (String)"tmc-tm-common", (Object[])new Object[]{bill.getDynamicObject("tradebill").getString("number")}));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
    }
}

