/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.tm.business.service.bizbill.BizBillSettleServiceFactory;
import kd.tmc.tm.business.service.bizbill.IBizBillSettleService;

public class BusinessSettleService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("protecttype");
        sic.add("operate");
        sic.add("tradebill");
        sic.add("settleamount");
        sic.add("cashflow");
        sic.add("cfpayamount");
        sic.add("plamt");
        sic.add("exratecalmtd");
        sic.add("paybillno");
        sic.add("recbillno");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("exchangebillno");
        return sic;
    }

    public void beforeProcess(List<ExtendedDataEntity> dataEntities) throws KDException {
        if ("true".equals(this.getOperationVariable().get("DataChangedBeforeSettle"))) {
            DynamicObject[] bills = (DynamicObject[])dataEntities.stream().map(e -> e.getDataEntity()).toArray(DynamicObject[]::new);
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap<Long, DynamicObject> settlementSettingCache = new HashMap<Long, DynamicObject>(1);
        for (DynamicObject bill : dataEntities) {
            DynamicObject productType = bill.getDynamicObject("protecttype");
            String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            IBizBillSettleService service = BizBillSettleServiceFactory.getService(entityType);
            service.settle(bill, settlementSettingCache);
        }
        for (DynamicObject bill : dataEntities) {
            bill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_ING.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])dataEntities);
    }

    public void handlerException(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"tm_businessbill", (Long[])new Long[]{bill.getLong("id")});
            HashSet downBillType = new HashSet(botpMap.keySet());
            if (downBillType.contains("cas_paybill")) {
                this.deleteGeneratedBills("cas_paybill", botpMap);
            }
            if (downBillType.contains("cas_recbill")) {
                this.deleteGeneratedBills("cas_recbill", botpMap);
            }
            if (!downBillType.contains("cas_exchangebill")) continue;
            this.deleteGeneratedBills("cas_exchangebill", botpMap);
        }
    }

    private void deleteGeneratedBills(String downBillType, Map<String, HashSet<Long>> botpMap) {
        Object[] downbillIds = botpMap.entrySet().stream().filter(o -> downBillType.equals(o.getKey())).map(Map.Entry::getValue).flatMap(Collection::stream).toArray();
        if (downbillIds.length > 0) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("tmc_tm", "rollback");
            TmcOperateServiceHelper.execOperate((String)"delete", (String)downBillType, (Object[])downbillIds, (OperateOption)op, (boolean)true);
        }
    }
}

