/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.errorcode.TeErrorCode;

public class BusinessUnSettleService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("billno");
        sic.add("operate");
        sic.add("tradebill");
        sic.add("protecttype");
        sic.add("paybillno");
        sic.add("recbillno");
        sic.add("exchangebillno");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ErrorCode error_unsettle = new TeErrorCode().ERROR_UNSETTLE();
        for (DynamicObject bill : dataEntities) {
            DynamicObjectCollection payBills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill", (String)"billno,billstatus");
            DynamicObjectCollection recBills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_recbill", (String)"billno,billstatus");
            DynamicObjectCollection exChangeBills = TmcBotpHelper.queryTargetBills((String)"tm_businessbill", (Object)bill.getLong("id"), (String)"cas_exchangebill", (String)"billno,billstatus");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBills)) {
                for (DynamicObject payBill : payBills) {
                    if (StringUtils.equals((CharSequence)payBill.getString("billstatus"), (CharSequence)TcBillStatusEnum.SAVE.getValue())) continue;
                    throw new TmcBizException(error_unsettle);
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recBills)) {
                for (DynamicObject recBill : recBills) {
                    if (StringUtils.equals((CharSequence)recBill.getString("billstatus"), (CharSequence)TcBillStatusEnum.SAVE.getValue())) continue;
                    throw new TmcBizException(error_unsettle);
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)exChangeBills)) {
                for (DynamicObject exChangeBill : exChangeBills) {
                    String billStatus = exChangeBill.getString("billstatus");
                    if (StringUtils.equals((CharSequence)billStatus, (CharSequence)TcBillStatusEnum.SAVE.getValue())) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%1$s \u5173\u8054\u7684\u5916\u5e01\u5151\u6362\u5355 %2$s \u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u5355\u636e\u5220\u9664\u5931\u8d25\u3002", (String)"BusinessUnSettleService_1", (String)"tmc-tm-business", (Object[])new Object[0]), bill.get("billno"), exChangeBill.get("billno")));
                }
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)payBills)) {
                this.deleteTradeBill("cas_paybill", bill.getLong("id"));
                bill.set("paybillno", (Object)"");
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)recBills)) {
                this.deleteTradeBill("cas_recbill", bill.getLong("id"));
                bill.set("recbillno", (Object)"");
            }
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)exChangeBills)) {
                this.deleteTradeBill("cas_exchangebill", bill.getLong("id"));
                bill.set("exchangebillno", (Object)"");
            }
            bill.set("billstatus", (Object)TcBillStatusEnum.AUDIT.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
    }

    private void deleteTradeBill(String entityNumber, Long sid) {
        Object[] ids = TmcBotpHelper.getTargetBillIds((String)"tm_businessbill", (Object)sid, (String)entityNumber);
        if (ids != null && ids.length > 0) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("tmc_tm", "business_unsettle");
            TmcOperateServiceHelper.execOperate((String)"delete", (String)entityNumber, (Object[])ids, (OperateOption)op, (boolean)true);
        }
    }
}

