/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.business;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.business.service.bizbill.BizBillUnAuditServiceFactory;
import kd.tmc.tm.business.service.bizbill.IBizBillUnAuditService;
import kd.tmc.tm.business.service.bizbill.forex.ForexLifecycleService;

public class BusinessUnauditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("tradebill");
        sic.add("operate");
        sic.add("org");
        sic.add("billstatus");
        sic.add("settledate_dey");
        sic.add("isrollsettle");
        sic.add("srcbillid");
        sic.add("feedetail");
        sic.add("billno");
        sic.add("protecttype");
        sic.add("org");
        sic.add("counterparty");
        sic.add("feescheme");
        sic.add("feetype");
        sic.add("bizrecordid");
        sic.add("bizdate");
        sic.add("rate");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        sic.add("exratecalmtd");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            DynamicObject tradebill = bill.getDynamicObject("tradebill");
            DynamicObject productType = bill.getDynamicObject("protecttype");
            String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)entityType);
            IBizBillUnAuditService service = BizBillUnAuditServiceFactory.getService(entityType);
            service.unAudit(tradebill, bill);
            ForexLifecycleService.deal(tradebill, true);
        }
    }
}

