/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.cashflow;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.forex.ForexBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.forex.ForexSellCashFlowBuilder;
import kd.tmc.tm.business.service.builder.option.ForexOptionsBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.option.ForexOptionsSellCashFlowBuilder;
import kd.tmc.tm.business.service.builder.rate.ForwRateAgreeCashFlowBuiler;
import kd.tmc.tm.business.service.builder.rate.RateSwapsBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.rate.RateSwapsSellCashFlowBuilder;
import kd.tmc.tm.business.service.builder.structdeposit.StructDepositCashFlowBuilder;
import kd.tmc.tm.business.service.builder.swap.ForexSwapsBuyCashFlowBuilder;
import kd.tmc.tm.business.service.builder.swap.ForexSwapsSellCashFlowBuilder;
import kd.tmc.tm.common.enums.DeliveryWayEnum;

public class CashFlowBuildAndSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("referdate");
        selector.add("pricerule");
        selector.add("fxquote");
        selector.add("tradedirect");
        selector.add("pair");
        selector.add("settledate");
        selector.add("amount");
        selector.add("sellamount");
        selector.add("spotrate");
        selector.add("bizdate");
        selector.add("deliveryway");
        selector.add("sellcurrency");
        selector.add("settlecurrency");
        selector.add("isdaterange");
        selector.add("adjsettledate_end");
        selector.add("adjustsettledate");
        selector.add("buymarket");
        selector.add("sellmarket");
        selector.add("currency");
        selector.add("currency");
        selector.add("counterparty");
        selector.add("workcalendar");
        selector.add("settledelay");
        selector.add("buyamount_far");
        selector.add("forwrate");
        selector.add("adjustsettledate_far");
        selector.add("sellamount_far");
        selector.add("exchangerate");
        selector.add("tradetype");
        selector.add("currency");
        selector.add("sellcurrency");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet<Long> idSet = new HashSet<Long>(dataEntities.length);
        DynamicObjectCollection colls = new DynamicObjectCollection();
        for (DynamicObject bill : dataEntities) {
            if (this.isRateCfg_structDeposit(bill)) continue;
            DynamicObjectCollection cashFlows = this.builderCashFlow(bill, null);
            colls.addAll((Collection)cashFlows);
            idSet.add(bill.getLong("id"));
        }
        if (colls.size() > 0 && idSet.size() > 0) {
            QFilter filter = new QFilter("billid", "in", idSet);
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])filter.toArray());
        }
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])colls.toArray((Object[])new DynamicObject[colls.size()])));
    }

    private boolean isRateCfg_structDeposit(DynamicObject bill) {
        if (!"tm_structdeposit".equals(bill.getDynamicObjectType().getName())) {
            return false;
        }
        QFilter filter = new QFilter("billid", "=", bill.get("id"));
        Object[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)String.join((CharSequence)",", "billno", "entrys", "cfisratecfg"), (QFilter[])filter.toArray());
        if (EmptyUtil.isNoEmpty((Object[])cashFlows)) {
            for (Object cashFlow : cashFlows) {
                if (!"2".equals(cashFlow.get("billno"))) continue;
                return ((DynamicObject)((DynamicObjectCollection)cashFlow.get("entrys")).get(0)).getBoolean("cfisratecfg");
            }
        }
        return false;
    }

    public DynamicObjectCollection builderCashFlow(DynamicObject tradeBill, Map<String, String> paramMap) {
        DynamicObjectCollection colls = new DynamicObjectCollection();
        tradeBill.set("referdate", (Object)TcDateUtils.getCurrentDate());
        ICashFlowBuilder[] builders = this.getCashFlowBuilder(tradeBill);
        HashMap<Long, DynamicObject> id2seqMap = new HashMap<Long, DynamicObject>();
        ModelAgent modelAgent = new ModelAgent((Object)tradeBill);
        if (paramMap != null) {
            modelAgent.setParam(paramMap);
        }
        for (ICashFlowBuilder builder : builders) {
            List<Map<String, Object>> dataMap = builder.build(null, modelAgent);
            id2seqMap.clear();
            for (Map<String, Object> data : dataMap) {
                if (EmptyUtil.isEmpty((Object)data.get("id"))) {
                    data.put("id", DBServiceHelper.genGlobalLongId());
                }
                DynamicObject cashFlow = null;
                Object key = data.get("pid");
                cashFlow = key != null ? (DynamicObject)id2seqMap.get(key) : (DynamicObject)id2seqMap.get(data.get("id"));
                if (EmptyUtil.isEmpty((DynamicObject)cashFlow)) {
                    cashFlow = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
                    cashFlow.set("id", (Object)((Long)data.get("id")));
                    id2seqMap.put((Long)data.get("id"), cashFlow);
                    colls.add((Object)cashFlow);
                }
                DynamicObject info = cashFlow;
                if (data.containsKey("pid")) {
                    info = cashFlow.getDynamicObjectCollection("entrys").addNew();
                }
                Set<Map.Entry<String, Object>> entries = data.entrySet();
                for (Map.Entry<String, Object> map : entries) {
                    if (!info.getDataEntityType().getProperties().containsKey((Object)map.getKey())) continue;
                    info.set(map.getKey(), map.getValue());
                }
                if (data.containsKey("pid")) continue;
                cashFlow.set("billid", (Object)tradeBill.getLong("id"));
                cashFlow.set("billnumber", (Object)tradeBill.getString("billno"));
                cashFlow.set("org", (Object)tradeBill.getDynamicObject("org").getLong("id"));
                cashFlow.set("createtime", (Object)new Date());
                if (tradeBill.getDataEntityType().getProperties().containsKey((Object)"protecttype")) {
                    cashFlow.set("protecttype", tradeBill.get("protecttype"));
                }
                cashFlow.set("billno", data.get("no"));
            }
        }
        return colls;
    }

    protected ICashFlowBuilder[] getCashFlowBuilder(DynamicObject tradeBill) {
        String entityNumber;
        ICashFlowBuilder[] builders = null;
        switch (entityNumber = tradeBill.getDataEntityType().getName()) {
            case "tm_forex": {
                builders = new ICashFlowBuilder[]{new ForexBuyCashFlowBuilder(), new ForexSellCashFlowBuilder()};
                break;
            }
            case "tm_forex_forward": {
                boolean createBuyCashFlow = this.isCreateBuyCashFlow(tradeBill);
                boolean createSellCashFlow = this.isCreateSellCashFlow(tradeBill);
                if (createBuyCashFlow && createSellCashFlow) {
                    builders = new ICashFlowBuilder[]{new ForexBuyCashFlowBuilder(), new ForexSellCashFlowBuilder()};
                }
                if (createBuyCashFlow && !createSellCashFlow) {
                    builders = new ICashFlowBuilder[]{new ForexBuyCashFlowBuilder()};
                }
                if (createBuyCashFlow || !createSellCashFlow) break;
                builders = new ICashFlowBuilder[]{new ForexSellCashFlowBuilder()};
                break;
            }
            case "tm_forex_swaps": {
                builders = new ICashFlowBuilder[]{new ForexSwapsBuyCashFlowBuilder(), new ForexSwapsSellCashFlowBuilder()};
                break;
            }
            case "tm_structdeposit": {
                builders = new ICashFlowBuilder[]{new StructDepositCashFlowBuilder()};
                break;
            }
            case "tm_forwrateagree": {
                builders = new ICashFlowBuilder[]{new ForwRateAgreeCashFlowBuiler()};
                break;
            }
            case "tm_forex_options": {
                builders = new ICashFlowBuilder[]{new ForexOptionsBuyCashFlowBuilder(), new ForexOptionsSellCashFlowBuilder()};
                break;
            }
            case "tm_rateswap": {
                builders = new ICashFlowBuilder[]{new RateSwapsBuyCashFlowBuilder(), new RateSwapsSellCashFlowBuilder()};
                break;
            }
            default: {
                builders = new ICashFlowBuilder[]{};
            }
        }
        return builders;
    }

    private boolean isCreateBuyCashFlow(DynamicObject tradeBill) {
        DynamicObject settleCurrency;
        boolean isGenerate = true;
        if (tradeBill.getDataEntityType().getProperties().containsKey((Object)"settlecurrency") && EmptyUtil.isNoEmpty((DynamicObject)(settleCurrency = tradeBill.getDynamicObject("settlecurrency")))) {
            DynamicObject sellCurrency = tradeBill.getDynamicObject("sellcurrency");
            String deliverWay = tradeBill.getString("deliveryway");
            isGenerate = !DeliveryWayEnum.isNonDeliverable((String)deliverWay) || !EmptyUtil.isNoEmpty((DynamicObject)sellCurrency) || settleCurrency.getLong("id") != sellCurrency.getLong("id");
        }
        return isGenerate;
    }

    protected boolean isCreateSellCashFlow(DynamicObject tradeBill) {
        DynamicObject settleCurrency;
        boolean isGenerate = true;
        if (tradeBill.getDataEntityType().getProperties().containsKey((Object)"settlecurrency") && EmptyUtil.isNoEmpty((DynamicObject)(settleCurrency = tradeBill.getDynamicObject("settlecurrency")))) {
            DynamicObject buyCurrency = tradeBill.getDynamicObject("currency");
            String deliverWay = tradeBill.getString("deliveryway");
            isGenerate = !DeliveryWayEnum.isNonDeliverable((String)deliverWay) || !EmptyUtil.isNoEmpty((DynamicObject)buyCurrency) || settleCurrency.getLong("id") != buyCurrency.getLong("id");
        }
        return isGenerate;
    }
}

