/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.cashflow;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CashFlowSaveService
extends AbstractTmcBizOppService {
    private static final String FOREX_CASHFLOWPARAM = "{\"sellcashflow\":\"_s\",\"buycashflow\":\"\"}";

    public void process(DynamicObject[] dataEntities) throws KDException {
        boolean isImportForex = this.isImportForex(dataEntities);
        for (DynamicObject info : dataEntities) {
            if (!this.getOperationVariable().containsKey("cashFlowParam") && !isImportForex) continue;
            String cashFlowParam = isImportForex ? FOREX_CASHFLOWPARAM : (String)this.getOperationVariable().get("cashFlowParam");
            Map param = (Map)JSON.parseObject((String)cashFlowParam, Map.class);
            if (param.size() == 0) {
                return;
            }
            DynamicObjectCollection newCashflows = new DynamicObjectCollection();
            param.forEach((entity, extendPropName) -> {
                DynamicObjectCollection transCashflows = info.getDynamicObjectCollection(entity);
                if (transCashflows.size() > 0) {
                    newCashflows.addAll(this.assembleCashFlow(info, transCashflows, (String)extendPropName));
                }
            });
            if (newCashflows.size() <= 0) continue;
            Long billid = info.getLong("id");
            QFilter filter = new QFilter("billid", "=", (Object)billid);
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])filter.toArray());
            SaveServiceHelper.save((DynamicObject[])((DynamicObject[])newCashflows.toArray((Object[])new DynamicObject[newCashflows.size()])));
        }
    }

    private boolean isImportForex(DynamicObject[] dataEntities) {
        DynamicObject protectType;
        if (this.operationVariable.containsKey("importtype") && EmptyUtil.isNoEmpty((Object[])dataEntities) && EmptyUtil.isNoEmpty((DynamicObject)(protectType = dataEntities[0].getDynamicObject("protecttype")))) {
            String protectTypeId = String.valueOf(protectType.getLong("id"));
            return ProductTypeEnum.FOREXSPOT.getId().equals(protectTypeId) || ProductTypeEnum.FOREXFORWARD.getId().equals(protectTypeId) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectTypeId) || ProductTypeEnum.FOREXOPTION.getId().equals(protectTypeId);
        }
        return false;
    }

    private Collection<DynamicObject> assembleCashFlow(DynamicObject info, DynamicObjectCollection transCashflows, String extendPropName) {
        HashMap cashFlowMap = new HashMap();
        transCashflows.forEach(transCashFlow -> {
            Long pid = transCashFlow.getLong("pid");
            if (EmptyUtil.isNoEmpty((Long)pid)) {
                DynamicObject cashFlow = (DynamicObject)cashFlowMap.get(pid);
                DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
                DynamicObject entry = entrys.addNew();
                List<String> fields = this.getCashFlowFieldMap(entry);
                DataEntityPropertyCollection props = transCashFlow.getDataEntityType().getProperties();
                props.forEach(prop -> {
                    String property = prop.getName();
                    if (property.indexOf(extendPropName) > 0) {
                        property = property.substring(0, property.length() - extendPropName.length());
                    }
                    if (fields.contains(property)) {
                        entry.set(property, transCashFlow.get(prop));
                    }
                });
                entry.set("no", transCashFlow.get("no" + extendPropName));
            } else {
                DynamicObject cashFlow = TmcDataServiceHelper.newDynamicObject((String)"tm_cashflow");
                List<String> fields = this.getCashFlowFieldMap(cashFlow);
                DataEntityPropertyCollection props = transCashFlow.getDataEntityType().getProperties();
                props.forEach(prop -> {
                    String property = prop.getName();
                    if (property.indexOf(extendPropName) > 0) {
                        property = property.substring(0, property.length() - extendPropName.length());
                    }
                    if (fields.contains(property) && !property.endsWith("_id")) {
                        cashFlow.set(property, transCashFlow.get(prop));
                    }
                });
                cashFlow.set("billid", (Object)info.getLong("id"));
                cashFlow.set("billnumber", (Object)info.getString("billno"));
                cashFlow.set("org", (Object)info.getDynamicObject("org").getLong("id"));
                cashFlow.set("createtime", (Object)new Date());
                if (info.getDataEntityType().getProperties().containsKey((Object)"protecttype")) {
                    cashFlow.set("protecttype", (Object)info.getDynamicObject("protecttype").getLong("id"));
                }
                cashFlow.set("billno", transCashFlow.get("no" + extendPropName));
                cashFlowMap.put(cashFlow.getLong("id"), cashFlow);
            }
        });
        return cashFlowMap.values();
    }

    private List<String> getCashFlowFieldMap(DynamicObject cashFlow) {
        ArrayList<String> propertys = new ArrayList<String>();
        DataEntityPropertyCollection props = cashFlow.getDynamicObjectType().getProperties();
        props.forEach(prop -> propertys.add(prop.getName()));
        return propertys;
    }
}

