/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.combtrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class CombTradeUnAuditOpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("billno");
        sel.add("tradebill");
        sel.add("tradebillentity");
        sel.add("tradestatus");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashMap tradeId2EntityType = new HashMap(16);
        HashMap<String, HashSet<Long>> tradeId4UnauditMap = new HashMap<String, HashSet<Long>>(16);
        ArrayList<DynamicObject> tradeBills = new ArrayList<DynamicObject>(16);
        for (DynamicObject combtradeBill : dataEntities) {
            DynamicObject[] tradeList;
            DynamicObjectCollection entryentity = combtradeBill.getDynamicObjectCollection("entryentity");
            List tradeIds = entryentity.stream().map(v -> v.getLong("tradebill")).collect(Collectors.toList());
            entryentity.forEach(v -> {
                String entityType = v.getString("tradebillentity");
                Long billId = v.getLong("tradebill");
                tradeId2EntityType.put(billId, entityType);
            });
            for (DynamicObject tradeDO : tradeList = TmcDataServiceHelper.load((String)"tm_trade", (String)"id,protecttype, billstatus,composeaudit,composeno", (QFilter[])new QFilter[]{new QFilter("id", "in", tradeIds)})) {
                boolean composeaudit = tradeDO.getBoolean("composeaudit");
                String billstatus = tradeDO.getString("billstatus");
                if (composeaudit && TcBillStatusEnum.AUDIT.getValue().equals(billstatus)) {
                    long billId = tradeDO.getLong("id");
                    String entityType = (String)tradeId2EntityType.get(tradeDO.getLong("id"));
                    HashSet<Long> billIds4Audit = (HashSet<Long>)tradeId4UnauditMap.get(entityType);
                    if (billIds4Audit == null) {
                        billIds4Audit = new HashSet<Long>(5);
                        tradeId4UnauditMap.put(entityType, billIds4Audit);
                    }
                    billIds4Audit.add(billId);
                    continue;
                }
                tradeDO.set("composeno", null);
                tradeBills.add(tradeDO);
            }
        }
        if (!tradeBills.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])tradeBills.toArray(new DynamicObject[0]));
        }
        if (!tradeId4UnauditMap.isEmpty()) {
            OperateOption opOption = OperateOption.create();
            opOption.setVariableValue("combtrade_unaudit", "true");
            for (Map.Entry entry : tradeId4UnauditMap.entrySet()) {
                String entityNumber = (String)entry.getKey();
                Set ids = (Set)entry.getValue();
                TmcOperateServiceHelper.execOperate((String)"unaudit", (String)entityNumber, (Object[])ids.toArray(new Object[0]), (OperateOption)opOption);
            }
        }
    }
}

