/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.optioncom;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;

public class OptionCombAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List select = super.getSelector();
        select.add("assettype");
        select.add("entrys.tradeno");
        return select;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<Long> tradeIdList4Audit = new ArrayList<Long>(16);
        for (DynamicObject bill : dataEntities) {
            String assetType = bill.getString("assettype");
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entrys");
            List tradeList = entrys.stream().map(s -> s.getDynamicObject("tradeno").getLong("id")).collect(Collectors.toList());
            DynamicObject[] tradeBills = TmcDataServiceHelper.load((String)assetType.replace("_l", ""), (String)"id,billstatus,composeaudit,auditor,auditdate,modifier,modifytime", (QFilter[])new QFilter[]{new QFilter("id", "in", tradeList)});
            boolean isFinish = true;
            for (DynamicObject tradeDO : tradeBills) {
                boolean composeaudit = tradeDO.getBoolean("composeaudit");
                String billstatus = tradeDO.getString("billstatus");
                if (composeaudit && TcBillStatusEnum.SUBMIT.getValue().equals(billstatus)) {
                    tradeIdList4Audit.add(tradeDO.getLong("id"));
                }
                isFinish = TcBillStatusEnum.FINISH.getValue().equals(billstatus);
            }
            if (!isFinish) continue;
            bill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
        }
        if (!tradeIdList4Audit.isEmpty()) {
            OperateOption opOption = OperateOption.create();
            opOption.setVariableValue("combtrade_audit", "true");
            TmcOperateServiceHelper.execOperate((String)"audit", (String)"tm_forex_options", (Object[])tradeIdList4Audit.toArray(new Object[0]), (OperateOption)opOption);
        }
    }
}

