/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.rate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.errorcode.TmcErrorCode;
import kd.tmc.fbp.common.exception.TmcBizException;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class RateSwapAuditOpService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("basecurrency");
        selector.add("plcurrency");
        selector.add("startdate");
        selector.add("currency");
        selector.add("reccurrency");
        selector.add("pricerule");
        selector.add("initpriextype");
        selector.add("reclocalfq");
        selector.add("reclocalexrate");
        selector.add("paylocalfq");
        selector.add("paylocalexrate");
        selector.add("voucherpl");
        selector.add("initexamount");
        selector.add("recinitexamount");
        selector.add("bizdate");
        selector.add("rateswaptype");
        selector.add("initpriextype");
        selector.add("buysettledate");
        selector.add("fxquote");
        selector.add("spotrate");
        selector.add("basefq");
        selector.add("baseexrate");
        selector.add("baseplamt");
        selector.add("plamt");
        selector.add("settledate");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject bill : dataEntities) {
            this.setplinfo(bill);
        }
    }

    private void setplinfo(DynamicObject bill) {
        bill.set("buysettledate", bill.get("startdate"));
        bill.set("plcurrency", bill.get("reccurrency"));
        String swapType = bill.getString("rateswaptype");
        String initpriexType = bill.getString("initpriextype");
        if (SwapTypeEnum.currency.getValue().equals(swapType) && SwapExchangeType.Actual.getValue().equals(initpriexType)) {
            this.setSpotRate(bill);
            this.setBasePlInfo(bill);
        }
        this.calVoucherPl(bill);
    }

    private boolean isShowVoucherPlPanel(DynamicObject bill) {
        DynamicObject recCurrency;
        DynamicObject payCurrency;
        DynamicObject baseCurrency;
        DynamicObject priceRule = bill.getDynamicObject("pricerule");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, baseCurrency = bill.getDynamicObject("basecurrency"), payCurrency = bill.getDynamicObject("currency"), recCurrency = bill.getDynamicObject("reccurrency")})) {
            return false;
        }
        String swapType = bill.getString("rateswaptype");
        String initpriexType = bill.getString("initpriextype");
        long payCurrencyId = payCurrency.getLong("id");
        long recCurrencyId = recCurrency.getLong("id");
        long baseCurrencyId = baseCurrency.getLong("id");
        return SwapTypeEnum.currency.getValue().equals(swapType) && SwapExchangeType.Actual.getValue().equals(initpriexType) && payCurrencyId != baseCurrencyId && recCurrencyId != baseCurrencyId;
    }

    private void calVoucherPl(DynamicObject bill) {
        DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
        if (this.isShowVoucherPlPanel(bill)) {
            this.setVoucherPl(bill, baseCurrency);
        } else {
            bill.set("reclocalfq", (Object)"");
            bill.set("reclocalexrate", (Object)BigDecimal.ZERO);
            bill.set("paylocalfq", (Object)"");
            bill.set("paylocalexrate", (Object)BigDecimal.ZERO);
            bill.set("voucherpl", (Object)BigDecimal.ZERO);
        }
    }

    private void setVoucherPl(DynamicObject bill, DynamicObject baseCurrency) {
        BigDecimal payExAmt;
        BigDecimal payExRate;
        BigDecimal recExAmt;
        BigDecimal recExRate;
        BigDecimal recAmt = bill.getBigDecimal("initexamount");
        BigDecimal payAmt = bill.getBigDecimal("recinitexamount");
        payAmt = payAmt.abs();
        DynamicObject recCurrency = bill.getDynamicObject("currency");
        DynamicObject payCurrency = bill.getDynamicObject("reccurrency");
        String recCurrencyNumber = recCurrency.getString("number");
        String payCurrencyNumber = payCurrency.getString("number");
        Date bizDate = bill.getDate("bizdate");
        DynamicObject priceRule = bill.getDynamicObject("pricerule");
        ForexQuoteInfo recCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(recCurrencyNumber + "/" + baseCurrency.getString("number")), (Date)bizDate, null);
        String recCurFxQuote = recCurFqInfo.getFxquote();
        if (recCurrencyNumber.equals(recCurFxQuote.split("/")[0])) {
            recExRate = recCurFqInfo.getBuyPrice();
            recExAmt = recAmt.multiply(recExRate);
        } else {
            recExRate = recCurFqInfo.getSellPrice();
            recExAmt = recAmt.divide(recExRate, 10, 4);
        }
        ForexQuoteInfo payCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(payCurrencyNumber + "/" + baseCurrency.getString("number")), (Date)bizDate, null);
        String payCurFxQuote = payCurFqInfo.getFxquote();
        if (payCurrencyNumber.equals(payCurFxQuote.split("/")[0])) {
            payExRate = payCurFqInfo.getBuyPrice();
            payExAmt = payAmt.multiply(payExRate);
        } else {
            payExRate = payCurFqInfo.getSellPrice();
            payExAmt = payAmt.divide(payExRate, 10, 4);
        }
        bill.set("reclocalexrate", (Object)recExRate);
        bill.set("paylocalexrate", (Object)payExRate);
        bill.set("reclocalfq", (Object)recCurFxQuote);
        bill.set("paylocalfq", (Object)payCurFxQuote);
        bill.set("voucherpl", (Object)recExAmt.subtract(payExAmt));
    }

    private void setPlAmt(DynamicObject bill) {
        BigDecimal amtPay = bill.getBigDecimal("initexamount");
        BigDecimal amtRec = bill.getBigDecimal("recinitexamount");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        DynamicObject payCurrency = bill.getDynamicObject("currency");
        String fxquote = bill.getString("fxquote");
        BigDecimal spotrate = bill.getBigDecimal("spotrate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{spotrate, plCurrency, payCurrency, amtPay, amtRec})) {
            if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                amtRec = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? amtRec.divide(spotrate, 10, 4) : amtRec.multiply(spotrate);
            } else {
                amtPay = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? amtPay.divide(spotrate, 10, 4) : amtPay.multiply(spotrate);
            }
            bill.set("plamt", (Object)amtRec.add(amtPay));
        }
    }

    private void setBasePlInfo(DynamicObject bill) {
        this.setPlAmt(bill);
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, baseCurrency})) {
            if (plCurrency.getLong("id") != baseCurrency.getLong("id")) {
                BigDecimal baseAmt;
                BigDecimal baseExrate;
                DynamicObject priceRule = bill.getDynamicObject("pricerule");
                if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
                    bill.set("basefq", null);
                    bill.set("baseexrate", null);
                    bill.set("baseplamt", null);
                    return;
                }
                if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                    throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"RateSwapAuditOpService_0", (String)"tmc-tm-business", (Object[])new Object[0])});
                }
                String pair = baseCurrency.getString("number") + "/" + plCurrency.getString("number");
                Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
                Date bizdate = bill.getDate("settledate");
                ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, null);
                bill.set("basefq", (Object)fqInfo.getFxquote());
                BigDecimal amt_pl = bill.getBigDecimal("plamt");
                if (plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0])) {
                    baseExrate = fqInfo.getBuyPrice();
                    baseAmt = amt_pl.multiply(baseExrate);
                } else {
                    baseExrate = fqInfo.getSellPrice();
                    baseAmt = amt_pl.divide(baseExrate, 10, 4);
                }
                bill.set("baseexrate", (Object)baseExrate);
                bill.set("baseplamt", (Object)baseAmt);
            } else {
                bill.set("basefq", null);
                bill.set("baseexrate", null);
                bill.set("baseplamt", null);
            }
        } else {
            bill.set("basefq", null);
            bill.set("baseexrate", null);
            bill.set("baseplamt", null);
        }
    }

    private void setSpotRate(DynamicObject bill) {
        DynamicObject priceRule;
        DynamicObject recCurrency;
        DynamicObject currency = bill.getDynamicObject("currency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, recCurrency = bill.getDynamicObject("reccurrency"), priceRule = bill.getDynamicObject("pricerule")})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                throw new TmcBizException(TmcErrorCode.COMMON, new Object[]{ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"RateSwapAuditOpService_0", (String)"tmc-tm-business", (Object[])new Object[0])});
            }
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            String pair = currency.getString("number") + "/" + recCurrency.getString("number");
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, null);
            bill.set("fxquote", (Object)fqInfo.getFxquote());
            DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
            BigDecimal spotrate = plCurrency != null && plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0]) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice();
            bill.set("spotrate", (Object)spotrate);
        }
    }
}

