/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.requestnote;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;

public class ReqNoteGenForexService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("sourcebillid");
        selector.add("reqnoteno");
        selector.add("billno");
        selector.add("source");
        return selector;
    }

    public void process(DynamicObject[] entities) throws KDException {
        block0: for (DynamicObject entity : entities) {
            String entityName = entity.getDataEntityType().getName();
            if (!"tm_forex_forward".equals(entityName) && !"tm_forex".equals(entityName) && !"tm_forex_swaps".equals(entityName) && !"tm_forex_options".equals(entityName)) continue;
            Long sourcebillid = entity.getLong("sourcebillid");
            String source = entity.getString("source");
            String reqnoteno = entity.getString("reqnoteno");
            if (EmptyUtil.isEmpty((String)reqnoteno)) continue;
            QFilter noteFilter = new QFilter("billno", "=", (Object)reqnoteno);
            String entryIdProp = this.getProductTypeMap(entityName) + ".id";
            noteFilter.and(new QFilter(entryIdProp, "=", (Object)sourcebillid));
            String selectProp = this.getSelectProp(entityName);
            CombReqNoteEnum combReqNote = CombReqNoteEnum.getByBillType((String)entityName);
            boolean isCombreqnote = StringUtils.contains((CharSequence)source, (CharSequence)"combreqnote");
            DynamicObject forwardinfo = isCombreqnote ? TmcDataServiceHelper.loadSingle((String)"tm_combreqnote", (String)(selectProp + String.format(",%s.%s", combReqNote.getEntryName(), combReqNote.getBillIdName())), (QFilter[])new QFilter[]{noteFilter}) : TmcDataServiceHelper.loadSingle((String)"tm_reqnote", (String)selectProp, (QFilter[])new QFilter[]{noteFilter});
            DynamicObjectCollection entry = forwardinfo.getDynamicObjectCollection(this.getProductTypeMap(entityName));
            for (DynamicObject info : entry) {
                boolean foisbizbill;
                long entryid = info.getLong("id");
                if (sourcebillid != entryid || (foisbizbill = info.getBoolean(this.getIsbizbill(entityName)))) continue;
                info.set(this.getIsbizbill(entityName), (Object)true);
                if (isCombreqnote) {
                    info.set(combReqNote.getBillIdName(), entity.getPkValue());
                }
                SaveServiceHelper.update((DynamicObject[])this.addFar(entityName, entry, info));
                continue block0;
            }
        }
    }

    private DynamicObject[] addFar(String entityName, DynamicObjectCollection entry, DynamicObject info) {
        if ("tm_forex_swaps".equals(entityName)) {
            int seq = info.getInt("seq");
            for (DynamicObject farrow : entry) {
                int farseq = farrow.getInt("seq");
                if (farseq != seq + 1) continue;
                farrow.set(this.getIsbizbill(entityName), (Object)true);
                return new DynamicObject[]{info, farrow};
            }
        }
        return new DynamicObject[]{info};
    }

    private String getSelectProp(String entityName) {
        ArrayList<String> props = new ArrayList<String>();
        String isbizbill = StringUtils.join((Object[])new String[]{this.getProductTypeMap(entityName), ".", this.getIsbizbill(entityName)});
        String seq = StringUtils.join((Object[])new String[]{this.getProductTypeMap(entityName), ".seq"});
        props.add("id");
        props.add(isbizbill);
        props.add(seq);
        return StringUtils.join((Object[])props.toArray(new String[props.size()]), (String)",");
    }

    private String getIsbizbill(String entitType) {
        if ("tm_forex_forward".equals(entitType)) {
            return "foisbizbill";
        }
        if ("tm_forex".equals(entitType)) {
            return "spisbizbill";
        }
        if ("tm_forex_swaps".equals(entitType)) {
            return "swisbizbill";
        }
        if ("tm_forex_options".equals(entitType)) {
            return "opisbizbill";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ReqNoteGenForexService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
    }

    private String getProductTypeMap(String entitType) {
        if ("tm_forex_forward".equals(entitType)) {
            return "forwardinfo";
        }
        if ("tm_forex".equals(entitType)) {
            return "spotinfo";
        }
        if ("tm_forex_swaps".equals(entitType)) {
            return "swapsinfo";
        }
        if ("tm_forex_options".equals(entitType)) {
            return "optionsinfo";
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u4ea7\u54c1\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"ReqNoteGenForexService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
    }
}

