/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.requestnote;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.helper.ReqLimitHelper;
import kd.tmc.tm.common.helper.ReqNoteHelper;

public class ReqNoteLimitOccService
extends AbstractTmcBizOppService {
    private static final Log logger = LogFactory.getLog(ReqNoteLimitOccService.class);

    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("spotinfo");
        selector.add("spotcurrencytypein");
        selector.add("spotcurrencytypeout");
        selector.add("spotamountin");
        selector.add("spotamountout");
        selector.add("swapsinfo");
        selector.add("currin");
        selector.add("currout");
        selector.add("amtin");
        selector.add("amtout");
        selector.add("forwardinfo");
        selector.add("currencytypein");
        selector.add("currencytypeout");
        selector.add("amountin");
        selector.add("amountout");
        selector.add("producttype");
        selector.add("limtno");
        selector.add("optionsinfo");
        selector.add("opcurrin");
        selector.add("opcurrout");
        selector.add("opamtin");
        selector.add("opamtout");
        return selector;
    }

    public void process(DynamicObject[] entities) throws KDException {
        logger.info("start process limitocc :" + Thread.currentThread().getId());
        for (DynamicObject entity : entities) {
            this.useLimit(entity);
        }
        logger.info("end process limitocc :" + Thread.currentThread().getId());
    }

    private void useLimit(DynamicObject entity) {
        DynamicObject productType = entity.getDynamicObject("producttype");
        if (EmptyUtil.isEmpty((DynamicObject)productType)) {
            return;
        }
        String number = productType.getString("number");
        CombReqNoteEnum productTypeEnum = CombReqNoteEnum.getByProductType((String)number);
        String entryName = productTypeEnum.getEntryName();
        DynamicObjectCollection reqNoteEntries = entity.getDynamicObjectCollection(entryName);
        DynamicObject limit = entity.getDynamicObject("limtno");
        if (EmptyUtil.isEmpty((DynamicObject)limit)) {
            return;
        }
        long limitId = limit.getLong("id");
        DynamicObject limitDb = TmcDataServiceHelper.loadSingle((Object)limitId, (String)"tm_reqlimit");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{limitDb, reqNoteEntries})) {
            return;
        }
        HashMap reqnoteCurrencyMap = new HashMap();
        ReqNoteHelper.sumReqNoteCurrAndAmt((DynamicObjectCollection)reqNoteEntries, (CombReqNoteEnum)productTypeEnum, reqnoteCurrencyMap, null);
        ReqLimitHelper.occLimitAmt((DynamicObject)entity, (DynamicObject)limitDb, reqnoteCurrencyMap);
    }
}

