/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade;

import java.util.Date;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.helper.CashFlowDAOHelper;

public class BuyUnSettleService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sic = super.getSelector();
        sic.add("isbuysettle");
        sic.add("tradedirect");
        return sic;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        block12: for (DynamicObject bill : dataEntities) {
            String entity;
            switch (entity = bill.getDataEntityType().getName()) {
                case "tm_structdeposit": 
                case "tm_bond_fix": 
                case "tm_bond_float": {
                    Object[] ids = TmcBotpHelper.getTargetBillIds((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill");
                    if (EmptyUtil.isNoEmpty((Object[])ids)) {
                        OperateOption op = OperateOption.create();
                        op.setVariableValue("tmc_tm", "buyunsettle");
                        OperationResult result = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])ids, (OperateOption)op, (boolean)true);
                        if (result.isSuccess()) {
                            bill.set("isbuysettle", (Object)Boolean.FALSE);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                        }
                    } else {
                        bill.set("isbuysettle", (Object)Boolean.FALSE);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                    }
                    this.updateCashflow(bill);
                    continue block12;
                }
                case "tm_rateswap": {
                    this.unSettleRateSwap(bill);
                    continue block12;
                }
                case "tm_forex_options": {
                    this.unSettleForexOptions(bill);
                }
            }
        }
    }

    private void unSettleForexOptions(DynamicObject bill) {
        DynamicObjectCollection recbills;
        OperateOption op;
        OperateOption op2;
        DynamicObjectCollection paybills;
        String tradeDir = bill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(tradeDir) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(paybills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill", (String)"id,billstatus")))) {
            for (DynamicObject paybill : paybills) {
                OperationResult result_pay;
                if (TcBillStatusEnum.SAVE.getValue().equals(paybill.getString("billstatus"))) {
                    op2 = OperateOption.create();
                    op2.setVariableValue("tmc_tm", "buyunsettle");
                    OperationResult result_pay2 = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{paybill.getLong("id")}, (OperateOption)op2, (boolean)true);
                    if (result_pay2.isSuccess()) {
                        bill.set("isbuysettle", (Object)Boolean.FALSE);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                    }
                }
                if (!TcBillStatusEnum.SUBMIT.getValue().equals(paybill.getString("billstatus")) || !(result_pay = TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"cas_paybill", (Object[])new Long[]{paybill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true)).isSuccess()) continue;
                op = OperateOption.create();
                op.setVariableValue("tmc_tm", "buyunsettle");
                result_pay = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])new Long[]{paybill.getLong("id")}, (OperateOption)op, (boolean)true);
                if (!result_pay.isSuccess()) continue;
                bill.set("isbuysettle", (Object)Boolean.FALSE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradeDir) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(recbills = TmcBotpHelper.queryTargetBills((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_recbill", (String)"id,billstatus")))) {
            for (DynamicObject recbill : recbills) {
                OperationResult result_rec;
                if (TcBillStatusEnum.SAVE.getValue().equals(recbill.getString("billstatus"))) {
                    op2 = OperateOption.create();
                    op2.setVariableValue("tmc_tm", "buyunsettle");
                    OperationResult result_rec2 = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{recbill.getLong("id")}, (OperateOption)op2, (boolean)true);
                    if (result_rec2.isSuccess()) {
                        bill.set("isbuysettle", (Object)Boolean.FALSE);
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                    }
                }
                if (!TcBillStatusEnum.SUBMIT.getValue().equals(recbill.getString("billstatus")) || !(result_rec = TmcOperateServiceHelper.execOperate((String)"unsubmit", (String)"cas_recbill", (Object[])new Long[]{recbill.getLong("id")}, (OperateOption)OperateOption.create(), (boolean)true)).isSuccess()) continue;
                op = OperateOption.create();
                op.setVariableValue("tmc_tm", "buyunsettle");
                result_rec = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])new Long[]{recbill.getLong("id")}, (OperateOption)op, (boolean)true);
                if (!result_rec.isSuccess()) continue;
                bill.set("isbuysettle", (Object)Boolean.FALSE);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            }
        }
    }

    private void unSettleRateSwap(DynamicObject bill) {
        OperateOption op;
        Object[] ids_pay = TmcBotpHelper.getTargetBillIds((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_paybill");
        Object[] ids_rec = TmcBotpHelper.getTargetBillIds((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_recbill");
        Object[] ids_exc = TmcBotpHelper.getTargetBillIds((String)bill.getDataEntityType().getName(), (Object)bill.getLong("id"), (String)"cas_exchangebill");
        boolean delPay = true;
        boolean delRec = true;
        boolean delExc = true;
        if (EmptyUtil.isNoEmpty((Object[])ids_pay)) {
            op = OperateOption.create();
            op.setVariableValue("tmc_tm", "buyunsettle");
            OperationResult result_pay = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_paybill", (Object[])ids_pay, (OperateOption)op, (boolean)true);
            delPay = result_pay.isSuccess();
        }
        if (EmptyUtil.isNoEmpty((Object[])ids_rec)) {
            op = OperateOption.create();
            op.setVariableValue("tmc_tm", "buyunsettle");
            OperationResult result_rec = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_recbill", (Object[])ids_rec, (OperateOption)op, (boolean)true);
            delRec = result_rec.isSuccess();
        }
        if (EmptyUtil.isNoEmpty((Object[])ids_exc)) {
            op = OperateOption.create();
            op.setVariableValue("tmc_tm", "buyunsettle");
            OperationResult result_exc = TmcOperateServiceHelper.execOperate((String)"delete", (String)"cas_exchangebill", (Object[])ids_exc, (OperateOption)op, (boolean)true);
            delExc = result_exc.isSuccess();
        }
        if (delPay && delRec && delExc) {
            QFilter filter_sell;
            bill.set("isbuysettle", (Object)Boolean.FALSE);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
            QFilter filter = new QFilter("billid", "=", bill.getPkValue());
            QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
            Object[] cashFlow = CashFlowDAOHelper.loadAsc((String)"cfpaydate,cfispay", (QFilter[])new QFilter[]{filter, filter_buy});
            if (EmptyUtil.isNoEmpty((Object[])cashFlow)) {
                cashFlow[0].set("cfispay", (Object)false);
                SaveServiceHelper.save((DynamicObject[])cashFlow);
            }
            if (EmptyUtil.isNoEmpty((Object[])(cashFlow = CashFlowDAOHelper.loadAsc((String)"cfpaydate,cfispay", (QFilter[])new QFilter[]{filter, filter_sell = new QFilter("cfdirection", "=", (Object)"sell")})))) {
                cashFlow[0].set("cfispay", (Object)false);
                SaveServiceHelper.save((DynamicObject[])cashFlow);
            }
            QFilter plFilter = new QFilter("tradebill", "=", (Object)bill.getLong("id"));
            DeleteServiceHelper.delete((String)"tbo_plinfo", (QFilter[])new QFilter[]{plFilter});
        }
    }

    private void updateCashflow(DynamicObject bill) {
        String entity;
        switch (entity = bill.getDataEntityType().getName()) {
            case "tm_structdeposit": {
                DynamicObject tempBill = TmcDataServiceHelper.loadSingle((Object)bill.getLong("id"), (String)"tm_structdeposit", (String)"id,intdate");
                QFilter filter = new QFilter("billid", "=", (Object)tempBill.getLong("id"));
                filter.and(new QFilter("billno", "=", (Object)"1"));
                Object[] cashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfpaydate", (QFilter[])filter.toArray());
                if (!EmptyUtil.isNoEmpty((Object[])cashFlow)) break;
                Date payDate = tempBill.getDate("intdate");
                cashFlow[0].set("cfpaydate", (Object)payDate);
                SaveServiceHelper.save((DynamicObject[])cashFlow);
            }
        }
    }
}

