/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade;

import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class PortfolioUniqueLinkService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("portfolio");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject info : dataEntities) {
            String billEntity = info.getDataEntityType().getName();
            DynamicObject curPortfolio = info.getDynamicObject("portfolio");
            if (TmcDataServiceHelper.exists((Object)info.getPkValue(), (String)billEntity)) {
                DynamicObject oldInfo = TmcDataServiceHelper.loadSingle((Object)info.getPkValue(), (String)billEntity);
                DynamicObject oldPortfolio = oldInfo.getDynamicObject("portfolio");
                if (EmptyUtil.isNoEmpty((DynamicObject)oldPortfolio)) {
                    if (EmptyUtil.isNoEmpty((Object)info.get("portfolio"))) {
                        if (oldPortfolio.getPkValue().equals(curPortfolio.getPkValue())) continue;
                        this.portfolioDelEntry(oldPortfolio.getPkValue(), info.getPkValue().toString());
                        this.portfolioAddEntry(curPortfolio.getPkValue(), info.getPkValue().toString(), billEntity);
                        continue;
                    }
                    this.portfolioDelEntry(oldPortfolio.getPkValue(), info.getPkValue().toString());
                    continue;
                }
                if (!EmptyUtil.isNoEmpty((Object)info.get("portfolio"))) continue;
                this.portfolioAddEntry(curPortfolio.getPkValue(), info.getPkValue().toString(), billEntity);
                continue;
            }
            if (!EmptyUtil.isNoEmpty((Object)info.get("portfolio"))) continue;
            this.portfolioAddEntry(curPortfolio.getPkValue(), info.getPkValue().toString(), billEntity);
        }
    }

    private void portfolioAddEntry(Object portfolioId, String billid, String billEntity) {
        DynamicObject curPortfolio = TmcDataServiceHelper.loadSingle((Object)portfolioId, (String)"mrm_portfolio", (String)"entrys.billid,entrys.billentity");
        DynamicObjectCollection curPortfolioEntrys = curPortfolio.getDynamicObjectCollection("entrys");
        DynamicObject newEntry = curPortfolioEntrys.addNew();
        newEntry.set("billid", (Object)billid);
        newEntry.set("billentity", (Object)billEntity);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{curPortfolio});
    }

    private void portfolioDelEntry(Object portfolioId, String billid) {
        DynamicObject portfolio = TmcDataServiceHelper.loadSingle((Object)portfolioId, (String)"mrm_portfolio", (String)"entrys.billid,entrys.billentity");
        DynamicObjectCollection portfolioEntrys = portfolio.getDynamicObjectCollection("entrys");
        Iterator it = portfolioEntrys.iterator();
        while (it.hasNext()) {
            DynamicObject next = (DynamicObject)it.next();
            if (!billid.equals(next.getString("billid"))) continue;
            it.remove();
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{portfolio});
    }
}

