/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.opservice.trade.cfg.AbsTradeBillCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.ForexPlInfoCreator;
import kd.tmc.tm.business.service.bizbill.forex.ForexLifecycleService;
import kd.tmc.tm.common.enums.BizRecordDescEnum;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;
import kd.tmc.tm.common.helper.ForexHelper;

public class ForexSwapCfgHandler
extends AbsTradeBillCfgHandler {
    @Override
    public void process(DynamicObject[] dataEntities) {
        this.billDataEntities = Arrays.stream(dataEntities).filter(v -> ProductTypeEnum.FOREXSWAPS.getId().equals(v.getDynamicObject("protecttype").getString("id"))).collect(Collectors.toList());
        for (DynamicObject bill : this.billDataEntities) {
            ForexHelper.setBuyAmtAndSellAmtInfo((DynamicObject)bill);
            ForexLifecycleService.init_swaps(bill);
            this.cfg_forexSwaps(bill, this.plInfos, this.bizRecords);
        }
        this.saveBills();
    }

    private void cfg_forexSwaps(DynamicObject bill, List<DynamicObject> plInfos, List<DynamicObject> bizRecords) {
        Object[] cashflowCol;
        DynamicObject bizRecord = this.createBizRecordNear(bill);
        bizRecords.add(bizRecord);
        DynamicObject bizRecordFar = this.createBizRecordFar(bill);
        bizRecords.add(bizRecordFar);
        long bizRecordId = bizRecord.getLong("id");
        long bizRecordFarId = bizRecordFar.getLong("id");
        for (Object cashflow : cashflowCol = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfbizrecordid", (QFilter[])new QFilter[]{new QFilter("billid", "=", bill.getPkValue())})) {
            if ("1".equals(cashflow.getString("billno"))) {
                cashflow.set("cfbizrecordid", (Object)bizRecordId);
                continue;
            }
            cashflow.set("cfbizrecordid", (Object)bizRecordFarId);
        }
        if (EmptyUtil.isNoEmpty((Object[])cashflowCol)) {
            this.cashFlows.addAll(Arrays.asList(cashflowCol));
        }
        String swapType = bill.getString("swaptype");
        String forexSwapType_n = null;
        String forexSwapType_f = null;
        if (ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType)) {
            forexSwapType_n = "spot";
            forexSwapType_f = "forward";
        }
        if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType)) {
            forexSwapType_n = "forward";
            forexSwapType_f = "forward";
        }
        if (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType)) {
            forexSwapType_n = "spot";
            forexSwapType_f = "spot";
        }
        DynamicObject plInfo = new ForexPlInfoCreator().genPlInfo_Forex("spot", bill, bizRecord);
        plInfo.set("bizrecord", (Object)bizRecordId);
        plInfo.set("swapdir", (Object)"isnear");
        plInfo.set("forexswaptype", (Object)forexSwapType_n);
        plInfos.add(plInfo);
        DynamicObject farPlInfo = new ForexPlInfoCreator().genPlInfo_Forex("forw", bill, bizRecord);
        farPlInfo.set("bizrecord", (Object)bizRecordFarId);
        farPlInfo.set("swapdir", (Object)"isfar");
        farPlInfo.set("forexswaptype", (Object)forexSwapType_f);
        plInfos.add(farPlInfo);
    }

    private DynamicObject createBizRecordNear(DynamicObject bill) {
        DynamicObject bizRecord = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        long bizRecordId = DBServiceHelper.genGlobalLongId();
        bizRecord.set("id", (Object)bizRecordId);
        bizRecord.set("createtime", (Object)new Date());
        bizRecord.set("tradebillid", (Object)bill.getLong("id"));
        bizRecord.set("exrate", bill.get("spotrate"));
        bizRecord.set("restamt", bill.get("amount"));
        bizRecord.set("currency", bill.get("currency"));
        bizRecord.set("lv", (Object)0);
        bizRecord.set("seqno", (Object)0);
        bizRecord.set("desc", (Object)BizRecordDescEnum.ORIGINAL.getValue());
        bizRecord.set("bizdate", bill.get("adjustsettledate"));
        bizRecord.set("swapdir", (Object)"isnear");
        return bizRecord;
    }

    private DynamicObject createBizRecordFar(DynamicObject bill) {
        DynamicObject bizRecordFar = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        long bizRecordFarId = DBServiceHelper.genGlobalLongId();
        bizRecordFar.set("id", (Object)bizRecordFarId);
        bizRecordFar.set("createtime", (Object)new Date());
        bizRecordFar.set("tradebillid", (Object)bill.getLong("id"));
        bizRecordFar.set("exrate", bill.get("forwrate"));
        bizRecordFar.set("restamt", bill.get("amount"));
        bizRecordFar.set("currency", bill.get("currency"));
        bizRecordFar.set("lv", (Object)0);
        bizRecordFar.set("seqno", (Object)0);
        bizRecordFar.set("desc", (Object)BizRecordDescEnum.ORIGINAL.getValue());
        bizRecordFar.set("bizdate", bill.get("adjustsettledate_far"));
        bizRecordFar.set("swapdir", (Object)"isfar");
        return bizRecordFar;
    }
}

