/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.enums.ReturnValTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.helper.RateSwapHelper;
import kd.tmc.tm.common.resource.TeBizResource;

public class FwRatePlInfoCreator {
    public DynamicObject genPlInfo_ForwRateAgree(DynamicObject bill, DynamicObject bizRecord) {
        DynamicObject priceRule;
        DynamicObject plInfo = BusinessDataServiceHelper.newDynamicObject((String)"tbo_plinfo");
        plInfo.set("tradebizdate", bill.get("bizdate"));
        plInfo.set("tradebill", (Object)bill);
        DynamicObject org = bill.getDynamicObject("org");
        plInfo.set("org", (Object)org);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_plinfo", (DynamicObject)plInfo, org != null ? org.getString("id") : null);
        if (EmptyUtil.isEmpty((String)billNo)) {
            throw new KDBizException(TeBizResource.plCodeRuleNotSet());
        }
        plInfo.set("billno", (Object)billNo);
        plInfo.set("tradeType", bill.get("protecttype"));
        plInfo.set("standardcurrency", bill.get("currency"));
        BigDecimal tradeAmount = bill.getBigDecimal("amount");
        plInfo.set("amount", (Object)tradeAmount);
        BigDecimal contractRate = bill.getBigDecimal("contractrate");
        plInfo.set("exrate", (Object)contractRate);
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)((DynamicObject)bill.get("org")).getPkValue()));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        DynamicObject localCurrency = BusinessDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
        this.validateBaseCurrency(localCurrencyId);
        plInfo.set("localcurrency", (Object)localCurrency);
        plInfo.set("plcurrency", bill.get("currency"));
        plInfo.set("billstatus", (Object)TcBillStatusEnum.SAVE.getValue());
        Date now = TcDateUtils.getCurrentDate();
        plInfo.set("updatedate", (Object)now);
        DynamicObject pricerule = bill.getDynamicObject("pricerule");
        DynamicObject market = bill.getDynamicObject("market");
        DynamicObject yields = this.getYields(market, pricerule);
        plInfo.set("yieldcurve", (Object)yields);
        DynamicObject cashFlowEntry = this.getCashFlow(bill.getLong("id"));
        BigDecimal predictRate = this.calRefrate_forwRateAgree(cashFlowEntry, bill, now, yields);
        plInfo.set("referexrate", (Object)predictRate);
        BigDecimal floatPlAmt = this.calcFloatPlAmt_forwRateAgree(bill, cashFlowEntry, predictRate);
        plInfo.set("floatplamt", (Object)floatPlAmt);
        plInfo.set("floatpllocalamt", null);
        plInfo.set("act_floatplamt", (Object)floatPlAmt);
        if (!localCurrencyId.equals(bill.getDynamicObject("currency").getLong("id")) && (priceRule = bill.getDynamicObject("pricerule")) != null) {
            DynamicObject forexquote = priceRule.getDynamicObject("forexquote");
            String fxquote_local = plInfo.getDynamicObject("plcurrency").getString("number").trim() + "/" + localCurrency.getString("number").trim();
            if (EmptyUtil.isNoEmpty((DynamicObject)forexquote)) {
                forexquote = BusinessDataServiceHelper.load((String)"md_forexquote", (String)"id,issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)forexquote.getLong("id"))})[0];
                ForexQuoteInfo fqInfo_local = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)forexquote.getLong("id"), (String)fxquote_local, (Date)now, null);
                plInfo.set("forexquote", (Object)forexquote.getLong("id"));
                plInfo.set("issuedate", (Object)forexquote.getDate("issuetime"));
                if (fqInfo_local != null) {
                    plInfo.set("fxquote_local", (Object)fqInfo_local.getFxquote());
                    Map<String, BigDecimal> infoMap = this.getExRateANDFloatPlAmtLocal(fqInfo_local, plInfo, floatPlAmt);
                    plInfo.set("exrate_local", (Object)infoMap.get("exrate_local"));
                    plInfo.set("floatpllocalamt", (Object)infoMap.get("floatPlAmt_local"));
                    plInfo.set("act_floatplamt", (Object)infoMap.get("floatPlAmt_local"));
                }
            }
        }
        RateSwapHelper.setAmtprecision((DynamicObject)plInfo, null);
        return plInfo;
    }

    private DynamicObject getCashFlow(Long tradeBillId) {
        DynamicObject cashflowCol = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"entrys.cfratefixdate,entrys.cfratefixindex,entrys.cfperioddays,entrys.cfuserate", (QFilter[])new QFilter[]{new QFilter("billid", "=", (Object)tradeBillId)});
        DynamicObjectCollection entrys = cashflowCol.getDynamicObjectCollection("entrys");
        DynamicObject cashFlowEntry = (DynamicObject)entrys.get(0);
        return cashFlowEntry;
    }

    private Map<String, BigDecimal> getExRateANDFloatPlAmtLocal(ForexQuoteInfo fqInfo_local, DynamicObject plInfo, BigDecimal floatPlAmt) {
        BigDecimal floatPlAmt_local;
        BigDecimal exrate_local;
        HashMap<String, BigDecimal> returnMap = new HashMap<String, BigDecimal>();
        if (plInfo.getDynamicObject("plcurrency").getString("number").equals(fqInfo_local.getFxquote().split("/")[0])) {
            exrate_local = fqInfo_local.getBuyPrice();
            floatPlAmt_local = floatPlAmt.multiply(exrate_local);
        } else {
            exrate_local = fqInfo_local.getSellPrice();
            floatPlAmt_local = floatPlAmt.divide(exrate_local, 10, RoundingMode.HALF_UP);
        }
        returnMap.put("exrate_local", exrate_local);
        returnMap.put("floatPlAmt_local", floatPlAmt_local);
        return returnMap;
    }

    private BigDecimal calRefrate_forwRateAgree(DynamicObject cashFlowEntry, DynamicObject bill, Date updateDate, DynamicObject yields) {
        Date cfratefixdate = cashFlowEntry.getDate("cfratefixdate");
        DynamicObject cfratefixindex = cashFlowEntry.getDynamicObject("cfratefixindex");
        String cfreferindexfreq = cfratefixindex.getString("term");
        if (updateDate.before(cfratefixdate)) {
            if (yields != null && EmptyUtil.isNoEmpty((Object)yields.getPkValue())) {
                Date nextDateByPayfreq = PayFrequeEnum.getNextDateByPayfreq((Date)cfratefixdate, (PayFrequeEnum)PayFrequeEnum.getEnumByName((String)RateTermEnum.getName((String)cfreferindexfreq)));
                return MarketDataHelper.yieldCurve((long)((Long)yields.getPkValue()), (YieldTypeEnum)YieldTypeEnum.ref, (ReturnValTypeEnum)ReturnValTypeEnum.furrate, (Date)updateDate, (Date)cfratefixdate, (Date)nextDateByPayfreq);
            }
            return BigDecimal.ZERO;
        }
        return cashFlowEntry.getBigDecimal("cfuserate");
    }

    private DynamicObject getYields(DynamicObject market, DynamicObject priceRule) {
        if (priceRule != null) {
            DynamicObject priceRuleInfo = TmcDataServiceHelper.loadSingle((Object)priceRule.getPkValue(), (String)"md_pricerule");
            DynamicObjectCollection yields = priceRuleInfo.getDynamicObjectCollection("yield");
            for (DynamicObject yield : yields) {
                DynamicObject yieldMarket = yield.getDynamicObject("market");
                if (!yieldMarket.getPkValue().equals(market.getPkValue()) || !YieldTypeEnum.ref.getValue().equals(yield.get("type"))) continue;
                return yield.getDynamicObject("yields");
            }
        }
        return null;
    }

    public BigDecimal calcFloatPlAmt_forwRateAgree(DynamicObject bill, DynamicObject cashflowEntry, BigDecimal referexrate) {
        BigDecimal contractrate = bill.getBigDecimal("contractrate");
        BigDecimal amount = bill.getBigDecimal("amount");
        int cfperioddays = cashflowEntry.getInt("cfperioddays");
        int basis = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)BasisEnum.getEnum((String)bill.getString("basis")));
        String tradeDirect = bill.getString("tradedirect");
        BigDecimal periodDaysDivYrbasis = BigDecimal.valueOf(cfperioddays).divide(BigDecimal.valueOf(basis), 10, RoundingMode.HALF_UP);
        BigDecimal floatPlAmt = referexrate.subtract(contractrate).multiply(amount).divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis);
        if ("advance".equals(bill.getString("payrule"))) {
            floatPlAmt = floatPlAmt.divide(referexrate.divide(Constants.ONE_HUNDRED).multiply(periodDaysDivYrbasis).add(BigDecimal.ONE), 10, RoundingMode.HALF_UP);
        }
        if ("buy".equals(tradeDirect)) {
            return floatPlAmt;
        }
        return floatPlAmt.negate();
    }

    private void validateBaseCurrency(Long localCurrencyId) {
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(TeBizResource.checkTradeCfgBaseCurrency());
        }
    }
}

