/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.business.opservice.trade.cfg.AbsTradeBillCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.StructDepositPlInfoCreator;
import kd.tmc.tm.common.enums.BizRecordDescEnum;

public class StructDepositCfgHandler
extends AbsTradeBillCfgHandler {
    @Override
    public void process(DynamicObject[] dataEntities) {
        this.billDataEntities = Arrays.stream(dataEntities).filter(v -> ProductTypeEnum.STRUCTDEPOSIT.getId().equals(v.getDynamicObject("protecttype").getString("id"))).collect(Collectors.toList());
        for (DynamicObject bill : this.billDataEntities) {
            this.cfg_structDeposit(bill, this.plInfos, this.bizRecords);
        }
        this.saveBills();
    }

    private void cfg_structDeposit(DynamicObject tradeBill, List<DynamicObject> plInfos, List<DynamicObject> bizRecords) {
        if (bizRecords != null) {
            DynamicObject bizRecord = this.createBizRecord(tradeBill);
            bizRecords.add(bizRecord);
        }
        DynamicObject plInfo = this.createPL(tradeBill);
        plInfos.add(plInfo);
    }

    private DynamicObject createBizRecord(DynamicObject tradeBill) {
        DynamicObject bizRecord = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        long bizRecordId = DBServiceHelper.genGlobalLongId();
        bizRecord.set("id", (Object)bizRecordId);
        bizRecord.set("createtime", (Object)new Date());
        bizRecord.set("tradebillid", (Object)tradeBill.getLong("id"));
        bizRecord.set("restamt", tradeBill.get("amount"));
        bizRecord.set("currency", tradeBill.get("currency"));
        bizRecord.set("lv", (Object)0);
        bizRecord.set("seqno", (Object)0);
        bizRecord.set("desc", (Object)BizRecordDescEnum.LIFECYCLE_INFO.getValue());
        bizRecord.set("bizdate", tradeBill.get("settledate"));
        return bizRecord;
    }

    private DynamicObject createPL(DynamicObject tradeBill) {
        return new StructDepositPlInfoCreator().createPL(tradeBill);
    }
}

