/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.common.resource.TeBizResource;

public class StructDepositPlInfoCreator {
    public DynamicObject createPL(DynamicObject tradeBill) {
        DynamicObject plInfo = BusinessDataServiceHelper.newDynamicObject((String)"tbo_plinfo");
        plInfo.set("tradebizdate", tradeBill.get("bizdate"));
        plInfo.set("createtime", (Object)new Date());
        plInfo.set("modifytime", (Object)new Date());
        plInfo.set("billstatus", (Object)TcBillStatusEnum.SAVE.getValue());
        plInfo.set("tradebill", (Object)tradeBill);
        DynamicObject org = tradeBill.getDynamicObject("org");
        plInfo.set("org", (Object)org);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_plinfo", (DynamicObject)plInfo, org != null ? org.getString("id") : null);
        plInfo.set("billno", EmptyUtil.isEmpty((String)billNo) ? tradeBill.get("billno") : billNo);
        plInfo.set("tradetype", tradeBill.get("protecttype"));
        plInfo.set("type", (Object)"FVC");
        plInfo.set("plcurrency", tradeBill.get("currency"));
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)((DynamicObject)tradeBill.get("org")).getPkValue()));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        this.validateBaseCurrency(localCurrencyId);
        plInfo.set("localcurrency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency"));
        plInfo.set("lastobsdate", tradeBill.get("zoneobsdate"));
        QFilter filterCashFlow = new QFilter("billid", "=", tradeBill.getPkValue());
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfpayamount,entrys.cfuserate", (QFilter[])new QFilter[]{filterCashFlow});
        DynamicObject cashFlow2 = this.getCashFlow(cashFlows, "2");
        DynamicObject cashFlow2_1 = (DynamicObject)((DynamicObjectCollection)cashFlow2.get("entrys")).get(0);
        plInfo.set("referexrate", cashFlow2_1.get("cfuserate"));
        plInfo.set("floatplamtcalcdate", (Object)new Date());
        BigDecimal amt = this.calcFloatPlAmt_structDeposit(tradeBill, plInfo);
        plInfo.set("floatplamt", (Object)amt);
        Map localPlResult = PlHelper.calcLocalInfo_PlInfo((DynamicObject)plInfo, (DynamicObject)tradeBill, (BigDecimal)amt);
        PlHelper.setValue((DynamicObject)plInfo, (Map)localPlResult);
        if (EmptyUtil.isNoEmpty((Object)localPlResult)) {
            DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
            if (priceRule == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613%s\u672a\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizBillEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradeBill.getString("number")}));
            }
            plInfo.set("forexquote", priceRule.get("forexquote"));
        }
        return plInfo;
    }

    private BigDecimal calcFloatPlAmt_structDeposit(DynamicObject bill, DynamicObject plInfo) {
        int days = 0;
        Date intDate = bill.getDate("intdate");
        Date calcDate = plInfo.getDate("floatplamtcalcdate");
        if (calcDate != null) {
            days = TcDateUtils.getDiffDays((Date)intDate, (Date)calcDate);
        }
        int yrBasis = TradeBusinessHelper.getBasis_YearDay((int)Calendar.getInstance().get(1), (BasisEnum)BasisEnum.valueOf((String)bill.getString("basis")));
        BigDecimal amt = bill.getBigDecimal("amount").multiply(plInfo.getBigDecimal("referexrate")).multiply(new BigDecimal(days)).divide(new BigDecimal("100").multiply(new BigDecimal(yrBasis)), 4);
        return amt;
    }

    private DynamicObject getCashFlow(DynamicObject[] cashFlows, String billNo) {
        for (DynamicObject cashFlow : cashFlows) {
            if (!billNo.equals(cashFlow.get("billno"))) continue;
            return cashFlow;
        }
        throw new KDBizException(TeBizResource.cashflowNotExist((String)billNo));
    }

    private void validateBaseCurrency(Long localCurrencyId) {
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(TeBizResource.checkTradeCfgBaseCurrency());
        }
    }
}

