/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.opservice.trade.cfg.AbsTradeBillCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.SwapPlInfoCreator;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.BizRecordDescEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.helper.CashFlowDAOHelper;

public class SwapCfgHandler
extends AbsTradeBillCfgHandler {
    @Override
    public void process(DynamicObject[] dataEntities) {
        this.billDataEntities = Arrays.stream(dataEntities).filter(v -> ProductTypeEnum.SWAP.getId().equals(v.getDynamicObject("protecttype").getString("id"))).collect(Collectors.toList());
        for (DynamicObject bill : this.billDataEntities) {
            this.cfg_swap(bill, this.plInfos, this.bizRecords);
        }
        this.saveBills();
    }

    private DynamicObject createBizRecord(DynamicObject bill) {
        DynamicObject bizRecord = TmcDataServiceHelper.newDynamicObject((String)"tm_bizrecord");
        long bizRecordId = DBServiceHelper.genGlobalLongId();
        bizRecord.set("id", (Object)bizRecordId);
        bizRecord.set("createtime", (Object)new Date());
        bizRecord.set("tradebillid", (Object)bill.getLong("id"));
        bizRecord.set("lv", (Object)0);
        bizRecord.set("seqno", (Object)0);
        bizRecord.set("desc", (Object)BizRecordDescEnum.ORIGINAL.getValue());
        bizRecord.set("bizdate", (Object)bill.getDate("adjustedenddate"));
        return bizRecord;
    }

    private void cfg_swap(DynamicObject bill, List<DynamicObject> plInfos, List<DynamicObject> bizRecords) {
        DynamicObject bizRecord = this.createBizRecord(bill);
        long bizRecordId = bizRecord.getLong("id");
        bizRecords.add(bizRecord);
        Object[] cashflowCol = CashFlowDAOHelper.loadAsc((Long)((Long)bill.getPkValue()), (String)"billno,cfbizrecordid,cftype,cfdirection,entrys.id");
        boolean isPayResetMulti = false;
        boolean isRecResetMulti = false;
        boolean isPayFirst = true;
        boolean isRecFirst = true;
        for (Object cashflow : cashflowCol) {
            cashflow.set("cfbizrecordid", (Object)bizRecordId);
            if (isPayFirst && "buy".equals(cashflow.getString("cfdirection")) && CashFlowTypeEnum.floatrate.getValue().equals(cashflow.getString("cftype")) && cashflow.getDynamicObjectCollection("entrys").size() > 1) {
                isPayResetMulti = true;
                isPayFirst = false;
            }
            if (!isRecFirst || !"sell".equals(cashflow.getString("cfdirection")) || !CashFlowTypeEnum.floatrate.getValue().equals(cashflow.getString("cftype")) || cashflow.getDynamicObjectCollection("entrys").size() <= 1) continue;
            isRecResetMulti = true;
            isRecFirst = false;
        }
        if (EmptyUtil.isNoEmpty((Object[])cashflowCol)) {
            this.cashFlows.addAll(Arrays.asList(cashflowCol));
        }
        DynamicObject plInfo = this.genPlInfo_Swap(bill);
        plInfo.set("bizrecord", (Object)bizRecordId);
        plInfos.add(plInfo);
        if (RateTypeEnum.rate_float.getValue().equals(bill.getString("ratetype")) && EmptyUtil.isNoEmpty((BigDecimal)bill.getBigDecimal("firstfixedrate"))) {
            if (isPayResetMulti) {
                bill.set("bizop", (Object)BizOperateEnum.ratecfg);
            } else {
                bill.set("bizop", (Object)BizOperateEnum.ratecfgWaitPay);
            }
        }
        if (RateTypeEnum.rate_float.getValue().equals(bill.getString("recratetype")) && EmptyUtil.isNoEmpty((BigDecimal)bill.getBigDecimal("recfirstfixedrate"))) {
            if (isRecResetMulti) {
                bill.set("recbizop", (Object)BizOperateEnum.ratecfg);
            } else {
                bill.set("recbizop", (Object)BizOperateEnum.ratecfgWaitPay);
            }
        }
    }

    private DynamicObject genPlInfo_Swap(DynamicObject tradeBill) {
        return new SwapPlInfoCreator().genPlInfo_Swap(tradeBill);
    }
}

