/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.opservice.trade.cfg;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.tm.business.opservice.trade.cfg.AbsTradeBillCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.ForexFwdCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.ForexOptionCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.ForexSpotCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.ForexSwapCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.FwRateAgreeCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.StructDepositCfgHandler;
import kd.tmc.tm.business.opservice.trade.cfg.SwapCfgHandler;
import kd.tmc.tm.common.resource.TeBizResource;

public class TradeBillCfgHandlerWrapper {
    Map<String, AbsTradeBillCfgHandler> type2Handlers = new HashMap<String, AbsTradeBillCfgHandler>(10);

    public TradeBillCfgHandlerWrapper() {
        this.type2Handlers.put(ProductTypeEnum.FOREXFORWARD.getId(), new ForexFwdCfgHandler());
        this.type2Handlers.put(ProductTypeEnum.FOREXOPTION.getId(), new ForexOptionCfgHandler());
        this.type2Handlers.put(ProductTypeEnum.FOREXSPOT.getId(), new ForexSpotCfgHandler());
        this.type2Handlers.put(ProductTypeEnum.FOREXSWAPS.getId(), new ForexSwapCfgHandler());
        this.type2Handlers.put(ProductTypeEnum.SWAP.getId(), new SwapCfgHandler());
        this.type2Handlers.put(ProductTypeEnum.STRUCTDEPOSIT.getId(), new StructDepositCfgHandler());
        this.type2Handlers.put(ProductTypeEnum.FORWRATEAGREE.getId(), new FwRateAgreeCfgHandler());
    }

    public void process(DynamicObject[] dataEntities) {
        Map<String, List<DynamicObject>> type2BillMap = Arrays.stream(dataEntities).filter(v -> v.getDynamicObject("protecttype") != null).collect(Collectors.groupingBy(v -> v.getDynamicObject("protecttype").getString("id")));
        for (Map.Entry<String, List<DynamicObject>> entry : type2BillMap.entrySet()) {
            AbsTradeBillCfgHandler handler = this.type2Handlers.get(entry.getKey());
            if (handler == null) {
                String billno = entry.getValue().get(0).getString("billno");
                throw new KDBizException(TeBizResource.dataException((String)billno));
            }
            handler.process(entry.getValue().toArray(new DynamicObject[0]));
        }
    }
}

