/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.IBizBillUnAuditService;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.CombTradeBillWriteBackHelper;
import kd.tmc.tm.common.helper.OptionCombBillWriteBackHelper;
import kd.tmc.tm.common.helper.PlHelper;

public abstract class AbstractBizBillUnAuditService
implements IBizBillUnAuditService {
    protected DynamicObject dealBizRecord(DynamicObject tradebill, DynamicObject bill) {
        String tip = ResManager.loadKDString((String)"\u5f53\u524d\u751f\u547d\u5468\u671f\u5355\u4e0d\u662f\u6700\u8fd1\u64cd\u4f5c\u3002", (String)"BusinessOpIsNotLast", (String)"tmc-tm-business", (Object[])new Object[0]);
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        DynamicObjectCollection entry = bizRecord.getDynamicObjectCollection("entryentity");
        if (((DynamicObject)entry.get(entry.size() - 1)).getLong("bizbillid") != bill.getLong("id")) {
            throw new KDBizException(tip);
        }
        QFilter filter_sub = new QFilter("srcbizbill", "=", (Object)bill.getLong("id"));
        DynamicObject subBizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"entryentity.bizop", (QFilter[])new QFilter[]{filter_sub});
        if (EmptyUtil.isNoEmpty((DynamicObject)subBizRecord) && subBizRecord.getDynamicObjectCollection("entryentity").size() > 0) {
            throw new KDBizException(tip);
        }
        boolean isSwapOp = false;
        String operate = bill.getString("operate");
        if (operate.indexOf("_n") > 0 || operate.indexOf("_f") > 0) {
            isSwapOp = true;
        }
        if (isSwapOp) {
            BigDecimal restAmt = ((DynamicObject)entry.get(entry.size() - 1)).getBigDecimal("amount").add(bizRecord.getBigDecimal("restamt"));
            bizRecord.set("restamt", (Object)restAmt);
            tradebill.set("bizop", (Object)this.getLastOp(tradebill, bill));
            QFilter filter = new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"));
            DynamicObject[] bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"restamt,swapdir,srcbizbill", (QFilter[])new QFilter[]{filter});
            BigDecimal amtNear = BigDecimal.ZERO;
            BigDecimal amtFar = BigDecimal.ZERO;
            for (DynamicObject oneRecord : bizRecords) {
                if (oneRecord.getLong("srcbizbill") == bill.getLong("id")) continue;
                if (oneRecord.getLong("id") == bizRecord.getLong("id")) {
                    if ("isnear".equals(oneRecord.getString("swapdir"))) {
                        amtNear = amtNear.add(restAmt);
                    }
                    if (!"isfar".equals(oneRecord.getString("swapdir"))) continue;
                    amtFar = amtFar.add(restAmt);
                    continue;
                }
                if ("isnear".equals(oneRecord.getString("swapdir"))) {
                    amtNear = amtNear.add(oneRecord.getBigDecimal("restamt"));
                }
                if (!"isfar".equals(oneRecord.getString("swapdir"))) continue;
                amtFar = amtFar.add(oneRecord.getBigDecimal("restamt"));
            }
            tradebill.set("bizrestamt", (Object)amtNear);
            tradebill.set("farbizrestamt", (Object)amtFar);
            if (TcBillStatusEnum.FINISH.getValue().equals(tradebill.getString("billstatus"))) {
                tradebill.set("billstatus", (Object)TcBillStatusEnum.SURVIVAL.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
            if (tradebill.getString("billstatus").equals(TcBillStatusEnum.SURVIVAL.getValue())) {
                CombTradeBillWriteBackHelper.survivalWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
            }
            entry.remove(entry.size() - 1);
        } else {
            DynamicObject[] bizRecords;
            BigDecimal restAmt = ((DynamicObject)entry.get(entry.size() - 1)).getBigDecimal("amount").add(bizRecord.getBigDecimal("restamt"));
            bizRecord.set("restamt", (Object)restAmt);
            tradebill.set("bizop", (Object)this.getLastOp(tradebill, bill));
            BigDecimal amt = BigDecimal.ZERO;
            QFilter filter = new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"));
            for (DynamicObject oneRecord : bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)"restamt,srcbizbill", (QFilter[])new QFilter[]{filter})) {
                if (oneRecord.getLong("srcbizbill") == bill.getLong("id")) continue;
                amt = oneRecord.getLong("id") == bizRecord.getLong("id") ? amt.add(restAmt) : amt.add(oneRecord.getBigDecimal("restamt"));
            }
            tradebill.set("bizrestamt", (Object)amt);
            if (TcBillStatusEnum.FINISH.getValue().equals(tradebill.getString("billstatus"))) {
                tradebill.set("billstatus", (Object)TcBillStatusEnum.SURVIVAL.getValue());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
            if (tradebill.getString("billstatus").equals(TcBillStatusEnum.SURVIVAL.getValue())) {
                CombTradeBillWriteBackHelper.survivalWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
            }
            entry.remove(entry.size() - 1);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        return bizRecord;
    }

    protected String getLastOp(DynamicObject tradebill, DynamicObject bill) {
        DynamicObject[] bizBills;
        QFilter filter = new QFilter("tradebill", "=", (Object)tradebill.getLong("id"));
        QFilter filter_status = new QFilter("billstatus", "=", (Object)TcBillStatusEnum.AUDIT.getValue());
        for (DynamicObject bizBill : bizBills = TmcDataServiceHelper.load((String)"tm_businessbill", (String)"id,operate", (QFilter[])new QFilter[]{filter, filter_status}, (String)"auditdate desc")) {
            if (bizBill.getLong("id") == bill.getLong("id")) continue;
            return bizBill.getString("operate");
        }
        return null;
    }

    protected void biz_common(DynamicObject tradebill, DynamicObject bill) {
        this.dealCashFlow(tradebill, bill);
        DynamicObject bizRecord = this.dealBizRecord(tradebill, bill);
        QFilter filter = new QFilter("srcbizbill", "=", (Object)bill.getLong("id"));
        DeleteServiceHelper.delete((String)"tm_bizrecord", (QFilter[])new QFilter[]{filter});
        this.deletePlBizRecord(tradebill, bill, bizRecord);
        OptionCombBillWriteBackHelper.survivalWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
    }

    protected void dealCashFlow(DynamicObject tradebill, DynamicObject bill) {
        QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
        QFilter filter_bak = new QFilter("cfbizbillid", "=", bill.getPkValue());
        DynamicObject[] cashflow = CashFlowHelper.returnCashFlow((QFilter[])new QFilter[]{filter, filter_bak});
        DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{filter});
        SaveServiceHelper.save((DynamicObject[])cashflow);
        DeleteServiceHelper.delete((String)"tm_cashflow_bak", (QFilter[])new QFilter[]{filter, filter_bak});
    }

    protected void deletePlBizRecord(DynamicObject tradebill, DynamicObject bill, DynamicObject bizRecord) {
        Long bizRecordId = bill.getLong("bizrecordid");
        QFilter filter = new QFilter("tradebill", "=", (Object)tradebill.getLong("id"));
        QFilter filter_bizrecord = new QFilter("bizrecord", "=", (Object)bizRecordId);
        DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"entrys.seq,entrys.bizdate,entrys.settledate,entrys.biztype,entrys.plamt,entrys.pllocalamt,entrys.bizbillid,billno,tradebill,org,tradetype,type,localcurrency,plamt_sum,pllocalamt_sum,floatplamt,floatpllocalamt,forfloatplamt,forfloatpllocalamt,referexrate,forreferexrate,plcurrency,plcurrency_s,updatedate,forexquote,fxquotetype,fxquote_local,exrate_local,floatplamt,floatpllocalamt,voucher_pl,act_floatplamt,bizrestamt,exrate,buycurrency,buyamount,sellamount,standardcurrency", (QFilter[])new QFilter[]{filter, filter_bizrecord});
        plInfo.set("bizrestamt", (Object)bizRecord.getBigDecimal("restamt"));
        PlHelper.calcPLBuySellAmount((DynamicObject)tradebill, (DynamicObject)plInfo);
        if (EmptyUtil.isNoEmpty((DynamicObject)plInfo)) {
            DynamicObjectCollection entrys = plInfo.getDynamicObjectCollection("entrys");
            BigDecimal pllocalamt_sum = plInfo.getBigDecimal("pllocalamt_sum");
            for (DynamicObject one : entrys) {
                Long bizbillid = one.getLong("bizbillid");
                Long id = bill.getLong("id");
                if (bizbillid.longValue() != id.longValue()) continue;
                pllocalamt_sum = pllocalamt_sum.subtract(one.getBigDecimal("pllocalamt"));
                entrys.remove((Object)one);
                break;
            }
            plInfo.set("pllocalamt_sum", (Object)pllocalamt_sum);
            DynamicObject protectType = tradebill.getDynamicObject("protecttype");
            if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) || ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id"))) {
                plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
                plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
                plInfo.set("voucher_pl", (Object)BigDecimal.ZERO);
                plInfo.set("act_floatplamt", (Object)BigDecimal.ZERO);
            }
            if (ProductTypeEnum.SWAP.getId().equals(protectType.getString("id"))) {
                plInfo.set("floatplamt", (Object)BigDecimal.ZERO);
                plInfo.set("floatpllocalamt", (Object)BigDecimal.ZERO);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
        }
    }

    protected void deferOrMaudate(DynamicObject tradebill, DynamicObject bill) {
        this.dealCashFlow(tradebill, bill);
        DynamicObject bizRecord = this.dealBizRecord(tradebill, bill);
        QFilter filter = new QFilter("srcbizbill", "=", (Object)bill.getLong("id"));
        DeleteServiceHelper.delete((String)"tm_bizrecord", (QFilter[])new QFilter[]{filter});
        this.deletePlBizRecord(tradebill, bill, bizRecord);
        DeleteServiceHelper.delete((String)"tbo_plinfo", (QFilter[])new QFilter[]{filter});
        DeleteServiceHelper.delete((String)"tbo_plinfo_history", (QFilter[])new QFilter[]{filter});
    }
}

