/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.forex;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ForexLifecycleService {
    public static void deal(DynamicObject tradeBill, boolean isSaveTradeBill) {
        String entityName = tradeBill.getDataEntityType().getName();
        if (!"tm_forex_forward".equals(entityName) && !"tm_forex_swaps".equals(entityName)) {
            return;
        }
        if ("tm_forex_forward".equals(entityName)) {
            ForexLifecycleService.deal_forward(tradeBill);
        }
        if ("tm_forex_swaps".equals(entityName)) {
            ForexLifecycleService.deal_swaps(tradeBill);
        }
        if (isSaveTradeBill) {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradeBill});
        }
    }

    private static void deal_forward(DynamicObject tradeBill) {
        DynamicObjectCollection lifecycles = tradeBill.getDynamicObjectCollection("lifecycle");
        lifecycles.clear();
        ArrayList<String> selectProperties = new ArrayList<String>();
        selectProperties.add("id");
        selectProperties.add("bizdate");
        selectProperties.add("enddate");
        selectProperties.add("currency");
        selectProperties.add("exrate");
        selectProperties.add("restamt");
        Object[] bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", tradeBill.get("id"))}, (String)"lv,seqno");
        if (EmptyUtil.isEmpty((Object[])bizRecords)) {
            ForexLifecycleService.init_forward(tradeBill);
        } else {
            int seq = 0;
            for (Object bizRecord : bizRecords) {
                DynamicObject lifecycle = lifecycles.addNew();
                lifecycle.set("seq", (Object)(++seq));
                lifecycle.set("isdaterange_entry", (Object)(EmptyUtil.isEmpty((Object)bizRecord.get("enddate")) ? "0" : "1"));
                lifecycle.set("currency_entry", bizRecord.get("currency"));
                lifecycle.set("amount_entry", (Object)bizRecord.getBigDecimal("restamt"));
                lifecycle.set("rate_entry", bizRecord.get("exrate"));
                if (EmptyUtil.isNoEmpty((Object)bizRecord.get("enddate"))) {
                    lifecycle.set("startdate_entry", bizRecord.get("bizdate"));
                } else {
                    lifecycle.set("adjdeliverydate_entry", bizRecord.get("bizdate"));
                }
                lifecycle.set("enddate_entry", bizRecord.get("enddate"));
            }
        }
    }

    private static void deal_swaps(DynamicObject tradeBill) {
        DynamicObjectCollection lifecycles = tradeBill.getDynamicObjectCollection("lifecycle");
        lifecycles.clear();
        ArrayList<String> selectProperties = new ArrayList<String>();
        selectProperties.add("id");
        selectProperties.add("swapdir");
        selectProperties.add("bizdate");
        selectProperties.add("currency");
        selectProperties.add("exrate");
        selectProperties.add("restamt");
        Object[] bizRecords = TmcDataServiceHelper.load((String)"tm_bizrecord", (String)String.join((CharSequence)",", selectProperties), (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", tradeBill.get("id"))}, (String)"swapdir desc,lv,seqno");
        if (EmptyUtil.isEmpty((Object[])bizRecords)) {
            ForexLifecycleService.init_swaps(tradeBill);
        } else {
            int seq = 0;
            for (Object bizRecord : bizRecords) {
                DynamicObject lifecycle = lifecycles.addNew();
                lifecycle.set("seq", (Object)(++seq));
                lifecycle.set("swapdir_entry", bizRecord.get("swapdir"));
                lifecycle.set("currency_entry", bizRecord.get("currency"));
                lifecycle.set("amount_entry", bizRecord.get("restamt"));
                lifecycle.set("rate_entry", bizRecord.get("exrate"));
                lifecycle.set("adjdeliverydate_entry", bizRecord.get("bizdate"));
            }
        }
    }

    public static void init_forward(DynamicObject tradeBill) {
        DynamicObjectCollection lifecycles = tradeBill.getDynamicObjectCollection("lifecycle");
        lifecycles.clear();
        DynamicObject lifecycle = lifecycles.addNew();
        lifecycle.set("seq", (Object)1);
        lifecycle.set("isdaterange_entry", tradeBill.get("isdaterange"));
        lifecycle.set("currency_entry", tradeBill.get("currency"));
        lifecycle.set("amount_entry", tradeBill.get("amount"));
        lifecycle.set("rate_entry", tradeBill.get("spotrate"));
        if (lifecycle.getBoolean("isdaterange_entry")) {
            lifecycle.set("startdate_entry", tradeBill.get("adjsettledate_start"));
            lifecycle.set("enddate_entry", tradeBill.get("adjsettledate_end"));
        } else {
            lifecycle.set("adjdeliverydate_entry", tradeBill.get("adjustsettledate"));
        }
    }

    public static void init_swaps(DynamicObject tradeBill) {
        DynamicObjectCollection lifecycles = tradeBill.getDynamicObjectCollection("lifecycle");
        lifecycles.clear();
        DynamicObject near = lifecycles.addNew();
        near.set("seq", (Object)1);
        near.set("swapdir_entry", (Object)"isnear");
        near.set("currency_entry", tradeBill.get("currency"));
        near.set("amount_entry", tradeBill.get("amount"));
        near.set("rate_entry", tradeBill.get("spotrate"));
        near.set("adjdeliverydate_entry", tradeBill.get("adjustsettledate"));
        DynamicObject far = lifecycles.addNew();
        far.set("seq", (Object)2);
        far.set("swapdir_entry", (Object)"isfar");
        far.set("currency_entry", tradeBill.get("currency"));
        far.set("amount_entry", tradeBill.get("amount"));
        far.set("rate_entry", tradeBill.get("forwrate"));
        far.set("adjdeliverydate_entry", tradeBill.get("adjustsettledate_far"));
    }
}

