/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.forex;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillSettleService;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.SettleSettingEnum;
import kd.tmc.tm.common.enums.SettleSettingModuleEnum;
import kd.tmc.tm.common.enums.SettleSettingOpEnum;

public class ForexOptionsBizBillSettleService
extends AbstractBizBillSettleService {
    @Override
    public void settle(DynamicObject bizBill, Map<Long, DynamicObject> settlementSettingCache) throws KDException {
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case exercise: {
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    Optional<DynamicObject> settleSetOptional;
                    boolean isGenExchangeBill = false;
                    DynamicObject settleSetBill = this.querySettlementSetting(settlementSettingCache, bizBill.getDynamicObject("org").getLong("id"));
                    if (settleSetBill != null && (settleSetOptional = settleSetBill.getDynamicObjectCollection("forexsetting").stream().filter(o -> SettleSettingModuleEnum.BIZBILL.getValue().equals(o.get("forex_module")) && SettleSettingOpEnum.EXERCISE.getValue().equals(o.get("forex_op"))).findAny()).isPresent() && SettleSettingEnum.EXCHANGE_BILL.getValue().equals(settleSetOptional.get().getString("forex_setting"))) {
                        isGenExchangeBill = true;
                    }
                    if (isGenExchangeBill) {
                        this.genExchangeBill(bizBill);
                        break;
                    }
                    this.genPayBill(bizBill, null);
                    this.genRecBill(bizBill, null);
                    break;
                }
                this.genPayOrRecBill_bySettleAmount(bizBill);
                break;
            }
            case flat: {
                if (TradeDirectionEnum.buy.getValue().equals(tradeBill.getString("tradedirect"))) {
                    this.genRecBill(bizBill, null);
                    break;
                }
                this.genPayBill(bizBill, null);
                break;
            }
        }
    }
}

