/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.forex;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;

public class ForexSpotBizBillAuditService
extends AbstractBizBillAuditService {
    private String entityName = "tm_forex";

    @Override
    public String getBizBillTypeId(String op) {
        if (BizOperateEnum.expiredey.getValue().equals(op)) {
            return BizBillTypeEnum.c_expiredey.getId();
        }
        if (BizOperateEnum.flat.getValue().equals(op)) {
            return BizBillTypeEnum.f_flat.getId();
        }
        return null;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        if (BizOperateEnum.expiredey.getValue().equals(op) || BizOperateEnum.flat.getValue().equals(op)) {
            DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus,bizrestamt,source");
            String billstatus = bill.getString("billstatus");
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case flat: {
                this.flat_Forex(tradebill, bill);
                break;
            }
            case expiredey: {
                this.expiredDey_Forex(tradebill, bill);
            }
        }
    }

    protected void flat_Forex(DynamicObject tradebill, DynamicObject bill) {
        BigDecimal amt_new;
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        ArrayList<DynamicObject> saveCol = new ArrayList<DynamicObject>(2);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        this.splitCashFlow(tradebill, bill, "buy", saveCol, delCol, writeBackCol_buy, false);
        this.splitCashFlow(tradebill, bill, "sell", saveCol, delCol, writeBackCol_sell, false);
        for (DynamicObject cashflow : writeBackCol_buy) {
            amt_new = bill.getBigDecimal("restamt1").multiply(buyAmtDir);
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        for (DynamicObject cashflow : writeBackCol_sell) {
            amt_new = bill.getBigDecimal("restamt2").multiply(buyAmtDir.negate());
            cashflow.set("cfpayamount", (Object)amt_new);
        }
        if (saveCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])saveCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.flat.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.flat.getValue(), bizRecord);
    }

    protected void expiredDey_Forex(DynamicObject tradebill, DynamicObject bill) {
        QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter_cashflow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        HashSet<Long> delCol = new HashSet<Long>(2);
        ArrayList<DynamicObject> updateCol = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> insertCol = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_buy = new ArrayList<DynamicObject>(2);
        ArrayList<DynamicObject> writeBackCol_sell = new ArrayList<DynamicObject>(2);
        BigDecimal buyAmtDir = BigDecimal.ONE;
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            buyAmtDir = buyAmtDir.negate();
        }
        ArrayList<DynamicObject> buyCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "buy", buyCol, delCol, writeBackCol_buy, true);
        for (DynamicObject cashflow : writeBackCol_buy) {
            BigDecimal amt_new = bill.getBigDecimal("restamt1");
            cashflow.set("cfpayamount", (Object)amt_new.multiply(buyAmtDir));
        }
        DynamicObject newCashflowBuy = this.createCashFlow_Forex(tradebill, "buy", tradebill.getDynamicObject("currency"), bill.getBigDecimal("bizamt1").multiply(buyAmtDir), bill.getDate("deliverydate"), tradebill.getBigDecimal("spotrate"), null, Boolean.TRUE, null);
        insertCol.add(newCashflowBuy);
        buyCol.add(newCashflowBuy);
        this.reSetCashFlowNo(buyCol);
        buyCol.remove(newCashflowBuy);
        updateCol.addAll(buyCol);
        ArrayList<DynamicObject> sellCol = new ArrayList<DynamicObject>(10);
        this.splitCashFlow(tradebill, bill, "sell", sellCol, delCol, writeBackCol_sell, true);
        for (DynamicObject cashflow : writeBackCol_sell) {
            BigDecimal amt_new = bill.getBigDecimal("restamt2");
            cashflow.set("cfpayamount", (Object)amt_new.multiply(buyAmtDir.negate()));
        }
        DynamicObject newCashflowSell = this.createCashFlow_Forex(tradebill, "sell", tradebill.getDynamicObject("sellcurrency"), bill.getBigDecimal("bizamt2").multiply(buyAmtDir.negate()), bill.getDate("deliverydate"), tradebill.getBigDecimal("spotrate"), null, Boolean.TRUE, null);
        insertCol.add(newCashflowSell);
        sellCol.add(newCashflowSell);
        this.reSetCashFlowNo(sellCol);
        sellCol.remove(newCashflowSell);
        updateCol.addAll(sellCol);
        if (insertCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])insertCol.toArray(new DynamicObject[0]));
        }
        if (updateCol.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])updateCol.toArray(new DynamicObject[0]));
        }
        if (delCol.size() > 0) {
            DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])new QFilter[]{new QFilter("id", "in", delCol)});
        }
        DynamicObject bizRecord = this.genBizRecord(bill, BizOperateEnum.expiredey.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
        this.dealTradeBill_Forex(tradebill, bill, BizOperateEnum.expiredey.getValue(), bizRecord);
    }
}

