/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.other;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.opservice.cashflow.CashFlowBuildAndSaveService;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.CombTradeBillWriteBackHelper;

public class StructDepositBizBillAuditService
extends AbstractBizBillAuditService {
    private String entityName = "tm_structdeposit";

    @Override
    public String getBizBillTypeId(String op) {
        if (BizOperateEnum.ratecfg.getValue().equals(op)) {
            return BizBillTypeEnum.rate.getId();
        }
        if (BizOperateEnum.pay.getValue().equals(op)) {
            return BizBillTypeEnum.pay.getId();
        }
        return null;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus");
        String billstatus = bill.getString("billstatus");
        if (BizOperateEnum.ratecfg.getValue().equals(op)) {
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            QFilter filter = new QFilter("operate", "=", (Object)BizOperateEnum.ratecfg.getValue());
            filter.and(new QFilter("billstatus", ">=", (Object)TcBillStatusEnum.AUDIT.getValue()));
            Object[] bills = TmcBotpHelper.getTargetBills((String)this.entityName, (Object)id, (String)"tm_businessbill", (QFilter)filter);
            if (EmptyUtil.isNoEmpty((Object[])bills)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u4e14\u6ca1\u6709\u5229\u7387\u786e\u8ba4\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival_NotRateCfg", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
        }
        if (BizOperateEnum.pay.getValue().equals(op)) {
            DynamicObject[] cashflows;
            QFilter filter_cashflow = new QFilter("billid", "=", bill.getPkValue());
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            for (DynamicObject info : cashflows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"entrys.cfisratecfg", (QFilter[])new QFilter[]{filter_cashflow})) {
                DynamicObjectCollection entrys = info.getDynamicObjectCollection("entrys");
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) continue;
                for (DynamicObject entry : entrys) {
                    if (entry.getBoolean("cfisratecfg")) continue;
                    result.put("flag", Boolean.FALSE);
                    result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5df2\u5229\u7387\u786e\u8ba4\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5355\u636e\u3002", (String)"Check_RateCfg", (String)"tmc-tm-business", (Object[])new Object[0]));
                    return result;
                }
            }
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case ratecfg: {
                this.rateCfg_structDeposit(tradebill, bill);
                break;
            }
            case pay: {
                this.pay_structDeposit(tradebill, bill);
            }
        }
    }

    protected void rateCfg_structDeposit(DynamicObject sourceTradeBill, DynamicObject bill) {
        QFilter filterCashFlow = new QFilter("billid", "=", sourceTradeBill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filterCashFlow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        Date redeemDay = bill.getDate("redeemday");
        DynamicObject[] originalCashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,entrys.cfresetpredictrate,cfunadjenddate,cfadjenddate", (QFilter[])new QFilter[]{filterCashFlow});
        BigDecimal resetPredictRate = BigDecimal.ZERO;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (DynamicObject cashFlow : originalCashFlows) {
            if (!"2".equals(cashFlow.getString("billno"))) continue;
            DynamicObject resetRow = (DynamicObject)((DynamicObjectCollection)cashFlow.get("entrys")).get(0);
            resetPredictRate = resetRow.getBigDecimal("cfresetpredictrate");
            if (EmptyUtil.isNoEmpty((Object)resetRow.getDate("cfunadjenddate"))) {
                paramMap.put("cfunadjenddate", TcDateUtils.formatString((Date)resetRow.getDate("cfunadjenddate"), (String)"yyyy-MM-dd"));
            }
            if (!EmptyUtil.isNoEmpty((Object)resetRow.getDate("cfadjenddate"))) continue;
            paramMap.put("cfadjenddate", TcDateUtils.formatString((Date)resetRow.getDate("cfadjenddate"), (String)"yyyy-MM-dd"));
        }
        if (EmptyUtil.isNoEmpty((Object)redeemDay)) {
            paramMap.put("redeemday", TcDateUtils.formatString((Date)redeemDay, (String)"yyyy-MM-dd"));
        }
        paramMap.put("bizdate", TcDateUtils.formatString((Date)bill.getDate("bizdate"), (String)"yyyy-MM-dd"));
        paramMap.put("rate", bill.getBigDecimal("rate").toString());
        paramMap.put("rate_cfg_struct_deposit", String.valueOf(true));
        paramMap.put("cfresetpredictrate", resetPredictRate.toString());
        DynamicObjectCollection cashFlows = new CashFlowBuildAndSaveService().builderCashFlow(sourceTradeBill, paramMap);
        QFilter filter = new QFilter("billid", "=", (Object)sourceTradeBill.getLong("id"));
        DeleteServiceHelper.delete((String)"tm_cashflow", (QFilter[])filter.toArray());
        SaveServiceHelper.save((DynamicObject[])((DynamicObject[])cashFlows.toArray((Object[])new DynamicObject[cashFlows.size()])));
        QFilter filterBizRecord = new QFilter("tradebillid", "=", sourceTradeBill.getPkValue());
        DynamicObject bizRecord = BusinessDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,exrate,bizdate,entryentity.seq,entryentity.bizop,entryentity.opdate", (QFilter[])new QFilter[]{filterBizRecord});
        bizRecord.set("exrate", bill.get("rate"));
        if (EmptyUtil.isNoEmpty((Object)redeemDay)) {
            bizRecord.set("bizdate", bill.get("redeemday"));
        } else {
            bizRecord.set("bizdate", sourceTradeBill.get("settledate"));
        }
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)bizRecord.get("entryentity");
        int seq = entryEntity.size() + 1;
        DynamicObject row1 = entryEntity.addNew();
        row1.set("seq", (Object)seq);
        row1.set("bizop", (Object)BizOperateEnum.ratecfg.getValue());
        row1.set("opdate", bill.get("bizdate"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        sourceTradeBill.set("bizop", (Object)BizOperateEnum.ratecfg.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceTradeBill});
    }

    protected void pay_structDeposit(DynamicObject sourceTradeBill, DynamicObject bill) {
        QFilter filterCashFlow = new QFilter("billid", "=", sourceTradeBill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filterCashFlow}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfpaydate,cfpayamount,cfispay,cfinterest", (QFilter[])new QFilter[]{filterCashFlow});
        Date plSettleDate = bill.getDate("plsettledate");
        for (DynamicObject cashFlow : cashFlows) {
            if ("2".equals(cashFlow.getString("billno")) || "3".equals(cashFlow.getString("billno"))) {
                cashFlow.set("cfispay", (Object)Boolean.TRUE);
                cashFlow.set("cfpaydate", (Object)plSettleDate);
            }
            if (!"2".equals(cashFlow.getString("billno"))) continue;
            cashFlow.set("cfpayamount", bill.get("restamt2"));
            cashFlow.set("cfinterest", bill.get("restamt2"));
        }
        SaveServiceHelper.save((DynamicObject[])cashFlows);
        QFilter filterBizRecord = new QFilter("tradebillid", "=", sourceTradeBill.getPkValue());
        DynamicObject bizRecord = BusinessDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,restamt,entryentity.bizop,entryentity.opdate,entryentity.amount,entryentity.seq", (QFilter[])new QFilter[]{filterBizRecord});
        bizRecord.set("restamt", (Object)BigDecimal.ZERO);
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)bizRecord.get("entryentity");
        int seq = entryEntity.size() + 1;
        DynamicObject row2 = entryEntity.addNew();
        row2.set("seq", (Object)seq);
        row2.set("bizop", (Object)BizOperateEnum.pay.getValue());
        row2.set("opdate", bill.get("bizdate"));
        row2.set("amount", bill.get("settleamount"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filterPlInfo = new QFilter("tradebill", "=", sourceTradeBill.getPkValue());
        DynamicObject plInfo = BusinessDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"id,floatplamt,floatpllocalamt,entrys.bizbillid,entrys.biztype,entrys.bizdate,plamt_sum,pllocalamt_sum,entrys.settledate,entrys.bizbillplcurrency,entrys.plamt,entrys.pllocalamt", (QFilter[])new QFilter[]{filterPlInfo});
        DynamicObjectCollection entrys = (DynamicObjectCollection)plInfo.get("entrys");
        DynamicObject plInfoEntryRow = entrys.addNew();
        plInfoEntryRow.set("bizbillid", (Object)bill.getLong("id"));
        plInfoEntryRow.set("biztype", (Object)BizOperateEnum.pay.getValue());
        plInfoEntryRow.set("bizdate", bill.get("bizdate"));
        plInfoEntryRow.set("settledate", bill.get("plsettledate"));
        plInfoEntryRow.set("plamt", bill.get("plamt"));
        plInfoEntryRow.set("bizbillplcurrency", bill.get("plcurrency"));
        DynamicObject baseCurrency = bill.getDynamicObject("basecurrency");
        DynamicObject plCurrency = bill.getDynamicObject("plcurrency");
        if (baseCurrency != null && plCurrency != null && baseCurrency.getString("number").equals(plCurrency.getString("number"))) {
            plInfoEntryRow.set("pllocalamt", (Object)bill.getBigDecimal("plamt"));
        } else {
            plInfoEntryRow.set("pllocalamt", (Object)bill.getBigDecimal("baseplamt"));
        }
        plInfo.set("pllocalamt_sum", plInfoEntryRow.get("pllocalamt"));
        plInfo.set("floatplamt", null);
        plInfo.set("floatpllocalamt", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
        sourceTradeBill.set("bizop", (Object)BizOperateEnum.pay.getValue());
        sourceTradeBill.set("bizrestamt", (Object)BigDecimal.ZERO);
        sourceTradeBill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceTradeBill});
        if (sourceTradeBill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            CombTradeBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{sourceTradeBill});
        }
    }
}

