/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.other;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillUnAuditService;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.helper.CombTradeBillWriteBackHelper;

public class StructDepositBizBillUnAuditService
extends AbstractBizBillUnAuditService {
    @Override
    public void unAudit(DynamicObject tradeBill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case ratecfg: {
                this.rateCfg(tradeBill, bill);
                break;
            }
            case pay: {
                this.pay(tradeBill, bill);
                break;
            }
        }
    }

    private void rateCfg(DynamicObject sourceTradeBill, DynamicObject bill) {
        this.dealCashFlow(sourceTradeBill, bill);
        QFilter filterBizRecord = new QFilter("tradebillid", "=", sourceTradeBill.getPkValue());
        DynamicObject bizRecord = BusinessDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,exrate,bizdate,entryentity.seq,entryentity.bizop,entryentity.opdate", (QFilter[])new QFilter[]{filterBizRecord});
        bizRecord.set("exrate", null);
        bizRecord.set("bizdate", sourceTradeBill.get("settledate"));
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)bizRecord.get("entryentity");
        entryEntity.clear();
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        sourceTradeBill.set("bizop", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceTradeBill});
    }

    private void pay(DynamicObject sourceTradeBill, DynamicObject bill) {
        this.dealCashFlow(sourceTradeBill, bill);
        QFilter filter = new QFilter("tradebillid", "=", sourceTradeBill.getPkValue());
        DynamicObject bizRecord = BusinessDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id,restamt,entryentity,entryentity.bizop", (QFilter[])new QFilter[]{filter});
        bizRecord.set("restamt", sourceTradeBill.get("amount"));
        DynamicObjectCollection entryEntity = (DynamicObjectCollection)bizRecord.get("entryentity");
        entryEntity.removeIf(row -> "pay".equals(row.get("bizop")));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        QFilter filterPlInfo = new QFilter("tradebill", "=", sourceTradeBill.getPkValue());
        DynamicObject plInfo = BusinessDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"id,floatplamt,floatpllocalamt,plamt_sum,pllocalamt_sum,entrys", (QFilter[])new QFilter[]{filterPlInfo});
        DynamicObjectCollection entrys = (DynamicObjectCollection)plInfo.get("entrys");
        entrys.clear();
        plInfo.set("pllocalamt_sum", null);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plInfo});
        sourceTradeBill.set("bizop", (Object)BizOperateEnum.ratecfg.getValue());
        sourceTradeBill.set("bizrestamt", sourceTradeBill.get("amount"));
        sourceTradeBill.set("billstatus", (Object)TcBillStatusEnum.SURVIVAL.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourceTradeBill});
        if (sourceTradeBill.getString("billstatus").equals(TcBillStatusEnum.SURVIVAL.getValue())) {
            CombTradeBillWriteBackHelper.survivalWriteBack((DynamicObject[])new DynamicObject[]{sourceTradeBill});
        }
    }
}

