/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.rate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillAuditService;
import kd.tmc.tm.common.enums.BizBillTypeEnum;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.ConfigPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.helper.CashFlowHelper;
import kd.tmc.tm.common.helper.CombTradeBillWriteBackHelper;
import kd.tmc.tm.common.helper.RateSwapHelper;

public class RateSwapBizBillAuditService
extends AbstractBizBillAuditService {
    private static final Log logger = LogFactory.getLog(RateSwapBizBillAuditService.class);
    private String entityName = "tm_rateswap";

    @Override
    public String getBizBillTypeId(String op) {
        if (BizOperateEnum.ratecfg.getValue().equals(op)) {
            return BizBillTypeEnum.rateswap_rate.getId();
        }
        if (BizOperateEnum.interestpay.getValue().equals(op) || BizOperateEnum.capitalpay.getValue().equals(op)) {
            return BizBillTypeEnum.rateswap_pay.getId();
        }
        return null;
    }

    @Override
    public Map<String, Object> verifyBeforeDo(Long id, String op) {
        Map data;
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)this.entityName, (String)"billstatus,rateswaptype,ratetype,recratetype");
        String billstatus = bill.getString("billstatus");
        if (BizOperateEnum.ratecfg.getValue().equals(op)) {
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            if (RateTypeEnum.rate_fixed.getValue().equals(bill.getString("ratetype")) && RateTypeEnum.rate_fixed.getValue().equals(bill.getString("recratetype"))) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u652f\u4ed8\u4fe1\u606f\u4e0e\u6536\u53d6\u4fe1\u606f\u5747\u4e3a\u56fa\u5b9a\u5229\u7387\uff0c\u65e0\u9700\u8fdb\u884c\u5229\u7387\u786e\u8ba4\u3002", (String)"RateCfgIsNotNeed_RateSwap", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            data = RateSwapHelper.getCashFlowToRateCfg((Long)id);
            if (EmptyUtil.isNoEmpty(data.get("error"))) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", data.get("error"));
                return result;
            }
        }
        if (BizOperateEnum.interestpay.getValue().equals(op)) {
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            data = RateSwapHelper.getCashFlowToInterestPay((Long)id);
            if (EmptyUtil.isNoEmpty(data.get("error"))) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", data.get("error"));
                return result;
            }
        }
        if (BizOperateEnum.capitalpay.getValue().equals(op)) {
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(billstatus)) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\u8fdb\u884c\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"Check_Survival", (String)"tmc-tm-business", (Object[])new Object[0]));
                return result;
            }
            data = RateSwapHelper.getCashFlowToCapitalPay((Long)id);
            if (EmptyUtil.isNoEmpty(data.get("error"))) {
                result.put("flag", Boolean.FALSE);
                result.put("tip", data.get("error"));
                return result;
            }
        }
        this.checkUnAuditDownBizBill(this.entityName, id, result);
        return result;
    }

    @Override
    public void auditBusinessBill(DynamicObject tradebill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case ratecfg: {
                this.rateCfg_rateSwap(tradebill, bill);
                break;
            }
            case interestpay: {
                this.interestPay_rateSwap(tradebill, bill);
                break;
            }
            case capitalpay: {
                this.capitalPay_rateSwap(tradebill, bill);
            }
        }
    }

    protected void rateCfg_rateSwap(DynamicObject tradebill, DynamicObject bill) {
        tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)"tm_rateswap");
        QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        this.dealCashFlow_RateCfg_RateSwap(tradebill, bill, true);
        this.dealCashFlow_RateCfg_RateSwap(tradebill, bill, false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        DynamicObjectCollection entrys = bizRecord.getDynamicObjectCollection("entryentity");
        int seq = entrys.size() + 1;
        DynamicObject newEntry = entrys.addNew();
        newEntry.set("seq", (Object)seq);
        newEntry.set("bizbillid", (Object)bill.getLong("id"));
        newEntry.set("bizop", (Object)BizOperateEnum.ratecfg.getValue());
        newEntry.set("opdate", (Object)bill.getDate("bizdate"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
    }

    protected void interestPay_rateSwap(DynamicObject tradebill, DynamicObject bill) {
        Long recCashFlowId;
        DynamicObject market;
        tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)"tm_rateswap");
        QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        Long payCashFlowId = bill.getLong("cashflow_pay");
        if (EmptyUtil.isNoEmpty((Long)payCashFlowId)) {
            DynamicObject cashflow = TmcDataServiceHelper.loadSingle((Object)payCashFlowId, (String)"tm_cashflow");
            Date paydate = bill.getDate("plsettledate");
            market = tradebill.getDynamicObject("market");
            BigDecimal df = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate).get(paydate);
            Date paydate_1 = TcDateUtils.getLastDay((Date)paydate, (int)1);
            BigDecimal df_1 = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate_1).get(paydate_1);
            BigDecimal payAmount = bill.getBigDecimal("bizamt1").negate();
            cashflow.set("cfpaydate", (Object)paydate);
            cashflow.set("cfpayamount", (Object)bill.getBigDecimal("bizamt1").negate());
            cashflow.set("cfispay", (Object)Boolean.TRUE);
            cashflow.set("cfishis", (Object)Boolean.TRUE);
            cashflow.set("cfdiscfactor", (Object)df);
            cashflow.set("cftheta", (Object)this.roundDecimal(payAmount.multiply(df_1.subtract(df))));
            cashflow.set("cfpv", (Object)this.roundDecimal(payAmount.multiply(df)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashflow});
            QFilter filter_pay = new QFilter("cfdirection", "=", (Object)"buy");
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype,billno", (QFilter[])new QFilter[]{filter, filter_pay}, (String)"TO_DECIMAL(billno) asc");
            BizOperateEnum payBizFlag = RateSwapHelper.getBizOp((BizOperateEnum)BizOperateEnum.interestpay, (Long)payCashFlowId, (DynamicObject[])tempCashFlow, (boolean)false);
            tradebill.set("bizop", (Object)(payBizFlag == null ? null : payBizFlag.getValue()));
        }
        if (EmptyUtil.isNoEmpty((Long)(recCashFlowId = Long.valueOf(bill.getLong("cashflow_rec"))))) {
            DynamicObject cashflow = TmcDataServiceHelper.loadSingle((Object)recCashFlowId, (String)"tm_cashflow");
            market = tradebill.getDynamicObject("recmarket");
            Date paydate = bill.getDate("plsettledate");
            BigDecimal df = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate).get(paydate);
            Date paydate_1 = TcDateUtils.getLastDay((Date)paydate, (int)1);
            BigDecimal df_1 = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate_1).get(paydate_1);
            BigDecimal recAmount = bill.getBigDecimal("bizamt2");
            cashflow.set("cfpaydate", (Object)paydate);
            cashflow.set("cfpayamount", (Object)recAmount);
            cashflow.set("cfispay", (Object)Boolean.TRUE);
            cashflow.set("cfishis", (Object)Boolean.TRUE);
            cashflow.set("cfdiscfactor", (Object)df);
            cashflow.set("cftheta", (Object)this.roundDecimal(recAmount.multiply(df_1.subtract(df))));
            cashflow.set("cfpv", (Object)this.roundDecimal(recAmount.multiply(df)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashflow});
            QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype,billno", (QFilter[])new QFilter[]{filter, filter_sell}, (String)"TO_DECIMAL(billno) asc");
            BizOperateEnum recBizFlag = RateSwapHelper.getBizOp((BizOperateEnum)BizOperateEnum.interestpay, (Long)recCashFlowId, (DynamicObject[])tempCashFlow, (boolean)false);
            tradebill.set("recbizop", (Object)(recBizFlag == null ? null : recBizFlag.getValue()));
        }
        if (BizOperateEnum.interestpayAll.getValue().equals(tradebill.getString("bizop")) && BizOperateEnum.interestpayAll.getValue().equals(tradebill.getString("recbizop"))) {
            tradebill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            CombTradeBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        DynamicObjectCollection entrys = bizRecord.getDynamicObjectCollection("entryentity");
        int seq = entrys.size() + 1;
        DynamicObject newEntry = entrys.addNew();
        newEntry.set("seq", (Object)seq);
        newEntry.set("bizbillid", (Object)bill.getLong("id"));
        newEntry.set("bizop", (Object)BizOperateEnum.interestpay.getValue());
        newEntry.set("opdate", (Object)bill.getDate("bizdate"));
        newEntry.set("amount", (Object)bill.getBigDecimal("bizamt1"));
        newEntry.set("recamount", (Object)bill.getBigDecimal("bizamt2"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
    }

    protected void dealCashFlow_RateCfg_RateSwap(DynamicObject tradebill, DynamicObject bill, boolean isPay) {
        Long resetCFId = isPay ? bill.getLong("cashflow_pay") : bill.getLong("cashflow_rec");
        if (EmptyUtil.isNoEmpty((Long)resetCFId)) {
            boolean discount;
            BigDecimal amount;
            DynamicObjectCollection wc = isPay ? tradebill.getDynamicObjectCollection("payworkcalendar") : tradebill.getDynamicObjectCollection("recworkcalendar");
            DynamicObject market = isPay ? tradebill.getDynamicObject("market") : tradebill.getDynamicObject("recmarket");
            String basis = isPay ? tradebill.getString("basis") : tradebill.getString("recbasis");
            QFilter filter_reset = new QFilter("entrys.id", "=", (Object)resetCFId);
            DynamicObject payCashFlow = TmcDataServiceHelper.loadSingle((String)"tm_cashflow", (String)"cftype,cfamount,cfpayamount,cftheta,cfpv,cfdiscfactor,cfpaydate,cfosprincipal,cfinterest,entrys.cffixrate,entrys.cfratefixdate,entrys.cfisratecfg,entrys.cfuserate,entrys.cfadjstartdate,entrys.cfadjenddate", (QFilter[])new QFilter[]{filter_reset});
            DynamicObjectCollection entrys = payCashFlow.getDynamicObjectCollection("entrys");
            BigDecimal useRate = BigDecimal.ONE;
            FreqPeriodListBean freqPeriodList = RateSwapHelper.createFreqPeriodList((DynamicObject)tradebill, (boolean)isPay);
            PayFrequeEnum freq = freqPeriodList != null ? freqPeriodList.getFreqEnum() : null;
            for (DynamicObject resetRow : entrys) {
                if (resetRow.getLong("id") == resetCFId.longValue()) {
                    resetRow.set("cffixrate", isPay ? bill.get("fixedrate_pay") : bill.get("fixedrate_rec"));
                    resetRow.set("cfratefixdate", isPay ? bill.get("ratefixdate_pay") : bill.get("ratefixdate_rec"));
                    resetRow.set("cfisratecfg", (Object)Boolean.TRUE);
                    resetRow.set("cfuserate", (Object)(isPay ? bill.getBigDecimal("totalrate_pay") : bill.getBigDecimal("totalrate_rec")));
                }
                if (entrys.size() <= 1) continue;
                Date adjStartDate = (Date)resetRow.get("cfadjstartdate");
                Date adjEndDate = (Date)resetRow.get("cfadjenddate");
                BigDecimal baseBasis = TradeBusinessHelper.getBaseBasis((Date)adjStartDate, (Date)adjEndDate, (BasisEnum)BasisEnum.getEnum((String)basis), (DynamicObject[])((DynamicObject[])wc.toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freq, (FreqPeriodListBean)freqPeriodList);
                logger.info("\u4e92\u6362--\u5229\u7387\u786e\u8ba4 \u91cd\u7f6e\u677f\u5757: ispay:{}, \u8ba1\u606f\u57fa\u51c6:{},\u5f00\u59cb\u65e5\u671f:{}\uff0c\u7ed3\u675f\u65e5\u671f:{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{isPay, basis, adjStartDate, adjEndDate, baseBasis});
                useRate = useRate.multiply(BigDecimal.ONE.add(resetRow.getBigDecimal("cfuserate").divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis)));
            }
            useRate = useRate.subtract(BigDecimal.ONE);
            QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
            QFilter filter_dir = new QFilter("cfdirection", "=", (Object)(isPay ? "buy" : "sell"));
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cftype,cfpaydate,entrys.cfadjstartdate,entrys.cfadjenddate,entrys.cffixrate,entrys.cfratefixdate,entrys.cfisratecfg", (QFilter[])new QFilter[]{filter, filter_dir}, (String)"TO_DECIMAL(billno) asc");
            Date lastPaydate = RateSwapHelper.getLastPayDate((DynamicObject[])tempCashFlow, (Long)payCashFlow.getLong("id"));
            if (entrys.size() == 1) {
                DynamicObject resetRow = (DynamicObject)entrys.get(0);
                Date adjStartDate = (Date)resetRow.get("cfadjstartdate");
                Date adjEndDate = (Date)resetRow.get("cfadjenddate");
                BigDecimal baseBasis = TradeBusinessHelper.getBaseBasis((Date)adjStartDate, (Date)adjEndDate, (BasisEnum)BasisEnum.getEnum((String)basis), (DynamicObject[])((DynamicObject[])wc.toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freq, (FreqPeriodListBean)freqPeriodList);
                logger.info("\u4e92\u6362--\u5229\u7387\u786e\u8ba4 \u4e00\u7b14\u91cd\u7f6e\u884c: ispay:{}, \u8ba1\u606f\u57fa\u51c6{}\uff0c\u5f00\u59cb\u65e5\u671f{}\uff0c\u7ed3\u675f\u65e5\u671f{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{isPay, basis, adjStartDate, adjEndDate, baseBasis});
                amount = payCashFlow.getBigDecimal("cfosprincipal").multiply(resetRow.getBigDecimal("cfuserate").divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis));
            } else {
                amount = payCashFlow.getBigDecimal("cfosprincipal").multiply(useRate);
            }
            Date paydate = payCashFlow.getDate("cfpaydate");
            BigDecimal df = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate).get(paydate);
            String payDateType = isPay ? tradebill.getString("paydatetype") : tradebill.getString("recpaydatetype");
            boolean bl = discount = isPay ? tradebill.getBoolean("discount") : tradebill.getBoolean("recdiscount");
            if (ConfigPayTypeEnum.forward.getValue().equals(payDateType) && discount) {
                if (lastPaydate == null) {
                    amount = amount.multiply(df);
                } else {
                    BigDecimal df_last = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)lastPaydate).get(lastPaydate);
                    amount = amount.multiply(df.divide(df_last, 10, 4));
                }
            }
            Date paydate_1 = TcDateUtils.getLastDay((Date)paydate, (int)1);
            BigDecimal df_1 = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate_1).get(paydate_1);
            amount = this.roundDecimal(amount);
            amount = isPay ? amount.negate() : amount;
            payCashFlow.set("cfamount", (Object)amount);
            payCashFlow.set("cfpayamount", (Object)amount);
            payCashFlow.set("cfinterest", (Object)amount);
            payCashFlow.set("cfdiscfactor", (Object)df);
            payCashFlow.set("cftheta", (Object)this.roundDecimal(amount.multiply(df_1.subtract(df))));
            payCashFlow.set("cfpv", (Object)this.roundDecimal(amount.multiply(df)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{payCashFlow});
            BizOperateEnum bizFlag = RateSwapHelper.getBizOp((BizOperateEnum)BizOperateEnum.ratecfg, (Long)resetCFId, (DynamicObject[])tempCashFlow, (boolean)false);
            String flag = isPay ? "bizop" : "recbizop";
            tradebill.set(flag, (Object)(bizFlag == null ? null : bizFlag.getValue()));
        }
    }

    protected void capitalPay_rateSwap(DynamicObject tradebill, DynamicObject bill) {
        BigDecimal amount;
        BigDecimal df_1;
        Date paydate_1;
        BigDecimal df;
        DynamicObject cashflow;
        tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)"tm_rateswap");
        QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
        DynamicObject[] bak = CashFlowHelper.copyCashFlow((QFilter[])new QFilter[]{filter}, (Long)bill.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])bak);
        if (EmptyUtil.isNoEmpty((Object)bill.get("cashflow_pay"))) {
            cashflow = TmcDataServiceHelper.loadSingle((Object)bill.getLong("cashflow_pay"), (String)"tm_cashflow");
            Date paydate = bill.getDate("plsettledate");
            DynamicObject market = tradebill.getDynamicObject("market");
            df = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate).get(paydate);
            paydate_1 = TcDateUtils.getLastDay((Date)paydate, (int)1);
            df_1 = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate_1).get(paydate_1);
            amount = bill.getBigDecimal("bizamt1");
            cashflow.set("cfpaydate", (Object)paydate);
            cashflow.set("cfamount", (Object)amount);
            cashflow.set("cfpayamount", (Object)amount);
            cashflow.set("cfispay", (Object)Boolean.TRUE);
            cashflow.set("cfishis", (Object)Boolean.TRUE);
            cashflow.set("cfdiscfactor", (Object)df);
            cashflow.set("cftheta", (Object)this.roundDecimal(amount.multiply(df_1.subtract(df))));
            cashflow.set("cfpv", (Object)this.roundDecimal(amount.multiply(df)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashflow});
            tradebill.set("bizop", (Object)BizOperateEnum.capitalpay.getValue());
        }
        if (EmptyUtil.isNoEmpty((Object)bill.get("cashflow_rec"))) {
            cashflow = TmcDataServiceHelper.loadSingle((Object)bill.getLong("cashflow_rec"), (String)"tm_cashflow");
            DynamicObject market = tradebill.getDynamicObject("recmarket");
            Date paydate = bill.getDate("plsettledate");
            df = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate).get(paydate);
            paydate_1 = TcDateUtils.getLastDay((Date)paydate, (int)1);
            df_1 = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)TcDateUtils.getCurrentDate(), (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate_1).get(paydate_1);
            amount = bill.getBigDecimal("bizamt2");
            cashflow.set("cfpaydate", (Object)paydate);
            cashflow.set("cfamount", (Object)amount);
            cashflow.set("cfpayamount", (Object)amount);
            cashflow.set("cfispay", (Object)Boolean.TRUE);
            cashflow.set("cfishis", (Object)Boolean.TRUE);
            cashflow.set("cfdiscfactor", (Object)df);
            cashflow.set("cftheta", (Object)this.roundDecimal(amount.multiply(df_1.subtract(df))));
            cashflow.set("cfpv", (Object)this.roundDecimal(amount.multiply(df)));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cashflow});
            tradebill.set("recbizop", (Object)BizOperateEnum.capitalpay.getValue());
        }
        if (BizOperateEnum.capitalpay.getValue().equals(tradebill.getString("bizop")) && BizOperateEnum.capitalpay.getValue().equals(tradebill.getString("recbizop"))) {
            tradebill.set("billstatus", (Object)TcBillStatusEnum.FINISH.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.FINISH.getValue())) {
            CombTradeBillWriteBackHelper.finishWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        DynamicObjectCollection entrys = bizRecord.getDynamicObjectCollection("entryentity");
        int seq = entrys.size() + 1;
        DynamicObject newEntry = entrys.addNew();
        newEntry.set("seq", (Object)seq);
        newEntry.set("bizbillid", (Object)bill.getLong("id"));
        newEntry.set("bizop", (Object)BizOperateEnum.capitalpay.getValue());
        newEntry.set("opdate", (Object)bill.getDate("bizdate"));
        newEntry.set("amount", (Object)bill.getBigDecimal("bizamt1"));
        newEntry.set("recamount", (Object)bill.getBigDecimal("bizamt2"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        this.genPlBizRecord(tradebill, bill, bizRecord);
    }

    private BigDecimal roundDecimal(BigDecimal deci) {
        return deci.setScale(10, 4);
    }
}

