/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.bizbill.rate;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.bizbill.AbstractBizBillUnAuditService;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.helper.CombTradeBillWriteBackHelper;
import kd.tmc.tm.common.helper.RateSwapHelper;

public class RateSwapBizBillUnAuditService
extends AbstractBizBillUnAuditService {
    @Override
    public void unAudit(DynamicObject tradeBill, DynamicObject bill) {
        String operate = bill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case ratecfg: {
                this.rateCfg(tradeBill, bill);
                break;
            }
            case interestpay: 
            case capitalpay: {
                this.pay(tradeBill, bill, bizOp);
                break;
            }
        }
    }

    private void rateCfg(DynamicObject tradebill, DynamicObject bill) {
        Long recResetCFId;
        this.dealCashFlow(tradebill, bill);
        String tip = ResManager.loadKDString((String)"\u5f53\u524d\u751f\u547d\u5468\u671f\u5355\u4e0d\u662f\u6700\u8fd1\u64cd\u4f5c\u3002", (String)"BusinessOpIsNotLast", (String)"tmc-tm-business", (Object[])new Object[0]);
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        DynamicObjectCollection entry = bizRecord.getDynamicObjectCollection("entryentity");
        if (((DynamicObject)entry.get(entry.size() - 1)).getLong("bizbillid") != bill.getLong("id")) {
            throw new KDBizException(tip);
        }
        tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)"tm_rateswap");
        Long payResetCFId = bill.getLong("cashflow_pay");
        if (EmptyUtil.isNoEmpty((Long)payResetCFId)) {
            QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
            QFilter filter_pay = new QFilter("cfdirection", "=", (Object)"buy");
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype,entrys.id", (QFilter[])new QFilter[]{filter, filter_pay});
            BizOperateEnum payBizFlag = RateSwapHelper.getBizOp((BizOperateEnum)BizOperateEnum.ratecfg, (Long)payResetCFId, (DynamicObject[])tempCashFlow, (boolean)true);
            tradebill.set("bizop", (Object)(payBizFlag == null ? null : payBizFlag.getValue()));
        }
        if (EmptyUtil.isNoEmpty((Long)(recResetCFId = Long.valueOf(bill.getLong("cashflow_rec"))))) {
            QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
            QFilter filter_rec = new QFilter("cfdirection", "=", (Object)"sell");
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype,entrys.id", (QFilter[])new QFilter[]{filter, filter_rec});
            BizOperateEnum recBizFlag = RateSwapHelper.getBizOp((BizOperateEnum)BizOperateEnum.ratecfg, (Long)recResetCFId, (DynamicObject[])tempCashFlow, (boolean)true);
            tradebill.set("recbizop", (Object)(recBizFlag == null ? null : recBizFlag.getValue()));
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        entry.remove(entry.size() - 1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
    }

    private void pay(DynamicObject tradebill, DynamicObject bill, BizOperateEnum operateEnum) {
        Long recResetCFId;
        this.dealCashFlow(tradebill, bill);
        String tip = ResManager.loadKDString((String)"\u5f53\u524d\u751f\u547d\u5468\u671f\u5355\u4e0d\u662f\u6700\u8fd1\u64cd\u4f5c\u3002", (String)"BusinessOpIsNotLast", (String)"tmc-tm-business", (Object[])new Object[0]);
        Long bizRecordId = bill.getLong("bizrecordid");
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((Object)bizRecordId, (String)"tm_bizrecord");
        DynamicObjectCollection entry = bizRecord.getDynamicObjectCollection("entryentity");
        if (((DynamicObject)entry.get(entry.size() - 1)).getLong("bizbillid") != bill.getLong("id")) {
            throw new KDBizException(tip);
        }
        tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)"tm_rateswap");
        Long payResetCFId = bill.getLong("cashflow_pay");
        if (EmptyUtil.isNoEmpty((Long)payResetCFId)) {
            QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
            QFilter filter_pay = new QFilter("cfdirection", "=", (Object)"buy");
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype", (QFilter[])new QFilter[]{filter, filter_pay});
            BizOperateEnum payBizFlag = RateSwapHelper.getBizOp((BizOperateEnum)operateEnum, (Long)payResetCFId, (DynamicObject[])tempCashFlow, (boolean)true);
            tradebill.set("bizop", (Object)(payBizFlag == null ? null : payBizFlag.getValue()));
        }
        if (EmptyUtil.isNoEmpty((Long)(recResetCFId = Long.valueOf(bill.getLong("cashflow_rec"))))) {
            QFilter filter = new QFilter("billid", "=", tradebill.getPkValue());
            QFilter filter_rec = new QFilter("cfdirection", "=", (Object)"sell");
            DynamicObject[] tempCashFlow = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype", (QFilter[])new QFilter[]{filter, filter_rec});
            BizOperateEnum recBizFlag = RateSwapHelper.getBizOp((BizOperateEnum)operateEnum, (Long)recResetCFId, (DynamicObject[])tempCashFlow, (boolean)true);
            tradebill.set("recbizop", (Object)(recBizFlag == null ? null : recBizFlag.getValue()));
        }
        if (TcBillStatusEnum.FINISH.getValue().equals(tradebill.getString("billstatus"))) {
            tradebill.set("billstatus", (Object)TcBillStatusEnum.SURVIVAL.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tradebill});
        entry.remove(entry.size() - 1);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizRecord});
        if (tradebill.getString("billstatus").equals(TcBillStatusEnum.SURVIVAL.getValue())) {
            CombTradeBillWriteBackHelper.survivalWriteBack((DynamicObject[])new DynamicObject[]{tradebill});
        }
        this.deletePlBizRecord(tradebill, bill, bizRecord);
    }
}

