/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;

public abstract class AbstractCashFlowBuilder
implements ICashFlowBuilder {
    private static final Log logger = LogFactory.getLog(AbstractCashFlowBuilder.class);
    protected ModelAgent model;
    protected IFormView view;

    @Override
    public List<Map<String, Object>> build(IFormView view, ModelAgent model) {
        long beginTime = System.currentTimeMillis();
        this.view = view;
        this.model = model;
        List<Map<String, Object>> res = this.bulidCashFlow();
        long endTime = System.currentTimeMillis();
        logger.info("\u73b0\u91d1\u6d41\u6784\u5efa\u8017\u65f6\uff1a" + (endTime - beginTime) + "\u6beb\u79d2");
        return res;
    }

    @Override
    public DynamicObject[] refresh(ModelAgent model) {
        DynamicObject[] cashFlows;
        if (model.getModel() instanceof DynamicObject) {
            Long id = ((DynamicObject)model.getModel()).getLong("id");
            String entityName = ((DynamicObject)model.getModel()).getDynamicObjectType().getName();
            DynamicObject bill = TmcDataServiceHelper.loadSingle((Object)id, (String)entityName, (String)String.join((CharSequence)",", this.getTradeBillSelector()));
            model.setModel((Object)bill);
        }
        this.model = model;
        QFilter filter = new QFilter("billid", "=", model.getValue("id"));
        String direction = this.getFilter();
        if (EmptyUtil.isNoEmpty((String)direction)) {
            filter.and("cfdirection", "=", (Object)this.getFilter());
        }
        if (!this.isRefresh(model, cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)String.join((CharSequence)",", this.getCashFlowSelector()), (QFilter[])filter.toArray()))) {
            return null;
        }
        for (DynamicObject bill : cashFlows) {
            Map<String, Object> cashFlow = this.initCashFlow(bill);
            cashFlow = this.buildBillUpdateData(cashFlow);
            cashFlow.forEach((key, val) -> {
                if ("no".equals(key)) {
                    bill.set("billno", val);
                } else if (bill.getDynamicObjectType().getProperties().containsKey(key)) {
                    bill.set(key, val);
                }
            });
            if (bill.getDynamicObjectCollection("entrys").size() <= 0) continue;
            Map<String, Map<String, Object>> billMap = this.initCashFlowEntry(bill);
            Map<String, Map<String, Object>> entrys = this.buildEntrysUpdateData(billMap);
            entrys.forEach((index, row) -> {
                for (DynamicObject entry : bill.getDynamicObjectCollection("entrys")) {
                    if (!entry.getString("no").equals(index)) continue;
                    row.forEach((key, val) -> {
                        if (entry.getDynamicObjectType().getProperties().containsKey(key)) {
                            entry.set(key, val);
                        }
                    });
                }
            });
        }
        return cashFlows;
    }

    protected boolean isRefresh(ModelAgent bill, DynamicObject[] cashFlows) {
        return true;
    }

    protected Map<String, Object> initCashFlow(DynamicObject bill) {
        HashMap<String, Object> cashFlow = new HashMap<String, Object>();
        cashFlow.put("no", bill.getString("billno"));
        cashFlow.put("cfpaydate", bill.getDate("cfpaydate"));
        cashFlow.put("cfcurrency", bill.getDynamicObject("cfcurrency"));
        cashFlow.put("cfpayamount", bill.getBigDecimal("cfpayamount"));
        cashFlow.put("cfbizoperate", bill.getString("cfbizoperate"));
        return cashFlow;
    }

    protected Map<String, Map<String, Object>> initCashFlowEntry(DynamicObject bill) {
        HashMap<String, Map<String, Object>> entrys = new HashMap<String, Map<String, Object>>();
        for (DynamicObject entry : bill.getDynamicObjectCollection("entrys")) {
            HashMap<String, Object> cashFlow = new HashMap<String, Object>();
            cashFlow.put("no", entry.getString("no"));
            cashFlow.put("cfisratecfg", entry.getBoolean("cfisratecfg"));
            cashFlow.put("cfresetpredictrate", entry.getBigDecimal("cfresetpredictrate"));
            cashFlow.put("cffixrate", entry.getBigDecimal("cffixrate"));
            entrys.put(entry.getString("no"), cashFlow);
        }
        return entrys;
    }

    protected abstract List<Map<String, Object>> bulidCashFlow();

    protected abstract Map<String, Object> buildBillUpdateData(Map<String, Object> var1);

    protected Map<String, Map<String, Object>> buildEntrysUpdateData(Map<String, Map<String, Object>> cashFlow) {
        return cashFlow;
    }

    protected List<String> getCashFlowSelector() {
        ArrayList<String> sic = new ArrayList<String>(32);
        sic.add("billno");
        sic.add("cfresetpredictrate");
        sic.add("cfpaydate");
        sic.add("cfisratecfg");
        sic.add("entrys");
        sic.add("cfuserate");
        sic.add("cfprincipal");
        sic.add("cfosprincipal");
        sic.add("cfpv");
        sic.add("cfpayamount");
        sic.add("cfamount");
        sic.add("cfinterest");
        sic.add("cfcurrency");
        sic.add("cfdiscfactor");
        sic.add("cftheta");
        sic.add("no");
        sic.add("cfdealrival");
        sic.add("cfratefixdate");
        sic.add("cfbizoperate");
        sic.add("cffixrate");
        sic.add("cfishis");
        return sic;
    }

    protected List<String> getTradeBillSelector() {
        ArrayList<String> sic = new ArrayList<String>();
        sic.add("amount");
        sic.add("bizdate");
        sic.add("currency");
        sic.add("settledate");
        sic.add("billstatus");
        sic.add("dateadjustmethod");
        sic.add("adjustsettledate");
        sic.add("basis");
        sic.add("workcalendar");
        sic.add("pricerule");
        sic.add("market");
        sic.add("settledelay");
        sic.add("counterparty");
        return sic;
    }

    protected PriceRuleInfo getDiscfactor(Map<String, Object> cashFlow, ModelAgent model) {
        return MarketDataHelper.getDiscfactor(null, (Date)this.getReferDate(), (DynamicObject)this.getPriceRule(model), (Long[])this.getMarket(model), (Date[])this.getIntDate(cashFlow, model));
    }

    protected Date getReferDate() {
        Date referDate = (Date)this.model.getValue("referdate");
        if (EmptyUtil.isEmpty((Object)referDate)) {
            referDate = TcDateUtils.getCurrentDate();
        }
        return referDate;
    }

    protected DynamicObject getPriceRule(ModelAgent model) {
        return (DynamicObject)model.getValue("pricerule");
    }

    protected abstract Long[] getMarket(ModelAgent var1);

    protected abstract Date[] getIntDate(Map<String, Object> var1, ModelAgent var2);

    protected abstract String getFilter();
}

