/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.forex;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.tm.business.service.builder.forex.AbstractForexCashFlowBuilder;
import kd.tmc.tm.common.enums.DeliveryWayEnum;

public class ForexBuyCashFlowBuilder
extends AbstractForexCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(ForexBuyCashFlowBuilder.class);

    @Override
    protected void initPayDate(Map<String, Object> cashFlow) {
        cashFlow.put("cfpaydate", this.model.getValue("settledate"));
        if ("tm_forex_forward".equals(this.model.getDynamicObject().getDataEntityType().getName())) {
            boolean isDataRange = (Boolean)this.model.getValue("isdaterange");
            if (isDataRange) {
                cashFlow.put("cfpaydate", this.model.getValue("adjsettledate_end"));
            } else {
                cashFlow.put("cfpaydate", this.model.getValue("adjustsettledate"));
            }
        }
    }

    @Override
    protected void initCurrency(Map<String, Object> cashFlow) {
        cashFlow.put("cfcurrency", this.model.getValue("currency"));
    }

    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        cashFlow.put("cfdirection", TradeDirectionEnum.buy);
        if ("tm_forex_forward".equals(this.model.getDynamicObject().getDataEntityType().getName())) {
            String deliverWay = (String)this.model.getValue("deliveryway");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay)) {
                cashFlow.put("cfprincipal", this.model.getValue("amount"));
            }
        }
    }

    @Override
    protected void initPayAmount(Map<String, Object> cashFlow) {
        String tradeDir = (String)this.model.getValue("tradedirect");
        BigDecimal payAmount = (BigDecimal)this.model.getValue("amount");
        String deliverWay = (String)this.model.getValue("deliveryway");
        if ("tm_forex_forward".equals(this.model.getDynamicObject().getDataEntityType().getName())) {
            DynamicObject currency = (DynamicObject)this.model.getValue("currency");
            DynamicObject settleCurrency = (DynamicObject)this.model.getValue("settlecurrency");
            if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay) && currency.getLong("id") == settleCurrency.getLong("id")) {
                BigDecimal spotExrate;
                BigDecimal preExrate;
                DynamicObject tradebill = this.model.getDynamicObject();
                BigDecimal principal = (BigDecimal)this.model.getValue("amount");
                BigDecimal fwdExrate = (BigDecimal)this.model.getValue("spotrate");
                Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
                String fxQuote = (String)this.model.getValue("fxquote");
                Date adjDate = tradebill.getBoolean("isdaterange") ? tradebill.getDate("adjsettledate_end") : tradebill.getDate("adjustsettledate");
                ForexQuoteInfo spotrateInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, null);
                ForexQuoteInfo preExrateInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)adjDate);
                String pair = (String)this.model.getValue("pair");
                String fq = preExrateInfo.getFxquote();
                boolean isSame = pair.equals(fq);
                BigDecimal bigDecimal = preExrate = isSame && TradeDirectionEnum.buy.getValue().equals(tradeDir) || !isSame && TradeDirectionEnum.sell.getValue().equals(tradeDir) ? preExrateInfo.getSellPrice() : preExrateInfo.getBuyPrice();
                if (!fq.equals(fxQuote)) {
                    BigDecimal newExRate = BigDecimal.ONE.divide(preExrate, 10, RoundingMode.HALF_UP);
                    logger.info("\u53d6\u5230\u7684\u9884\u4f30\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)preExrate, (Object)newExRate);
                    preExrate = newExRate;
                }
                BigDecimal bigDecimal2 = spotExrate = (isSame = pair.equals(fq = spotrateInfo.getFxquote())) ? spotrateInfo.getSellPrice() : spotrateInfo.getBuyPrice();
                if (!fq.equals(fxQuote)) {
                    BigDecimal newExRate = BigDecimal.ONE.divide(spotExrate, 10, RoundingMode.HALF_UP);
                    logger.info("\u53d6\u5230\u7684\u5373\u671f\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)spotExrate, (Object)newExRate);
                    spotExrate = newExRate;
                }
                payAmount = this.isSameFx(this.model.getDynamicObject()) ? preExrate.subtract(fwdExrate).multiply(principal).divide(spotExrate, 10, 4) : BigDecimal.ONE.divide(preExrate, 10, 4).subtract(BigDecimal.ONE.divide(fwdExrate, 10, 4)).multiply(principal).multiply(spotExrate);
            }
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradeDir)) {
            payAmount = payAmount.negate();
        }
        cashFlow.put("cfpayamount", payAmount);
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        Long buyMarketId = ((DynamicObject)model.getValue("buymarket")).getLong("id");
        return new Long[]{buyMarketId};
    }

    @Override
    protected String getFilter() {
        return TradeDirectionEnum.buy.getValue();
    }
}

