/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.option;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.business.service.builder.AbstractCashFlowBuilder;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.ForexCashFlowHelper;
import kd.tmc.tm.common.helper.ForexOptionsHelper;

public abstract class AbstractForexOptionsCashFlowBuilder
extends AbstractCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(AbstractForexOptionsCashFlowBuilder.class);

    @Override
    protected List<Map<String, Object>> bulidCashFlow() {
        ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>();
        if (this.isCreateCashFlow()) {
            int index = 1;
            Map<String, Object> cashFlow = this.createCashFlowData(index);
            datas.add(cashFlow);
            Map<String, Object> resetCashFlow = this.createResetCashFlowData(cashFlow);
            datas.add(resetCashFlow);
        }
        return datas;
    }

    protected abstract boolean isCreateCashFlow();

    protected Map<String, Object> createCashFlowData(int index) {
        String deliveryWay = null;
        if (this.model.getModel() instanceof IDataModel) {
            IDataModel dataModel = (IDataModel)this.model.getModel();
            deliveryWay = (String)dataModel.getValue("deliveryway");
        } else if (this.model.getModel() instanceof DynamicObject) {
            DynamicObject bill = (DynamicObject)this.model.getModel();
            deliveryWay = bill.getString("deliveryway");
        }
        Map<String, Object> cashFlow = new HashMap<String, Object>();
        long payId = DBServiceHelper.genGlobalLongId();
        cashFlow.put("id", payId);
        cashFlow.put("no", String.valueOf(index));
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            cashFlow.put("cftype", CashFlowTypeEnum.pl);
        } else {
            cashFlow.put("cftype", CashFlowTypeEnum.capital);
        }
        cashFlow.put("cfishis", Boolean.FALSE);
        DynamicObject counterParty = (DynamicObject)this.model.getValue("counterparty");
        if (EmptyUtil.isNoEmpty((DynamicObject)counterParty)) {
            cashFlow.put("cfdealrival", counterParty.getPkValue());
        }
        this.initOtherData(cashFlow);
        this.initPayAmount(cashFlow);
        cashFlow = this.buildBillUpdateData(cashFlow);
        return cashFlow;
    }

    protected Map<String, Object> createResetCashFlowData(Map<String, Object> cashFlow) {
        HashMap<String, Object> resetRow = new HashMap<String, Object>();
        resetRow.put("id", DBServiceHelper.genGlobalLongId());
        resetRow.put("pid", cashFlow.get("id"));
        resetRow.put("no", cashFlow.get("no") + ".1");
        resetRow.put("cftype", "");
        resetRow.put("cfratefixdate", this.model.getValue("adjexpiredate"));
        resetRow.put("cffixrate", this.model.getValue("exchangerate"));
        resetRow.put("cfuserate", this.getMarketRate());
        return resetRow;
    }

    protected BigDecimal getMarketRate() {
        String fq;
        Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.model.getValue("fxquote");
        Date dm = (Date)this.model.getValue("adjustsettledate");
        ForexQuoteInfo fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, (Date)dm);
        String dir = (String)this.model.getValue("tradedirect");
        String tradeType = (String)this.model.getValue("tradetype");
        String pair = (String)this.model.getValue("pair");
        BigDecimal marketRate = pair.equals(fq = fxInfo.getFxquote()) ? (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice()) : (ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType) ? fxInfo.getSellPrice() : fxInfo.getBuyPrice());
        if (!fq.equals(fxQuote)) {
            BigDecimal newExRate = BigDecimal.ONE.divide(marketRate, 10, RoundingMode.HALF_UP);
            logger.info("\u53d6\u5230\u7684\u6c47\u7387{}\uff0c\u6c47\u7387\u5012\u6570{}", (Object)marketRate, (Object)newExRate);
            marketRate = newExRate;
        }
        return marketRate;
    }

    protected ForexQuoteInfo getSportForexInfo() {
        Long fqId = ((DynamicObject)this.model.getValue("pricerule")).getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.model.getValue("fxquote");
        ForexQuoteInfo fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, null, null);
        return fxInfo;
    }

    protected abstract void initOtherData(Map<String, Object> var1);

    protected abstract void initPayAmount(Map<String, Object> var1);

    @Override
    protected Map<String, Object> buildBillUpdateData(Map<String, Object> cashFlow) {
        if (((Boolean)cashFlow.get("cfishis")).booleanValue()) {
            return cashFlow;
        }
        this.initPayAmount(cashFlow);
        return cashFlow;
    }

    @Override
    protected Map<String, Map<String, Object>> buildEntrysUpdateData(Map<String, Map<String, Object>> cashFlows) {
        return cashFlows;
    }

    @Override
    protected List<String> getTradeBillSelector() {
        List<String> sic = super.getTradeBillSelector();
        sic.add("deliveryway");
        sic.add("tradedirect");
        sic.add("adjexpiredate");
        sic.add("sellcurrency");
        sic.add("tradetype");
        sic.add("exchangerate");
        sic.add("sellamount");
        sic.add("fxquote");
        sic.add("settlecurrency");
        sic.add("adjustsettledate");
        sic.add("currency");
        sic.add("amount");
        return sic;
    }

    @Override
    protected Date[] getIntDate(Map<String, Object> cashFlow, ModelAgent model) {
        Date payDate = (Date)cashFlow.get("cfpaydate");
        return new Date[]{payDate, TcDateUtils.getLastDay((Date)payDate, (int)1)};
    }

    @Override
    protected Map<String, Object> initCashFlow(DynamicObject bill) {
        Map<String, Object> cashFlow = super.initCashFlow(bill);
        cashFlow.put("cfishis", bill.get("cfishis"));
        cashFlow.put("cfamount", bill.get("cfamount"));
        cashFlow.put("cfdealrival", bill.get("cfdealrival"));
        cashFlow.put("entrys", bill.getDynamicObjectCollection("entrys"));
        return cashFlow;
    }

    protected boolean isSameFx() {
        String pair = (String)this.model.getValue("pair");
        String fxquote = (String)this.model.getValue("fxquote");
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote}) && pair.equals(fxquote);
    }

    @Override
    public DynamicObject[] refresh(ModelAgent model) {
        DynamicObject[] cashFlows;
        DynamicObject tradeBill = (DynamicObject)model.getModel();
        Long id = tradeBill.getLong("id");
        QFilter filter = new QFilter("billid", "=", (Object)id);
        String direction = this.getFilter();
        if (EmptyUtil.isNoEmpty((String)direction)) {
            filter.and("cfdirection", "=", (Object)this.getFilter()).and("cfIsHis", "=", (Object)false);
        }
        if (!this.isRefresh(model, cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cfPayDate,cfCurrency,cfPayAmount,cfPrincipal,cfFixRate,cfUseRate", (QFilter[])filter.toArray()))) {
            return null;
        }
        for (DynamicObject cashFlow : cashFlows) {
            DynamicObjectCollection entrys = cashFlow.getDynamicObjectCollection("entrys");
            if (entrys.size() == 0) continue;
            DynamicObject subRow = (DynamicObject)entrys.get(0);
            BigDecimal exRate = ForexCashFlowHelper.getMarketRate((DynamicObject)tradeBill);
            subRow.set("cfuserate", (Object)exRate);
            String deliveryWay = tradeBill.getString("deliveryway");
            if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) continue;
            BigDecimal cfPrincipal = cashFlow.getBigDecimal("cfPrincipal");
            BigDecimal cfPayAmount = ForexCashFlowHelper.calPayAmt_ForexOption((DynamicObject)tradeBill, (BigDecimal)cfPrincipal, (BigDecimal)exRate);
            cashFlow.set("cfpayamount", (Object)cfPayAmount);
        }
        return cashFlows;
    }
}

