/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.option;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.builder.option.AbstractForexOptionsCashFlowBuilder;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;

public class ForexOptionsSellCashFlowBuilder
extends AbstractForexOptionsCashFlowBuilder {
    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        Date payDate = (Date)this.model.getValue("adjustsettledate");
        cashFlow.put("cfpaydate", payDate);
        cashFlow.put("cfcurrency", this.model.getValue("sellcurrency"));
        cashFlow.put("cfdirection", TradeDirectionEnum.sell.getValue());
    }

    @Override
    protected void initPayAmount(Map<String, Object> cashFlow) {
        BigDecimal sellAmount;
        String deliveryway = (String)this.model.getValue("deliveryway");
        BigDecimal principal = (BigDecimal)this.model.getValue("amount");
        BigDecimal baseAmount = sellAmount = (BigDecimal)this.model.getValue("sellamount");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryway)) {
            BigDecimal contractRate = (BigDecimal)this.model.getValue("exchangerate");
            BigDecimal marketRate = this.getMarketRate();
            String tradeType = (String)this.model.getValue("tradetype");
            baseAmount = this.isSameFx() ? (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? ForexOptionsHelper.calAmountForwardDirection((BigDecimal)marketRate, (BigDecimal)contractRate, (BigDecimal)principal, (ModelAgent)this.model) : ForexOptionsHelper.calAmountForwardDirection((BigDecimal)contractRate, (BigDecimal)marketRate, (BigDecimal)principal, (ModelAgent)this.model)) : (OptionsTradeTypeEnum.call.getValue().equals(tradeType) ? ForexOptionsHelper.calAmountReverseDirection((BigDecimal)marketRate, (BigDecimal)contractRate, (BigDecimal)principal, (ModelAgent)this.model) : ForexOptionsHelper.calAmountReverseDirection((BigDecimal)contractRate, (BigDecimal)marketRate, (BigDecimal)principal, (ModelAgent)this.model));
            DynamicObject currency = (DynamicObject)this.model.getValue("currency");
            DynamicObject settleCurrency = (DynamicObject)this.model.getValue("settlecurrency");
            if (currency.getLong("id") == settleCurrency.getLong("id")) {
                ForexQuoteInfo sportInfo = this.getSportForexInfo();
                baseAmount = currency.getString("number").equals(sportInfo.getFxquote().split("/")[0]) ? baseAmount.divide(sportInfo.getSellPrice(), 6, 4) : baseAmount.multiply(sportInfo.getBuyPrice());
            }
            cashFlow.put("cfprincipal", principal);
        }
        BigDecimal payAmount = baseAmount.multiply(BigDecimal.valueOf(this.getFLagByTradeDirectAndTradeType()));
        cashFlow.put("cfpayamount", payAmount);
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        return null;
    }

    @Override
    protected String getFilter() {
        return TradeDirectionEnum.sell.getValue();
    }

    @Override
    protected boolean isCreateCashFlow() {
        String deliverWay = (String)this.model.getValue("deliveryway");
        boolean isCreateCashFlow = true;
        DynamicObject sellCurrency = (DynamicObject)this.model.getValue("sellcurrency");
        DynamicObject settleCurrency = (DynamicObject)this.model.getValue("settlecurrency");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliverWay)) {
            isCreateCashFlow = false;
            if (EmptyUtil.isNoEmpty((DynamicObject)settleCurrency)) {
                isCreateCashFlow = sellCurrency.getLong("id") == settleCurrency.getLong("id");
            }
        }
        return isCreateCashFlow;
    }

    protected double getFLagByTradeDirectAndTradeType() {
        String deliveryway = (String)this.model.getValue("deliveryway");
        String dir = (String)this.model.getValue("tradedirect");
        boolean isMinus = false;
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryway)) {
            String tradeType = (String)this.model.getValue("tradetype");
            isMinus = ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType);
        }
        return isMinus ? -1.0 : 1.0;
    }
}

