/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.rate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.RateTermEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.business.service.builder.AbstractCashFlowBuilder;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.RateSwapHelper;

public abstract class AbstractSwapsCashFlowBuilder
extends AbstractCashFlowBuilder {
    private static final Log logger = LogFactory.getLog(AbstractSwapsCashFlowBuilder.class);
    private FreqPeriodListBean freqPeriodResolver = null;

    @Override
    protected List<Map<String, Object>> bulidCashFlow() {
        String swapType = (String)this.model.getValue("rateswaptype");
        String initPriExType = (String)this.model.getValue("initpriextype");
        String endPriExType = (String)this.model.getValue("endpriextype");
        Date endDate = (Date)this.model.getValue("enddate");
        List<Map<String, Object>> unResetCashFlow = this.genInitCashFlow(endDate, swapType, initPriExType, endPriExType);
        Date[] intDate = this.genIntDate(unResetCashFlow);
        Map<Date, BigDecimal> dfs = this.getDfs(this.getReferDate(), this.getPriceRule(this.model), intDate);
        if (dfs.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u914d\u7f6e\u7684\u6536\u76ca\u66f2\u7ebf\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractSwapsCashFlowBuilder_0", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection workCalendars = this.getWorkCalendars();
        Map<Date, Boolean> workDateMap = AbstractSwapsCashFlowBuilder.getWorkCalendarMap(workCalendars, this.getValueDate(), endDate);
        List<Map<String, Object>> maps = this.genFinalCashFlow(workDateMap, unResetCashFlow, dfs, swapType);
        return maps;
    }

    protected List<Map<String, Object>> genInitCashFlow(Date endDate, String swapType, String initPriExType, String endPriExType) {
        String payFreq = this.getPayFreq();
        Date valueDate = this.getValueDate();
        boolean isStub = this.isStub();
        if (this.isPayStage()) {
            LinkedList dateList = RateSwapHelper.getDateList_PayStage((String)payFreq, (Date)valueDate, (boolean)isStub, (boolean)this.isPayDateFoward(), (boolean)this.isStubFront(), (Date)this.getFirstCopDate(), (Date)this.getPenuCopDate(), (DynamicObject)this.model.getDynamicObject());
            return this.genCashFlow(swapType, dateList, initPriExType, endPriExType, endDate);
        }
        return this.genCashFlow(swapType, initPriExType, endPriExType, endDate);
    }

    protected List<Map<String, Object>> genCashFlow(String swapType, LinkedList<Date> dateList, String initPriExType, String endPriExType, Date endDate) {
        CashFlowTypeEnum midType = this.isRateFloat() ? CashFlowTypeEnum.floatrate : CashFlowTypeEnum.fixedrate;
        int typeNum = 0;
        if (swapType.equals(SwapTypeEnum.currency.getValue())) {
            Date valueDate = this.getValueDate();
            boolean isInitActual = SwapExchangeType.Actual.getValue().equals(initPriExType);
            boolean isEndActual = SwapExchangeType.Actual.getValue().equals(endPriExType);
            if (isInitActual && !isEndActual) {
                dateList.addFirst(valueDate);
                typeNum = 1;
            } else if (!isInitActual && isEndActual) {
                dateList.addLast(endDate);
                typeNum = 2;
            } else if (isInitActual && isEndActual) {
                dateList.addFirst(valueDate);
                dateList.addLast(endDate);
                typeNum = 3;
            }
        }
        ArrayList<Map<String, Object>> cashFlow = new ArrayList<Map<String, Object>>(dateList.size());
        DynamicObjectCollection workCalendars = this.getWorkCalendars();
        Map<Date, Boolean> workDateMap = AbstractSwapsCashFlowBuilder.getWorkCalendarMap(workCalendars, dateList.getFirst(), endDate);
        for (int i = 0; i < dateList.size(); ++i) {
            HashMap<String, Object> cashFlowRow = new HashMap<String, Object>(16);
            cashFlowRow.put("no", Integer.toString(i + 1));
            if (i == 0 && (typeNum == 1 || typeNum == 3) || i == dateList.size() - 1 && (typeNum == 2 || typeNum == 3)) {
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
            } else {
                cashFlowRow.put("cftype", midType);
            }
            cashFlowRow.put("cftype", midType);
            if (i == 0 && (typeNum == 1 || typeNum == 3)) {
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
                cashFlowRow.put("cfamount", this.getInitAmount());
                cashFlowRow.put("cfprincipal", this.getAmount());
            }
            if (i == dateList.size() - 1 && (typeNum == 2 || typeNum == 3)) {
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
                cashFlowRow.put("cfamount", this.getEndAmount());
                cashFlowRow.put("cfprincipal", this.getAmount());
            }
            cashFlowRow.put("cfunadjpaydate", dateList.get(i));
            Date payDate = this.calPayDate(workDateMap, (Date)cashFlowRow.get("cfunadjpaydate"));
            cashFlowRow.put("cfpaydate", payDate);
            cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
            cashFlow.add(cashFlowRow);
        }
        return cashFlow;
    }

    protected List<Map<String, Object>> genCashFlow(String swapType, String initPriExType, String endPriExType, Date endDate) {
        CashFlowTypeEnum type;
        ArrayList<Map<String, Object>> cashFlow = new ArrayList<Map<String, Object>>(3);
        CashFlowTypeEnum cashFlowTypeEnum = type = this.isRateFloat() ? CashFlowTypeEnum.floatrate : CashFlowTypeEnum.fixedrate;
        if (swapType.equals(SwapTypeEnum.currency.getValue())) {
            boolean isInitActual = SwapExchangeType.Actual.getValue().equals(initPriExType);
            boolean isEndActual = SwapExchangeType.Actual.getValue().equals(endPriExType);
            HashMap<String, Object> cashFlowRow = new HashMap<String, Object>(16);
            if (isInitActual && !isEndActual) {
                cashFlowRow.put("no", "1");
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
                cashFlowRow.put("cfunadjpaydate", this.getValueDate());
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlowRow.put("cfpaydate", this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate")));
                cashFlowRow.put("cfamount", this.getInitAmount());
                cashFlowRow.put("cfprincipal", this.getAmount());
                cashFlow.add(cashFlowRow);
                cashFlowRow = new HashMap(16);
                cashFlowRow.put("no", "2");
                cashFlowRow.put("cftype", type);
                cashFlowRow.put("cfunadjpaydate", endDate);
                Date payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlow.add(cashFlowRow);
            } else if (!isInitActual && isEndActual) {
                cashFlowRow.put("no", "1");
                cashFlowRow.put("cftype", type);
                cashFlowRow.put("cfunadjpaydate", endDate);
                Date payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlow.add(cashFlowRow);
                cashFlowRow = new HashMap(16);
                cashFlowRow.put("no", "2");
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
                cashFlowRow.put("cfunadjpaydate", endDate);
                payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlowRow.put("cfamount", this.getEndAmount());
                cashFlowRow.put("cfprincipal", this.getAmount());
                cashFlow.add(cashFlowRow);
            } else if (isInitActual && isEndActual) {
                cashFlowRow.put("no", "1");
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
                cashFlowRow.put("cfunadjpaydate", this.getValueDate());
                Date payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlowRow.put("cfamount", this.getInitAmount());
                cashFlowRow.put("cfprincipal", this.getAmount());
                cashFlow.add(cashFlowRow);
                cashFlowRow = new HashMap(16);
                cashFlowRow.put("no", "2");
                cashFlowRow.put("cftype", type);
                cashFlowRow.put("cfunadjpaydate", endDate);
                payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlow.add(cashFlowRow);
                cashFlowRow = new HashMap(16);
                cashFlowRow.put("no", "3");
                cashFlowRow.put("cftype", CashFlowTypeEnum.capital);
                cashFlowRow.put("cfunadjpaydate", endDate);
                payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlowRow.put("cfamount", this.getEndAmount());
                cashFlowRow.put("cfprincipal", this.getAmount());
                cashFlow.add(cashFlowRow);
            } else {
                cashFlowRow.put("no", "1");
                cashFlowRow.put("cftype", type);
                cashFlowRow.put("cfunadjpaydate", endDate);
                Date payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
                cashFlowRow.put("cfpaydate", payDate);
                cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
                cashFlow.add(cashFlowRow);
            }
        } else {
            HashMap<String, Object> cashFlowRow = new HashMap<String, Object>(16);
            cashFlowRow.put("no", "1");
            cashFlowRow.put("cftype", type);
            cashFlowRow.put("cfunadjpaydate", endDate);
            Date payDate = this.calPayDate((Date)cashFlowRow.get("cfunadjpaydate"));
            cashFlowRow.put("cfpaydate", payDate);
            cashFlowRow.put("id", DBServiceHelper.genGlobalLongId());
            cashFlow.add(cashFlowRow);
        }
        return cashFlow;
    }

    protected void initOtherData(Map<String, Object> cashFlow) {
    }

    protected List<Map<String, Object>> genFinalCashFlow(Map<Date, Boolean> workDateMap, List<Map<String, Object>> cashFlow, Map<Date, BigDecimal> Dfs, String swapType) {
        ArrayList<Map<String, Object>> finalCashFlow = new ArrayList<Map<String, Object>>(2 * cashFlow.size());
        int rowIndex = 0;
        boolean isFirstReset = true;
        boolean isLastReset = false;
        for (int i = 0; i < cashFlow.size(); ++i) {
            Map<String, Object> cashFlowRow = cashFlow.get(i);
            CashFlowTypeEnum type = (CashFlowTypeEnum)cashFlowRow.get("cftype");
            this.fillUnResetCashFlow(cashFlowRow, Dfs, swapType);
            finalCashFlow.add(cashFlowRow);
            cashFlowRow.put("resetSize", 0);
            if (type != CashFlowTypeEnum.capital) {
                Date startResetDate = isFirstReset ? this.getValueDate() : (Date)cashFlow.get(rowIndex - 1).get("cfunadjpaydate");
                Date endResetDate = (Date)cashFlowRow.get("cfunadjpaydate");
                if (this.isPayDateFoward()) {
                    startResetDate = (Date)cashFlowRow.get("cfunadjpaydate");
                    Map<String, Object> nextCashFlowRow = null;
                    if (i < cashFlow.size() - 1 && (CashFlowTypeEnum)cashFlow.get(i + 1).get("cftype") != CashFlowTypeEnum.capital) {
                        nextCashFlowRow = cashFlow.get(i + 1);
                    }
                    endResetDate = nextCashFlowRow != null ? (Date)nextCashFlowRow.get("cfunadjpaydate") : (Date)this.model.getValue("enddate");
                }
                int l = cashFlow.size() - 2;
                if (i == cashFlow.size() - 2 && cashFlow.get(i + 1).get("cftype") == CashFlowTypeEnum.capital || i == cashFlow.size() - 1) {
                    isLastReset = true;
                }
                this.genResetCashFlow(workDateMap, cashFlowRow, finalCashFlow, startResetDate, endResetDate, Dfs, isFirstReset, isLastReset);
                isFirstReset = false;
            }
            ++rowIndex;
        }
        this.fillFinalCashFlow(finalCashFlow, Dfs);
        return finalCashFlow;
    }

    protected void fillUnResetCashFlow(Map<String, Object> cashFlowRow, Map<Date, BigDecimal> Dfs, String swapType) {
        cashFlowRow.put("cfcurrency", this.getCurrency());
        CashFlowTypeEnum type = (CashFlowTypeEnum)cashFlowRow.get("cftype");
        cashFlowRow.put("cfpayfreq", this.getPayfreq(type));
        Date payDate = (Date)cashFlowRow.get("cfpaydate");
        BigDecimal disCFactor = Dfs.get(payDate);
        cashFlowRow.put("cfdiscfactor", disCFactor);
        cashFlowRow.put("cfexchangerate", this.getExchangeRate(swapType));
        if (type == CashFlowTypeEnum.capital) {
            BigDecimal amount = (BigDecimal)cashFlowRow.get("cfamount");
            cashFlowRow.put("cfpayamount", amount);
            cashFlowRow.put("cfinterest", BigDecimal.ZERO);
            BigDecimal dft_1 = Dfs.get(TcDateUtils.getLastDay((Date)payDate, (int)1));
            if (dft_1 == null) {
                dft_1 = BigDecimal.ZERO;
            }
            cashFlowRow.put("cftheta", this.roundDecimal(disCFactor.subtract(dft_1).multiply(amount)).negate());
            cashFlowRow.put("cfpv", this.roundDecimal(amount.multiply(disCFactor)));
        } else {
            BigDecimal osprincipal = this.getAmount();
            cashFlowRow.put("cfosprincipal", osprincipal);
        }
        this.initOtherData(cashFlowRow);
    }

    private void genResetCashFlow(Map<Date, Boolean> workDateMap, Map<String, Object> cashFlowRow, List<Map<String, Object>> finalCashFlow, Date firstResetDate, Date endResetDate, Map<Date, BigDecimal> dfs, Boolean isFirstReset, Boolean isLastReset) {
        Date unAdjEndDate;
        long beginTime = System.currentTimeMillis();
        boolean isFloat = this.isRateFloat();
        boolean isStages = this.isPayStage();
        Long pid = (Long)cashFlowRow.get("id");
        String unNo = (String)cashFlowRow.get("no");
        String term = "";
        boolean isAfter = false;
        Date unAdjStartDate = firstResetDate;
        int no = 1;
        boolean isMuti = false;
        HashMap<String, Object> resetRow = new HashMap<String, Object>(16);
        DynamicObject referRateDO = this.getReferRate();
        if (isFloat) {
            if (this.isRateQuoteDays()) {
                if (isFirstReset.booleanValue() && this.isStub() && this.isStubFront()) {
                    referRateDO = this.getFirstReferRate();
                    term = referRateDO.getString("term");
                } else if (isLastReset.booleanValue() && this.isStub() && !this.isStubFront()) {
                    referRateDO = this.getPenuReferRate();
                    term = referRateDO.getString("term");
                } else {
                    term = referRateDO.getString("term");
                }
                if (isStages && (isAfter = this.isFreqAfter(PayFrequeEnum.valueOf((String)term).getName(), this.getPayFreq()))) {
                    isMuti = true;
                }
            } else {
                term = RateTermEnum.getEnum((String)this.getRateResetFreq()).getValue();
            }
        }
        if (this.isPayStage()) {
            if (isAfter) {
                String termName = RateTermEnum.valueOf((String)term).getName();
                unAdjEndDate = PayFrequeEnum.getNextDateByPayfreq((Date)unAdjStartDate, (PayFrequeEnum)PayFrequeEnum.valueOf((String)term));
                if (unAdjEndDate.after(endResetDate)) {
                    unAdjEndDate = endResetDate;
                }
            } else {
                unAdjEndDate = endResetDate;
            }
        } else {
            unAdjEndDate = (Date)this.model.getValue("enddate");
        }
        resetRow.put("pid", pid);
        resetRow.put("id", DBServiceHelper.genGlobalLongId());
        resetRow.put("no", unNo + "." + no);
        resetRow.put("cfresetpaydate", cashFlowRow.get("cfpaydate"));
        resetRow.put("cfunadjstartdate", unAdjStartDate);
        resetRow.put("cfadjstartdate", this.calPayDate((Date)resetRow.get("cfunadjstartdate")));
        resetRow.put("cfunadjenddate", unAdjEndDate);
        resetRow.put("cfadjenddate", this.calPayDate((Date)resetRow.get("cfunadjenddate")));
        resetRow.put("cfisadjust", !this.getAdjustMethod().equals(AdjustMethodEnum.no_adjust.getValue()));
        int periodDays = this.calPeriodDays((Date)resetRow.get("cfadjstartdate"), (Date)resetRow.get("cfadjenddate"));
        resetRow.put("cfperioddays", periodDays);
        resetRow.put("cfbasis", this.getBasis());
        if (isFloat) {
            Date rateFixDate;
            if (this.isRateResetFoward()) {
                rateFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)this.getWorkCalendars(), (Date)((Date)resetRow.get("cfadjstartdate")), (int)(-this.getRateResetOffSet()), (AdjustMethodEnum)AdjustMethodEnum.backward);
                resetRow.put("cfratefixdate", rateFixDate);
            } else {
                rateFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)this.getWorkCalendars(), (Date)((Date)resetRow.get("cfadjenddate")), (int)(-this.getRateResetOffSet()), (AdjustMethodEnum)AdjustMethodEnum.backward);
                resetRow.put("cfratefixdate", rateFixDate);
            }
            resetRow.put("cfratefixindex", referRateDO);
            resetRow.put("cfreferindexfreq", term);
            if (!this.isRateQuoteDays()) {
                resetRow.put("cfresetfreq", term);
            } else if (isStages) {
                resetRow.put("cfresetfreq", isAfter ? term : this.getPayFreq());
            }
            if (isFirstReset.booleanValue()) {
                resetRow.put("cffixrate", this.getFirstFixedRate());
                if (EmptyUtil.isNoEmpty((BigDecimal)this.getFirstFixedRate())) {
                    resetRow.put("cfisratecfg", true);
                }
            }
            if (rateFixDate.after(this.getReferDate())) {
                Date indexDate = TermUtils.getDateByTerm((String)RateTermEnum.valueOf((String)term).getName(), (Date)rateFixDate);
                Map furDF = MarketDataHelper.getFurRateByYieldCurve((IFormView)this.view, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)this.getPriceRule(this.model), (Long)this.getMarket(this.model)[0], (Date)this.getReferDate(), (Date)rateFixDate, (Date[])new Date[]{indexDate});
                resetRow.put("cfresetpredictrate", furDF.get(indexDate));
            }
            resetRow.put("cfratemargin", this.getRateMargin());
            BigDecimal muUseRate = null;
            BigDecimal fixRate = (BigDecimal)resetRow.get("cffixrate");
            if (fixRate != null && fixRate.compareTo(BigDecimal.ZERO) != 0) {
                muUseRate = fixRate.add(this.getRateMargin());
            } else {
                BigDecimal resetPreRate = resetRow.get("cfresetpredictrate") == null ? BigDecimal.ZERO : (BigDecimal)resetRow.get("cfresetpredictrate");
                muUseRate = resetPreRate.add(this.getRateMargin());
            }
            resetRow.put("cfuserate", muUseRate);
            resetRow.put("cfmarginamt", this.getAmount().multiply(this.getRateMargin().divide(Constants.ONE_HUNDRED)).multiply(this.getBaseBasis(resetRow)));
        } else {
            resetRow.put("cfratefixdate", this.model.getValue("startdate"));
            resetRow.put("cffixrate", this.getFixedRate());
            resetRow.put("cfuserate", this.getFixedRate());
        }
        this.calStartRowAmtWhenOneReset(cashFlowRow, resetRow, (Date)cashFlowRow.get("cfpaydate"), this.calPayDate(firstResetDate), dfs);
        resetRow.put("resetSize", -1);
        finalCashFlow.add(resetRow);
        if (isMuti) {
            HashMap<Date, List<Date>> dateMap = new HashMap<Date, List<Date>>();
            unAdjStartDate = firstResetDate;
            ArrayList<HashMap<String, Object>> resetRows = new ArrayList<HashMap<String, Object>>();
            while (PayFrequeEnum.getNextDateByPayfreq((Date)unAdjStartDate, (PayFrequeEnum)PayFrequeEnum.valueOf((String)term)).before(endResetDate)) {
                Date rateFixDate;
                ++no;
                resetRow = new HashMap(16);
                unAdjStartDate = PayFrequeEnum.getNextDateByPayfreq((Date)unAdjStartDate, (PayFrequeEnum)PayFrequeEnum.valueOf((String)term));
                resetRow.put("cfreferindexfreq", term);
                resetRow.put("cfunadjstartdate", unAdjStartDate);
                unAdjEndDate = PayFrequeEnum.getNextDateByPayfreq((Date)unAdjStartDate, (PayFrequeEnum)PayFrequeEnum.valueOf((String)term));
                if (unAdjEndDate.before(endResetDate)) {
                    resetRow.put("cfunadjenddate", unAdjEndDate);
                } else {
                    resetRow.put("cfunadjenddate", endResetDate);
                }
                resetRow.put("id", DBServiceHelper.genGlobalLongId());
                resetRow.put("pid", pid);
                resetRow.put("no", unNo + "." + no);
                resetRow.put("cfresetpaydate", cashFlowRow.get("cfpaydate"));
                resetRow.put("cfadjstartdate", this.calPayDate(workDateMap, (Date)resetRow.get("cfunadjstartdate")));
                resetRow.put("cfadjenddate", this.calPayDate(workDateMap, (Date)resetRow.get("cfunadjenddate")));
                periodDays = this.calPeriodDays((Date)resetRow.get("cfadjstartdate"), (Date)resetRow.get("cfadjenddate"));
                resetRow.put("cfperioddays", periodDays);
                resetRow.put("cfbasis", this.getBasis());
                resetRow.put("cfisadjust", !this.getAdjustMethod().equals(AdjustMethodEnum.no_adjust.getValue()));
                resetRow.put("cfratefixindex", referRateDO);
                resetRow.put("cfreferindexfreq", term);
                if (isStages) {
                    resetRow.put("cfresetfreq", isAfter ? term : this.getPayFreq());
                }
                resetRow.put("cfratemargin", this.getRateMargin());
                if (this.isRateResetFoward()) {
                    rateFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)this.getWorkCalendars(), (Date)((Date)resetRow.get("cfadjstartdate")), (int)(-this.getRateResetOffSet()), (AdjustMethodEnum)AdjustMethodEnum.backward);
                    resetRow.put("cfratefixdate", rateFixDate);
                } else {
                    rateFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)this.getWorkCalendars(), (Date)((Date)resetRow.get("cfadjenddate")), (int)(-this.getRateResetOffSet()), (AdjustMethodEnum)AdjustMethodEnum.backward);
                    resetRow.put("cfratefixdate", rateFixDate);
                }
                if (rateFixDate.after(this.getReferDate())) {
                    Date indexDate = TermUtils.getDateByTerm((String)RateTermEnum.valueOf((String)term).getName(), (Date)rateFixDate);
                    dateMap.put(rateFixDate, Collections.singletonList(indexDate));
                    resetRow.put("indexDate", indexDate);
                    resetRows.add(resetRow);
                } else {
                    resetRow.put("indexDate", null);
                    resetRows.add(resetRow);
                }
                resetRow.put("cfmarginamt", this.getAmount().multiply(this.getRateMargin().divide(Constants.ONE_HUNDRED)).multiply(this.getBaseBasis(resetRow)));
                resetRow.put("resetSize", -1);
                finalCashFlow.add(resetRow);
            }
            if (!resetRows.isEmpty()) {
                Map furRateByYieldCurveResult = new HashMap(15);
                if (!dateMap.isEmpty()) {
                    long begin = System.currentTimeMillis();
                    furRateByYieldCurveResult = MarketDataHelper.getFurRateByBatchYieldCurve((IFormView)this.view, (YieldTypeEnum)YieldTypeEnum.ref, (DynamicObject)this.getPriceRule(this.model), (Long)this.getMarket(this.model)[0], (Date)this.getReferDate(), dateMap);
                    long end = System.currentTimeMillis();
                    logger.info("\u6279\u91cf\u901a\u8fc7\u6536\u76ca\u7387\u66f2\u7ebf\u83b7\u53d6\u8fdc\u671f\u5229\u7387\u8017\u65f6\uff1a" + (end - begin) + "\u6beb\u79d2");
                }
                for (Map map : resetRows) {
                    Date indexDate = (Date)map.remove("indexDate");
                    if (!EmptyUtil.isEmpty((Object)indexDate) && furRateByYieldCurveResult != null) {
                        map.put("cfresetpredictrate", furRateByYieldCurveResult.get(indexDate));
                    }
                    BigDecimal resetPreRate = map.get("cfresetpredictrate") == null ? BigDecimal.ZERO : (BigDecimal)map.get("cfresetpredictrate");
                    BigDecimal muUseRate = resetPreRate.add(this.getRateMargin());
                    map.put("cfuserate", muUseRate);
                }
            }
        }
        cashFlowRow.put("resetSize", no);
        long endTime = System.currentTimeMillis();
        logger.info("\u751f\u6210\u91cd\u7f6e\u73b0\u91d1\u6d41\u8017\u65f6\uff1a" + (endTime - beginTime) + "\u6beb\u79d2");
    }

    private void fillFinalCashFlow(List<Map<String, Object>> finalCashFlow, Map<Date, BigDecimal> Dfs) {
        int i = 0;
        Date lastPayDate = null;
        while (i < finalCashFlow.size()) {
            Map<String, Object> cashFlowRow = finalCashFlow.get(i);
            int resetSize = (Integer)cashFlowRow.get("resetSize");
            if (resetSize > 1) {
                ArrayList<Map<String, Object>> resetRowList = new ArrayList<Map<String, Object>>(resetSize);
                for (int j = 1; j <= resetSize; ++j) {
                    resetRowList.add(finalCashFlow.get(i + j));
                }
                this.calStartRowAmtWhenMultiReset(cashFlowRow, resetRowList, (Date)cashFlowRow.get("cfpaydate"), lastPayDate, Dfs);
            }
            lastPayDate = (Date)cashFlowRow.get("cfpaydate");
            i = i + resetSize + 1;
        }
    }

    private void calStartRowAmtWhenMultiReset(Map<String, Object> startRow, List<Map<String, Object>> resetRowList, Date payDay, Date payDayBefore, Map<Date, BigDecimal> dfs) {
        BigDecimal amount;
        BigDecimal orPricipal = (BigDecimal)startRow.get("cfosprincipal");
        CashFlowTypeEnum rateType = (CashFlowTypeEnum)startRow.get("cftype");
        if (CashFlowTypeEnum.floatrate == rateType) {
            BigDecimal useRate = BigDecimal.ONE;
            for (Map<String, Object> resetRow : resetRowList) {
                BigDecimal baseBasis = this.getBaseBasis(resetRow);
                BigDecimal tempUseRate = (BigDecimal)resetRow.get("cfuserate");
                useRate = useRate.multiply(BigDecimal.ONE.add(tempUseRate.divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis)));
            }
            useRate = useRate.subtract(BigDecimal.ONE);
            amount = orPricipal.multiply(useRate);
            if (this.isPayDateFoward() && this.isDiscount().booleanValue()) {
                amount = payDayBefore == null ? amount.multiply(dfs.get(payDay)) : amount.multiply(dfs.get(payDay).divide(dfs.get(payDayBefore), 10, 4));
            }
        } else {
            return;
        }
        amount = amount.multiply(this.getAmtDir());
        amount = this.roundDecimal(amount);
        startRow.put("cfamount", amount);
        startRow.put("cfpayamount", amount);
        startRow.put("cfinterest", amount);
        Date payDate = (Date)startRow.get("cfpaydate");
        BigDecimal dft_1 = dfs.get(TcDateUtils.getLastDay((Date)payDate, (int)1));
        if (dft_1 == null) {
            dft_1 = BigDecimal.ZERO;
        }
        BigDecimal disCFactor = dfs.get(payDate);
        startRow.put("cftheta", this.roundDecimal(disCFactor.subtract(dft_1).multiply(amount)).negate());
        startRow.put("cfpv", this.roundDecimal(amount.multiply(disCFactor)));
    }

    private void calStartRowAmtWhenOneReset(Map<String, Object> startRow, Map<String, Object> resetRow, Date payDay, Date payDayBefore, Map<Date, BigDecimal> dfs) {
        BigDecimal useRate = (BigDecimal)resetRow.get("cfuserate");
        BigDecimal orPricipal = (BigDecimal)startRow.get("cfosprincipal");
        BigDecimal baseBasis = this.getBaseBasis(resetRow);
        CashFlowTypeEnum rateType = (CashFlowTypeEnum)startRow.get("cftype");
        BigDecimal amount = BigDecimal.ZERO;
        if (CashFlowTypeEnum.fixedrate == rateType || CashFlowTypeEnum.floatrate == rateType) {
            amount = orPricipal.multiply(useRate.divide(Constants.ONE_HUNDRED, 10, 4)).multiply(baseBasis);
            if (this.isPayDateFoward() && this.isDiscount().booleanValue()) {
                amount = payDayBefore == null ? amount.multiply(dfs.get(payDay)) : amount.multiply(dfs.get(payDay).divide(dfs.get(payDayBefore), 10, 4));
            }
        }
        amount = amount.multiply(this.getAmtDir());
        amount = this.roundDecimal(amount);
        startRow.put("cfamount", amount);
        startRow.put("cfpayamount", amount);
        startRow.put("cfinterest", amount);
        Date payDate = (Date)startRow.get("cfpaydate");
        BigDecimal dft_1 = dfs.get(TcDateUtils.getLastDay((Date)payDate, (int)1));
        if (dft_1 == null) {
            dft_1 = BigDecimal.ONE;
        }
        BigDecimal disCFactor = dfs.get(payDate);
        startRow.put("cftheta", this.roundDecimal(disCFactor.subtract(dft_1).multiply(amount)).negate());
        startRow.put("cfpv", this.roundDecimal(amount.multiply(disCFactor)));
    }

    private int calPeriodDays(Date startDate, Date endDate) {
        DynamicObjectCollection workCalendarsColl = this.getWorkCalendars();
        return TradeBusinessHelper.getBasis_BetweenDay((Date)startDate, (Date)endDate, (BasisEnum)BasisEnum.getEnum((String)this.getBasis()), (DynamicObject[])((DynamicObject[])workCalendarsColl.toArray((Object[])new DynamicObject[0])));
    }

    private Date[] genIntDate(List<Map<String, Object>> cashFlow) {
        Date[] intDate = new Date[cashFlow.size() * 2];
        int i = 0;
        for (Map<String, Object> cashFlowRow : cashFlow) {
            intDate[i] = (Date)cashFlowRow.get("cfpaydate");
            intDate[i + 1] = TcDateUtils.getLastDay((Date)intDate[i], (int)1);
            i += 2;
        }
        return intDate;
    }

    protected Map<Date, BigDecimal> getDfs(Date referDate, DynamicObject priceRule, Date[] intDate) {
        Long[] marketId = this.getMarket(this.model);
        PriceRuleInfo prInfo = MarketDataHelper.getDiscfactor((IFormView)this.view, (Date)referDate, (DynamicObject)priceRule, (Long[])marketId, (Date[])intDate);
        return prInfo.getYieldCurve()[0].getDfMap();
    }

    protected Date calPayDate(Date unAdjDate) {
        if (unAdjDate == null) {
            return null;
        }
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.getEnumByValue((String)this.getAdjustMethod());
        return TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)this.getWorkCalendars(), (Date)unAdjDate, (AdjustMethodEnum)adjustMethodEnum);
    }

    private Date calPayDate(Map<Date, Boolean> workDateMap, Date unAdjDate) {
        if (unAdjDate == null) {
            return null;
        }
        AdjustMethodEnum adjustMethodEnum = AdjustMethodEnum.getEnumByValue((String)this.getAdjustMethod());
        Date date = TradeBusinessHelper.callAdjustSettleDateForCache(workDateMap, (Date)unAdjDate, (AdjustMethodEnum)adjustMethodEnum);
        return date;
    }

    public static Map<Date, Boolean> getWorkCalendarMap(DynamicObjectCollection workCalendars, Date beginDate, Date endDate) {
        if (workCalendars == null || workCalendars.size() == 0) {
            return new HashMap<Date, Boolean>(10);
        }
        Long[] wcIds = workCalendars.stream().map(w -> w.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList()).toArray(new Long[1]);
        return WorkCalendarHelper.getDateTypeMap((Long[])wcIds, (Date)TcDateUtils.getLastDay((Date)beginDate, (int)10), (Date)TcDateUtils.getNextDay((Date)endDate, (int)10));
    }

    private BigDecimal getExchangeRate(String swapType) {
        if (swapType.equals(SwapTypeEnum.currency.getValue())) {
            return this.getExchangeRate();
        }
        return BigDecimal.ONE;
    }

    protected BigDecimal getExchangeRate() {
        return null;
    }

    private String getPayfreq(CashFlowTypeEnum type) {
        String payFreq = this.getPayFreq();
        boolean isCapital = type == CashFlowTypeEnum.capital;
        boolean isPayStage = this.isPayStage();
        if (isCapital || !isPayStage) {
            return null;
        }
        return payFreq;
    }

    private boolean isFreqAfter(String term, String payFreq) {
        boolean isAfer = false;
        PayFrequeEnum payFreqEnum = PayFrequeEnum.valueOf((String)payFreq);
        int month = payFreqEnum.getMonth();
        int day = payFreqEnum.getDay();
        Map termMap = TermUtils.getYMD((String)term);
        int termMonth = (Integer)termMap.get("y") * 12 + (Integer)termMap.get("m");
        int termDay = (Integer)termMap.get("d");
        if (month > termMonth) {
            isAfer = true;
        } else if (month == termMonth && day > termDay) {
            isAfer = true;
        }
        return isAfer;
    }

    @Override
    protected Map<String, Object> buildBillUpdateData(Map<String, Object> cashFlow) {
        return null;
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        return null;
    }

    @Override
    protected Date[] getIntDate(Map<String, Object> cashFlow, ModelAgent model) {
        return new Date[]{(Date)cashFlow.get("cfpaydate")};
    }

    @Override
    protected String getFilter() {
        return null;
    }

    protected abstract Date getValueDate();

    protected abstract boolean isRateFloat();

    protected abstract boolean isRateResetFoward();

    protected abstract boolean isPayStage();

    protected abstract int getRateResetOffSet();

    protected abstract String getAdjustMethod();

    protected abstract String getBasis();

    protected abstract DynamicObject getReferRate();

    protected abstract String getPayFreq();

    protected abstract BigDecimal getFixedRate();

    protected abstract BigDecimal getFirstFixedRate();

    protected abstract BigDecimal getRateMargin();

    protected abstract DynamicObjectCollection getWorkCalendars();

    protected abstract boolean isPayDateFoward();

    protected abstract boolean isStub();

    protected abstract boolean isStubFront();

    protected abstract Date getFirstCopDate();

    protected abstract Date getPenuCopDate();

    protected abstract DynamicObject getCurrency();

    protected abstract boolean isRateQuoteDays();

    protected abstract BigDecimal getAmount();

    protected abstract Boolean isDiscount();

    protected BigDecimal getBaseBasis(Map<String, Object> resetRow) {
        BasisEnum basis = BasisEnum.getEnum((String)this.getBasis());
        String payFreq = this.getPayFreq();
        PayFrequeEnum freq = null;
        if (this.isPayStage() && BasisEnum.ICMA_Actual_actual == basis && this.freqPeriodResolver == null) {
            freq = PayFrequeEnum.valueOf((String)payFreq);
            Date firstCop = this.getFirstCopDate();
            Date penuCopDate = this.getPenuCopDate();
            Date valueDate = this.getValueDate();
            boolean isStub = this.isStub();
            boolean isStubFront = this.isStubFront();
            DynamicObjectCollection wc = this.getWorkCalendars();
            Date endDate = (Date)this.model.getValue("enddate");
            String adjMethod = this.getAdjustMethod();
            this.freqPeriodResolver = new FreqPeriodListBean(valueDate, endDate, isStub, isStubFront, firstCop, penuCopDate, freq, AdjustMethodEnum.getEnumByValue((String)adjMethod), wc, true);
        }
        return TradeBusinessHelper.getBaseBasis((Date)((Date)resetRow.get("cfadjstartdate")), (Date)((Date)resetRow.get("cfadjenddate")), (BasisEnum)basis, (DynamicObject[])((DynamicObject[])this.getWorkCalendars().toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)(this.freqPeriodResolver != null ? this.freqPeriodResolver.getFreqEnum() : null), (FreqPeriodListBean)this.freqPeriodResolver);
    }

    protected abstract BigDecimal getInitAmount();

    protected abstract BigDecimal getEndAmount();

    protected abstract String getRateResetFreq();

    protected abstract BigDecimal getAmtDir();

    protected abstract DynamicObject getFirstReferRate();

    protected abstract DynamicObject getPenuReferRate();

    private BigDecimal roundDecimal(BigDecimal deci) {
        return deci.setScale(10, 4);
    }
}

