/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.rate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.tm.business.service.builder.rate.AbstractSwapsCashFlowBuilder;
import kd.tmc.tm.common.enums.ConfigPayTypeEnum;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;

public class RateSwapsBuyCashFlowBuilder
extends AbstractSwapsCashFlowBuilder {
    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        cashFlow.put("cfdirection", TradeDirectionEnum.buy.getValue());
    }

    @Override
    protected Date getValueDate() {
        return (Date)this.model.getValue("valuedate");
    }

    @Override
    protected boolean isRateFloat() {
        String rateType = (String)this.model.getValue("ratetype");
        return rateType.equals(RateTypeEnum.rate_float.getValue());
    }

    @Override
    protected boolean isRateResetFoward() {
        String rateResetType = (String)this.model.getValue("rateresettype");
        return rateResetType.equals(ConfigPayTypeEnum.forward.getValue());
    }

    @Override
    protected boolean isPayStage() {
        String payType = (String)this.model.getValue("paytype");
        return payType.equals(RateSwapsPayTypeEnum.pay_stages.getValue());
    }

    @Override
    protected int getRateResetOffSet() {
        return (Integer)this.model.getValue("rateresetoffset");
    }

    @Override
    protected String getAdjustMethod() {
        return (String)this.model.getValue("dateadjustmethod");
    }

    @Override
    protected String getBasis() {
        return (String)this.model.getValue("basis");
    }

    @Override
    protected DynamicObject getReferRate() {
        return (DynamicObject)this.model.getValue("refindex");
    }

    @Override
    protected String getPayFreq() {
        return (String)this.model.getValue("payfrequency");
    }

    @Override
    protected BigDecimal getFixedRate() {
        return (BigDecimal)this.model.getValue("fixedrate");
    }

    @Override
    protected BigDecimal getFirstFixedRate() {
        return (BigDecimal)this.model.getValue("firstfixedrate");
    }

    @Override
    protected BigDecimal getRateMargin() {
        return (BigDecimal)this.model.getValue("ratemargin");
    }

    @Override
    protected DynamicObjectCollection getWorkCalendars() {
        return (DynamicObjectCollection)this.model.getValue("payworkcalendar");
    }

    @Override
    protected boolean isPayDateFoward() {
        String payDateType = (String)this.model.getValue("paydatetype");
        return payDateType.equals(ConfigPayTypeEnum.forward.getValue());
    }

    @Override
    protected boolean isStub() {
        return (Boolean)this.model.getValue("stub");
    }

    @Override
    protected boolean isStubFront() {
        String stubType = (String)this.model.getValue("stubtype");
        return "front".equals(stubType);
    }

    @Override
    protected Date getFirstCopDate() {
        return (Date)this.model.getValue("firstpaycopdate");
    }

    @Override
    protected Date getPenuCopDate() {
        return (Date)this.model.getValue("penupaycopdate");
    }

    @Override
    protected DynamicObject getCurrency() {
        return (DynamicObject)this.model.getValue("currency");
    }

    @Override
    protected boolean isRateQuoteDays() {
        String rateQuoteType = (String)this.model.getValue("ratequotafreq");
        return rateQuoteType.equals(QuotaFrequency.Day.getValue());
    }

    @Override
    protected BigDecimal getAmount() {
        return (BigDecimal)this.model.getValue("amount");
    }

    @Override
    protected Boolean isDiscount() {
        return (Boolean)this.model.getValue("discount");
    }

    @Override
    protected BigDecimal getInitAmount() {
        return (BigDecimal)this.model.getValue("initexamount");
    }

    @Override
    protected BigDecimal getEndAmount() {
        return (BigDecimal)this.model.getValue("endexamount");
    }

    @Override
    protected String getRateResetFreq() {
        return ((BigDecimal)this.model.getValue("rateresetfreq")).intValue() + "m";
    }

    @Override
    protected BigDecimal getAmtDir() {
        return BigDecimal.ONE.negate();
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        DynamicObject market = (DynamicObject)model.getValue("market");
        return new Long[]{(Long)market.getPkValue()};
    }

    @Override
    protected BigDecimal getExchangeRate() {
        return (BigDecimal)this.model.getValue("nominalrate");
    }

    @Override
    protected DynamicObject getFirstReferRate() {
        return (DynamicObject)this.model.getValue("firstreferrate");
    }

    @Override
    protected DynamicObject getPenuReferRate() {
        return (DynamicObject)this.model.getValue("penureferrate");
    }
}

