/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.business.service.builder.rate;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.tm.business.service.builder.rate.AbstractSwapsCashFlowBuilder;
import kd.tmc.tm.common.enums.ConfigPayTypeEnum;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;

public class RateSwapsSellCashFlowBuilder
extends AbstractSwapsCashFlowBuilder {
    @Override
    protected void initOtherData(Map<String, Object> cashFlow) {
        cashFlow.put("cfdirection", TradeDirectionEnum.sell.getValue());
    }

    @Override
    protected Date getValueDate() {
        return (Date)this.model.getValue("recvaluedate");
    }

    @Override
    protected boolean isRateFloat() {
        String rateType = (String)this.model.getValue("recratetype");
        return rateType.equals(RateTypeEnum.rate_float.getValue());
    }

    @Override
    protected boolean isRateResetFoward() {
        String rateResetType = (String)this.model.getValue("recrateresettype");
        return rateResetType.equals(ConfigPayTypeEnum.forward.getValue());
    }

    @Override
    protected boolean isPayStage() {
        String payType = (String)this.model.getValue("recpaytype");
        return payType.equals(RateSwapsPayTypeEnum.pay_stages.getValue());
    }

    @Override
    protected int getRateResetOffSet() {
        return (Integer)this.model.getValue("recrateresetoffset");
    }

    @Override
    protected String getAdjustMethod() {
        return (String)this.model.getValue("recdateadjustmethod");
    }

    @Override
    protected String getBasis() {
        return (String)this.model.getValue("recbasis");
    }

    @Override
    protected DynamicObject getReferRate() {
        return (DynamicObject)this.model.getValue("recrefindex");
    }

    @Override
    protected String getPayFreq() {
        return (String)this.model.getValue("recpayfrequency");
    }

    @Override
    protected BigDecimal getFixedRate() {
        return (BigDecimal)this.model.getValue("recfixedrate");
    }

    @Override
    protected BigDecimal getFirstFixedRate() {
        return (BigDecimal)this.model.getValue("recfirstfixedrate");
    }

    @Override
    protected BigDecimal getRateMargin() {
        return (BigDecimal)this.model.getValue("recratemargin");
    }

    @Override
    protected DynamicObjectCollection getWorkCalendars() {
        return (DynamicObjectCollection)this.model.getValue("recworkcalendar");
    }

    @Override
    protected boolean isPayDateFoward() {
        String payDateType = (String)this.model.getValue("recpaydatetype");
        return payDateType.equals(ConfigPayTypeEnum.forward.getValue());
    }

    @Override
    protected boolean isStub() {
        return (Boolean)this.model.getValue("recstub");
    }

    @Override
    protected boolean isStubFront() {
        String stubType = (String)this.model.getValue("recstubtype");
        return "front".equals(stubType);
    }

    @Override
    protected Date getFirstCopDate() {
        return (Date)this.model.getValue("recfirstpaycopdate");
    }

    @Override
    protected Date getPenuCopDate() {
        return (Date)this.model.getValue("recpenupaycopdate");
    }

    @Override
    protected DynamicObject getCurrency() {
        return (DynamicObject)this.model.getValue("reccurrency");
    }

    @Override
    protected boolean isRateQuoteDays() {
        String rateQuoteType = (String)this.model.getValue("recratequotafreq");
        return rateQuoteType.equals(QuotaFrequency.Day.getValue());
    }

    @Override
    protected BigDecimal getAmount() {
        return (BigDecimal)this.model.getValue("recamount");
    }

    @Override
    protected Boolean isDiscount() {
        return (Boolean)this.model.getValue("recdiscount");
    }

    @Override
    protected BigDecimal getInitAmount() {
        return (BigDecimal)this.model.getValue("recinitexamount");
    }

    @Override
    protected BigDecimal getEndAmount() {
        return (BigDecimal)this.model.getValue("recendexamount");
    }

    @Override
    protected String getRateResetFreq() {
        return ((BigDecimal)this.model.getValue("recrateresetfreq")).intValue() + "m";
    }

    @Override
    protected BigDecimal getAmtDir() {
        return BigDecimal.ONE;
    }

    @Override
    protected Long[] getMarket(ModelAgent model) {
        DynamicObject market = (DynamicObject)model.getValue("recmarket");
        return new Long[]{(Long)market.getPkValue()};
    }

    @Override
    protected BigDecimal getExchangeRate() {
        return BigDecimal.ONE;
    }

    @Override
    protected DynamicObject getFirstReferRate() {
        return (DynamicObject)this.model.getValue("recfirstreferrate");
    }

    @Override
    protected DynamicObject getPenuReferRate() {
        return (DynamicObject)this.model.getValue("recpenureferrate");
    }
}

